
#include "execchromo.h"
#include "mainwin.h"
#include <iostream>

ChromoCombineWorker *execccw;

void *runchromocombine(void *ptr )
{
  if(execccw->useforce){
    cout<<"Force file is "<<execccw->forcefile<<endl;
      try{execccw->makeSuperFromFile(execccw->forcefile);}
      catch(string x){cout<<x<<endl;returnval(-4);};    
  }
  execccw->verbose=true;
 if(execccw->verbose)cout<<"Reading files"<<endl;
 int readfilesval=execccw->readFiles();
  if(readfilesval<=0){
    cerr<<"Error reading files!"<<endl;
    returnval(-10+readfilesval);return NULL; 
  }
  if(execccw->verbose)cout<<"Read files!"<<endl;
  try{
    execccw->getForceIds();
  }catch(string x){
    cout<<x<<endl;
    returnval(-2);return NULL; 
  }
  int validation=execccw->validateMatrices();
  if(validation<0){
    cerr<<"Cannot continue with invalid matrix structure!"<<endl;
    cout<<"Validation="<<validation<<endl;
    returnval(-30+validation);return NULL; 
  }
  if(execccw->verbose)cout<<"Validated files!"<<endl;
  execccw->finaliseData();
  if(execccw->verbose)cout<<"Finalised data!"<<endl;
  execccw->cval=execccw->calcC();
  if(execccw->verbose)cout<<"Calculated C!"<<endl;  
  execccw->writeFiles();
  if(execccw->verbose)cout<<"Files Written!"<<endl;  
  if(execccw->useforce){

    if(execccw->verbose) cout<<"applying force..."<<endl;
    execccw->applyForceFile();
    double forceC=execccw->calcC(true);
    if(execccw->writeForceFile(forceC)){
      string outfile=execccw->forcefileoutput;
      if(outfile.size()==0)outfile=execccw->forcefile;
      cout<<"Successfully written forcefile "<<outfile<<" with c value "<<forceC<<endl;
    }else{
      cerr<<"Warning: Failed to write continental force file with updated c!"<<endl;
      returnval(-5);
      return NULL;    
    }
  }
  if(execccw->cval<=0) {
    cout<<"WARNING: \"c\" has not been correctly estimated. You can either specify it manually (not advised), or follow the advise above and in the faq at www.paintmychromosomes.com to solve the problem with its estimation."<<endl;
    returnval(2);
  }else if(validation>0) {
    returnval(2);
    cout<<"WARNING: File validation problems -- see above."<<endl;
  }else{
    cout<<"Finished running chromocombine"<<endl;
    cout<<"When using these files with fineSTRUCTURE there is now no need to specify \"c\"."<<endl;
    returnval(1);
  }
  return NULL;    
}

void returnval(int rval){
     pthread_mutex_lock( &wxGetApp().msg_mutex);
    wxCommandEvent event( wxEVT_COMMAND_LISTBOX_SELECTED, RUNFINISHED_EVENT );
     wxGetApp().m_frame->GetEventHandler()->AddPendingEvent( event );  
    wxGetApp().isrunning=false;
    wxGetApp().rval=rval;
    pthread_mutex_unlock(& wxGetApp().msg_mutex);
}
