
#ifndef CHROMOCOMBINE_H
#define CHROMOCOMBINE_H

#include <wx/wx.h>
#include <vector>

#include "execchromo.h"
#include "../ChromoCombineFuns.h"

#define LIST_FILES_SELECTED 101
#define SELECTFILESBUTTON 102
#define SELECTDIRECTORYBUTTON 103
#define LIST_FILES_APPROVED 111
#define FORCEFILECBX 112
#define SELECTFORCEBUTTON 113
#define IGNORELENGTHSCBX 114
#define IGNOREMUTSCBX 115
#define AUTOOUTPUTFILEENDING 116
#define VALIDATEBUTTON 117
#define OUTPUTFILEBUTTON 118
#define PROCESSBUTTON 120
#define HELPBUTTON 121
#define ABOUTBUTTON 122
#define CLEARFILESBUTTON 123
#define COMPLETEREGIONSCBX 124

#define SELECTFORCEOUTPUTBUTTON 124
#define FORCEOUTPUTFILECBX 125

#define RUNFINISHED_EVENT 10000

using namespace std;
extern ChromoCombineWorker *execccw;

class ChromoCombineWindow : public wxFrame
{
  friend class SettingsIO;
public:
  ChromoCombineWindow(const wxString& title);
  void OnSelectFilesButton(wxCommandEvent & event);  
  void OnSelectDirectoryButton(wxCommandEvent & event);  
  void OnForceCbx(wxCommandEvent & event);
  void OnSelectForceButton(wxCommandEvent & event);
  void OnForceOutputCbx(wxCommandEvent & event);
  void OnSelectForceOutputButton(wxCommandEvent & event);
  void OnIgnoreLengthCbx(wxCommandEvent & event);
  void OnIgnoreMutsCbx(wxCommandEvent & event);
  void OnAutoOutputCbx(wxCommandEvent & event);
  void OnValidateButton(wxCommandEvent & event);
  void OnProcessButton(wxCommandEvent & event);
  void OnHelpButton(wxCommandEvent & event);
  void OnAboutButton(wxCommandEvent & event);  
  void OnOutputfileButton(wxCommandEvent & event);  
  void OnClearFilesButton(wxCommandEvent & event);  
  void OnCompleteRegionsCbx(wxCommandEvent & event);  
  
  void OnFileChoiceKeyDown(wxKeyEvent& event);
  void OnFileApprovedKeyDown(wxKeyEvent& event);

  bool validate();
  void process();
  void onRunFinished(wxCommandEvent& evt);

  bool needsvalidating;
  bool stopModel();
  void setToRunMode();
  void setToStopMode();
  void setStatus(int flag);
   
 protected:
  wxFlexGridSizer *fgs;
  wxFlexGridSizer *fgsLeft;
  wxFlexGridSizer *fgsCenter;
  wxFlexGridSizer *fgsRight;
  wxFlexGridSizer *fgsRightTop;
  wxFlexGridSizer *fgsRightBottom;

  wxPanel *panel;
  wxPanel *panelLeft;
  wxPanel *panelRight;
  wxPanel *panelRightTop;
  wxPanel *panelRightBottom;
  wxPanel *panelCenter;

  // left
  wxListBox *filesSelected;  
  wxButton *selectFilesButton;
  wxButton *selectDirectoryButton;
  wxButton *clearFilesButton;
  
// center
  wxPanel *panelCenterB;//  force file choice panel
  wxListBox *filesApproved;  

  wxTextCtrl *chromopainterrootBox;  
  wxTextCtrl *chromopainterendingBox;
  wxCheckBox *forcefileCbx;
  wxButton *selectForceButton;  
  wxTextCtrl *forcefileBox;  
  wxCheckBox *forceoutputfileCbx;
  wxButton *selectForceOutputButton;
  wxTextCtrl *forceoutputfileBox;
  wxButton *validateButton;
  // right
  wxPanel *panelRightB;// outputfile ending panel
 
  wxTextCtrl *outputfilerootBox;  
  wxCheckBox *autooutputfileendingCbx;
  wxTextCtrl *outputfileendingBox;
  wxCheckBox *ignorelengthsCbx;
  wxCheckBox *ignoremutsCbx;
  wxCheckBox *completeregionsCbx;
  wxButton *outputfileButton;
  
  wxButton *processButton;
  wxButton *helpButton;
  wxButton *aboutButton;
  ChromoCombineWorker *ccw;
  vector<string> possibleinputfiles;

};

#endif
