
#include "mainwin.h"
#include "chromo.xpm"

#include <wx/stdpaths.h>
#include <iostream>

#include "wx/thread.h"
#include <wx/tokenzr.h>
#include "wx/dynarray.h"
#include "chromogui.h"

const wxString modelchoices [2]= {wxT("Running LINKAGE Model"),wxT("Running NO-LINKAGE Model") };

ChromoPainterWindow::ChromoPainterWindow(const wxString& title)
       : wxFrame(NULL, wxID_ANY, title, wxDefaultPosition, wxSize(840, 780))
{
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\chromo.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);

  int widthall=840;
  int width=420;
  int widthobjects=400;
  int totheight=370;
  int totheightbottom=80;
  int totheighttop=totheight-totheightbottom;
  SetMinSize(wxSize(widthall,totheight));
  SetSize(wxSize(widthall,totheight));
  panel = new wxPanel(this,-1, wxPoint(0,0), wxSize(widthall,totheight));
  panel->SetMinSize( wxSize(widthall,totheight));
  panelRight = new wxPanel(panel,-1, wxPoint(0,0), wxSize(widthall-width,totheight));
  panelRight->SetMinSize( wxSize(widthall-width,totheight));
  panelLeft = new wxPanel(panel,-1, wxPoint(0,0), wxSize(width,totheight));
  panelLeft->SetMinSize( wxSize(width,totheight));

  panelBottom = new wxPanel(panelLeft,-1, wxPoint(0,0), wxSize(width,totheightbottom));
  panelBottom->SetMinSize( wxSize(width,totheightbottom));
  panelTop = new wxPanel(panelLeft,-1, wxPoint(0,0), wxSize(width,totheighttop));
  panelTop->SetMinSize( wxSize(width,totheighttop));

  fgs = new wxFlexGridSizer(1, 2, 0, 10);
  fgsLeft = new wxFlexGridSizer(2, 1, 0, 0);
  fgsRight = new wxFlexGridSizer(7, 1, 10, 10);
  fgsBottom = new wxFlexGridSizer(1, 2, 0, 0);
  fgsTop = new wxFlexGridSizer(12, 1, 0, 0);

  fgs->AddGrowableRow(0);
  fgs->AddGrowableCol(0);

  //fgsRight->AddGrowableRow(0);

  fgsLeft->AddGrowableCol(0);
  fgsLeft->AddGrowableRow(0);

  fgsBottom->AddGrowableCol(1);
  fgsTop->AddGrowableCol(0);

  fgs->Add(panelLeft,1,wxGROW);
  fgs->Add(panelRight,1,wxGROW);

  fgsLeft->Add(panelTop, 1,wxGROW);
  fgsLeft->Add(panelBottom, 1,wxGROW);

  haplofile=wxT("haplotypefile");
  recombfile=wxT("recombinationfile");
  donorfile=wxT("donorfile");
  outputfile=wxT("outputfile");
  haplodir=wxT(".");
  recombdir=wxT(".");
  donordir=wxT(".");
  outputdir=wxT(".");


  #if defined(__WXMSW__)
    filesep=wxT("\\");
  #else
    filesep=wxT("/");
  #endif

  modelType=new wxComboBox((wxWindow*)panelTop, MAINWIN_ID_LINKEDCHOICE, modelchoices[0],wxDefaultPosition,wxSize(widthobjects,30),2,
			    modelchoices,wxCB_READONLY);

  helpButton = new wxButton(panelTop, MAINWIN_ID_HELPBUTTON, wxT("Help on all options"),wxDefaultPosition,wxSize(widthobjects,30));
  haploButton = new wxButton(panelTop, MAINWIN_ID_HAPLOBUTTON, wxT("File: ")+haplodir+filesep+haplofile,wxDefaultPosition,wxSize(widthobjects,30));
  recombButton = new wxButton(panelTop, MAINWIN_ID_RECOMBBUTTON, wxT("File: ")+recombdir+filesep+recombfile,wxDefaultPosition,wxSize(widthobjects,30));

  donorcbx = new wxCheckBox(panelTop, MAINWIN_ID_DONORCBX, wxT("Donor list file (-f):"));
  donorcbx->SetValue(true);
  donorButton = new wxButton(panelTop, MAINWIN_ID_DONORBUTTON, wxT("File: ")+donordir+filesep+donorfile,wxDefaultPosition,wxSize(widthobjects,30));
  outputButton = new wxButton(panelTop, MAINWIN_ID_OUTPUTBUTTON, wxT("File: ")+outputdir+filesep+outputfile,wxDefaultPosition,wxSize(widthobjects,30));
  extrasBox=new wxTextCtrl(panelTop, -1, wxT(""),wxDefaultPosition,wxSize(widthobjects,30));

  runFakeButton = new wxButton(panelBottom, MAINWIN_ID_RUNFAKEBUTTON, wxT("See command"),wxDefaultPosition,wxSize(120,30));
  runButton = new wxButton(panelBottom, MAINWIN_ID_RUNBUTTON, wxT("RUN"),wxDefaultPosition,wxSize(widthobjects,30));

  fgsTop->Add(helpButton, 1,wxGROW);
  fgsTop->Add(modelType, 1,wxGROW);
  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Haplotype file (-g):")), 1,wxGROW);
  fgsTop->Add(haploButton, 1,wxGROW);
  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Recombination file (-r):")), 1,wxGROW);
  fgsTop->Add(recombButton, 1,wxGROW);

  fgsTop->Add(donorcbx, 1,wxGROW);
  fgsTop->Add(donorButton, 1,wxGROW);
  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Output file (-o):")), 1,wxGROW);
  fgsTop->Add(outputButton, 1,wxGROW);
  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Additional Flags:")), 1,wxGROW);
  fgsTop->Add(extrasBox, 1,wxGROW);

  fgsBottom->Add(runFakeButton,1,wxGROW);
  fgsBottom->Add(runButton, 1,wxGROW);

  wxPanel *panelSpacer = new wxPanel(panelRight,-1, wxPoint(0,0), wxSize(widthall-width,30));
  panelSpacer->SetMinSize(wxSize(widthall-width,30));
  fgsRight->Add(panelSpacer);

  wxPanel *panelEM = new wxPanel(panelRight,-1, wxPoint(0,0), wxSize(widthall-width,200));
  wxBoxSizer * em_vert=new wxBoxSizer(wxVERTICAL);

  wxBoxSizer * em_horiz=new wxBoxSizer(wxHORIZONTAL);
  em_horiz->Add(new wxStaticText(panelEM, -1, wxT("EM Iterations (-i):")));
  emItersBox=new wxTextCtrl(panelEM, MAINWIN_ID_EMITERS, wxT("0"),wxDefaultPosition,wxSize(100,20));
  em_horiz->Add(emItersBox);
  em_vert->Add(em_horiz);

//  wxBoxSizer * em_horiz2=new wxBoxSizer(wxHORIZONTAL);
//  wxBoxSizer * em_horiz3=new wxBoxSizer(wxHORIZONTAL);
  enNeCbx = new wxCheckBox(panelEM, MAINWIN_ID_EMITERSCBX, wxT("recombination scaling constant (N_e)"));
  enCpCbx = new wxCheckBox(panelEM, MAINWIN_ID_EMITERSCBX, wxT("copying proportions"));
  enMuCbx = new wxCheckBox(panelEM, MAINWIN_ID_EMITERSCBX, wxT("mutation (emission) probabilities"));
  enGmuCbx = new wxCheckBox(panelEM, MAINWIN_ID_EMITERSCBX, wxT("global mutation probability"));
/*  em_horiz2->Add(enNeCbx);
  em_horiz2->Add(enCpCbx);
  em_horiz3->Add(enMuCbx);
  em_horiz3->Add(enGmuCbx);
  fgsRight->Add(em_horiz2);
  fgsRight->Add(em_horiz3);  */

  em_vert->Add(enNeCbx);
  em_vert->Add(enCpCbx);
  em_vert->Add(enMuCbx);
  em_vert->Add(enGmuCbx);
  panelEM->SetSizerAndFit(em_vert);
  fgsRight->Add(panelEM);

  wxBoxSizer * chunksperregion_horiz=new wxBoxSizer(wxHORIZONTAL);
  chunksperregion_horiz->Add(new wxStaticText(panelRight, -1, wxT("Chunks per region (-k):")));
  chunksBox=new wxTextCtrl(panelRight, MAINWIN_ID_CHUNKSPERREGION, wxT("100"),wxDefaultPosition,wxSize(100,20));
  chunksperregion_horiz->Add(chunksBox);
  fgsRight->Add(chunksperregion_horiz);

  wxBoxSizer * samplesperrecip_horiz=new wxBoxSizer(wxHORIZONTAL);
  samplesperrecip_horiz->Add(new wxStaticText(panelRight, -1, wxT("Samples per recipient (-s):")));
  samplesBox=new wxTextCtrl(panelRight, MAINWIN_ID_SAMPLESPERRECIPIENT, wxT("10"),wxDefaultPosition,wxSize(100,20));
  samplesperrecip_horiz->Add(samplesBox);
  fgsRight->Add(samplesperrecip_horiz);

  wxPanel *panelMisc = new wxPanel(panelRight,-1, wxPoint(0,0), wxSize(widthall-width,200));
  wxBoxSizer * misc_vert=new wxBoxSizer(wxVERTICAL);

  haploidCbx = new wxCheckBox(panelMisc, -1, wxT("Haploid individuals (-j)?"));
  misc_vert->Add(haploidCbx);
  conditionOwnCbx = new wxCheckBox(panelMisc, -1, wxT("Condition on own Pop (-c)?"));
  misc_vert->Add(conditionOwnCbx);
  priorCbx = new wxCheckBox(panelMisc, -1, wxT("Use prior probabilities in donor list file (-p)?"));
  misc_vert->Add(priorCbx);

  panelMisc->SetSizerAndFit(misc_vert);
  fgsRight->Add(panelMisc);

  Connect(MAINWIN_ID_HELPBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnHelpButton));
  Connect(MAINWIN_ID_LINKEDCHOICE, wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(ChromoPainterWindow::OnLinkedChoice));
  Connect(MAINWIN_ID_HAPLOBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnHaploButton));
  Connect(MAINWIN_ID_RECOMBBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnRecombButton));
  Connect(MAINWIN_ID_DONORCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnDonorCbx));
  Connect(MAINWIN_ID_DONORBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnDonorButton));
  Connect(MAINWIN_ID_OUTPUTBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnOutputButton));
  Connect(MAINWIN_ID_RUNBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnRunButton));
  Connect(MAINWIN_ID_RUNFAKEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnRunFakeButton));
  Connect(RUNFINISHED_EVENT, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(ChromoPainterWindow::onRunFinished));
  Connect(MAINWIN_ID_EMITERS, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(ChromoPainterWindow::OnEMiters));
  Connect(MAINWIN_ID_EMITERSCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(ChromoPainterWindow::OnEmCbx));
  Connect(MAINWIN_ID_CHUNKSPERREGION, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(ChromoPainterWindow::OnChunksPerRegion));
  Connect(MAINWIN_ID_SAMPLESPERRECIPIENT, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(ChromoPainterWindow::OnSamplesPerRecip));
//  Connect(wxID_ANY, wxEVT_IDLE, wxIdleEventHandler(ChromoPainterWindow::OnIdle));


#if wxUSE_STATUSBAR
    CreateStatusBar(1);
#endif // wxUSE_STATUSBAR

  panelBottom->SetSizerAndFit(fgsBottom);
  panelTop->SetSizerAndFit(fgsTop);
  panelLeft->SetSizerAndFit(fgsLeft);
  panelRight->SetSizerAndFit(fgsRight);
  panel->SetSizerAndFit(fgs);
  Centre();

  modelType->SetToolTip(wxT("Linked model (default) or Unlinked model (-u)"));
  haploButton->SetToolTip(wxT("-g <geno.filein> haplotype file, see ChromoPainter Manual (REQUIRED)"));
  recombButton->SetToolTip(wxT("-r <recommap.filein>, see ChromoPainter Manual (REQUIRED)"));
  donorcbx->SetToolTip(wxT("Disable donor file with -a 0 0 switch. Set in additional flags for other -a options."));
  donorButton->SetToolTip(wxT("-f <donorlist.filein> file listing breakdown of donor haps by population"));
  outputButton->SetToolTip(wxT("-o <outputfile prefix> (for the multiple files generated)"));
  extrasBox->SetToolTip(wxT("Anything not covered above, e.g. -n, -m, -M, -a, -b"));
  runButton->SetToolTip(wxT("RUN the analysis.  Can take a while!"));
  emItersBox->SetToolTip(wxT("-i, <int> number of EM iterations for estimating parameters"));
  enNeCbx->SetToolTip(wxT("-in  maximize over recombination scaling constant (N_e) using E-M"));
  enCpCbx->SetToolTip(wxT("ip  maximize over copying proportions using E-M"));
  enMuCbx->SetToolTip(wxT("-im  maximize over mutation (emission) probabilities using E-M"));
  enGmuCbx->SetToolTip(wxT("-iM  maximize over global mutation (emission) probability using E-M"));
  chunksBox->SetToolTip(wxT("-k <double>  specify number of expected chunks to define a 'region'"));
  samplesBox->SetToolTip(wxT("-s <int>  number of samples per recipient haplotype"));
  haploidCbx->SetToolTip(wxT("-j,  specify that individuals are haploid"));
  conditionOwnCbx->SetToolTip(wxT("-c,  condition on own population's individuals (default is to condition only on donor haps)"));
  priorCbx->SetToolTip(wxT("-p,  prior copying probabilities are in donor list file"));

  wxGetApp().m_frame=this;


  /*
    /// *** OPTIONS NOT INCLUDED IN THE GUI:
       -n <double>  recombination scaling constant start-value (N_e; default=400000 divided by number of donor haplotypes)
       -m <double>  specify to use mutation (emission) probabilities in donor list file (and provide self-copying mutation rate -- if -c switch is NOT specified this value will be ignored)
       -M <double>  global mutation (emission) probability (default=Li & Stephen's (2003) fixed estimate)
       -a <a_1> <a_2>  condition individuals a_1 through a_2 on every other individual (use '-a 0 0' to do all inds)
       -b  print-out zipped file with suffix '.copyprobsperlocus.out' containing prob each recipient copies each donor at every SNP (note: file can be quite large)
  */


}

void ChromoPainterWindow::OnHelpButton(wxCommandEvent & event) {
  wxString helpfile=wxString(helpfilestring, wxConvUTF8);

  wxMessageBox(helpfile,wxT("ChromoPainter help"));

}

void ChromoPainterWindow::OnLinkedChoice(wxCommandEvent & event) {
  if(modelType->GetValue()==modelchoices[0]) {
    recombButton->Enable();
  }else {
    recombButton->Disable();
  }
}

void ChromoPainterWindow::OnHaploButton(wxCommandEvent & event) {
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Haplotype file"),haplodir,haplofile);
  if (openFileDialog->ShowModal() == wxID_OK){
    haplodir=openFileDialog->GetDirectory();
    haplofile=openFileDialog->GetFilename();
    haploButton->SetLabel( wxT("File: ")+haplodir+filesep+haplofile);
  }
}

void ChromoPainterWindow::OnRecombButton(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Recombination file"),recombdir,recombfile);
  if (openFileDialog->ShowModal() == wxID_OK){
    recombdir=openFileDialog->GetDirectory();
    recombfile=openFileDialog->GetFilename();
      recombButton->SetLabel( wxT("File: ")+recombdir+filesep+recombfile);
  }
}

void ChromoPainterWindow::OnDonorCbx(wxCommandEvent & event) {
  if(donorcbx->IsChecked()){
    donorButton->Enable();
  }else{
    donorButton->Disable();
  }
}

void ChromoPainterWindow::OnDonorButton(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Donor file"),donordir,donorfile);
  if (openFileDialog->ShowModal() == wxID_OK){
    donordir=openFileDialog->GetDirectory();
    donorfile=openFileDialog->GetFilename();
      donorButton->SetLabel( wxT("File: ")+donordir+filesep+donorfile);
  }
}

void ChromoPainterWindow::OnOutputButton(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select Output file"),outputdir,outputfile,wxT("*.*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    outputdir=openFileDialog->GetDirectory();
    outputfile=openFileDialog->GetFilename();
      outputButton->SetLabel( wxT("File: ")+outputdir+filesep+outputfile);
  }
}

void ChromoPainterWindow::runModel(bool fake){

  vector<wxString> runarguments;

  runarguments.push_back(wxT("chromogui"));
  runarguments.push_back(wxT("-g"));
  runarguments.push_back(haplodir+filesep+haplofile);
  if(modelType->GetValue()==modelchoices[0]){
    runarguments.push_back(wxT("-r"));
    runarguments.push_back(recombdir+filesep+recombfile);
  }else{
    runarguments.push_back(wxT("-u"));
  }
  if(donorcbx->IsChecked()){
    runarguments.push_back(wxT("-f"));
    runarguments.push_back(donordir+filesep+donorfile);
  }else{
    runarguments.push_back(wxT("-a"));
    runarguments.push_back(wxT("0"));
    runarguments.push_back(wxT("0"));
  }
  runarguments.push_back(wxT("-o"));
  runarguments.push_back(outputdir+filesep+outputfile);

  int emiters=wxAtoi(emItersBox->GetValue());
  if(emiters>0){
    if(enNeCbx->GetValue() || enCpCbx->GetValue() || enMuCbx->GetValue() || enGmuCbx->GetValue()){
      runarguments.push_back(wxT("-i"));
      wxString emitersWx;
      emitersWx<<emiters;
      runarguments.push_back(emitersWx);
      if(enNeCbx->GetValue()) runarguments.push_back(wxT("-in"));
      if(enCpCbx->GetValue()) runarguments.push_back(wxT("-ip"));
      if(enMuCbx->GetValue()) runarguments.push_back(wxT("-im"));
      if(enGmuCbx->GetValue()) runarguments.push_back(wxT("-iM"));
    }
  }
  int chunksk=wxAtoi(chunksBox->GetValue());
  if(chunksk>0){
      runarguments.push_back(wxT("-k"));
      wxString chunkskWx;
      chunkskWx<<chunksk;
      runarguments.push_back(chunkskWx);
  }
  int sampless=wxAtoi(samplesBox->GetValue());
  if(sampless>0){
      runarguments.push_back(wxT("-s"));
      wxString samplesWx;
      samplesWx<<sampless;
      runarguments.push_back(samplesWx);
  }
  if(haploidCbx->GetValue()) runarguments.push_back(wxT("-j"));
  if(conditionOwnCbx->GetValue()) runarguments.push_back(wxT("-c"));
  if(priorCbx->GetValue()) runarguments.push_back(wxT("-p"));

  wxString tmp=extrasBox->GetValue();
  wxStringTokenizer tokenizer(tmp, wxT(" "));
  while ( tokenizer.HasMoreTokens() )
    {
      wxString token = tokenizer.GetNextToken();
        runarguments.push_back(token);
      // process token here
    }
  runarguments.push_back(wxT("--internalerrors"));
  if(fake){
    wxString arg;
    for(unsigned int c1=0;c1<runarguments.size();c1++) arg<<runarguments[c1]<<wxT("\n");
    wxMessageBox(arg,wxT("Command line will be:"));
    return;
  }

  if ( wxGetApp().isrunning ){
       wxLogError(wxT("Only permitted one thread"));
       return;
  }
  wxGetApp().runarguments=runarguments;

  wxGetApp().isrunning=true;
  void *nullmessage=NULL;

  pthread_create( &(wxGetApp().threadhandle), NULL, runchromopainter, nullmessage);
#if wxUSE_STATUSBAR
    SetStatusText(_T("Running chromopainter.  This may take a while."));
#endif // wxUSE_STATUSBAR
}

bool ChromoPainterWindow::stopModel(){
    pthread_mutex_lock( &wxGetApp().msg_mutex);
    if(wxGetApp().isrunning){
      pthread_cancel(wxGetApp().threadhandle);
//      pthread_kill(wxGetApp().threadhandle,-1);
      wxGetApp().isrunning=false;
    }
#if wxUSE_STATUSBAR
    SetStatusText(_T("Chromopainter process killed."));
#endif // wxUSE_STATUSBAR
    pthread_mutex_unlock( &wxGetApp().msg_mutex);
    return(true);
}


void ChromoPainterWindow::setToRunMode(){
    panelTop->Enable();
    panelRight->Enable();
    runButton->SetLabel(wxT("Run"));
}

void ChromoPainterWindow::setToStopMode(){
    panelTop->Disable();
    panelRight->Disable();
    runButton->SetLabel(wxT("Cancel execution"));
#if wxUSE_STATUSBAR
//    m_frame->SetStatusText(_T(""));
#endif // wxUSE_STATUSBAR
}

void ChromoPainterWindow::OnRunFakeButton(wxCommandEvent & event){
  runModel(true);
}

void ChromoPainterWindow::OnRunButton(wxCommandEvent & event){
  if(! wxGetApp().isrunning ){
    runModel();
    setToStopMode();
  }else{
    stopModel();
    setToRunMode();
    wxMessageBox(wxT("Terminated painting. Warning: outputfiles may be corrupted."));
  }
}

void ChromoPainterWindow::setStatus(bool flag)
{
#if wxUSE_STATUSBAR
      if(flag==1)SetStatusText(_T("Chromopainter: completed succesfully."));
      if(flag==0)SetStatusText(_T(""));
      if(flag==-1)SetStatusText(_T("Chrompainter: unknown error."));
#endif // wxUSE_STATUSBAR
}

void ChromoPainterWindow::OnEMiters(wxCommandEvent & event)
{
    if(emItersBox->GetValue()==wxT("")) return;
    int val=wxAtoi(emItersBox->GetValue());
    wxString myval;
    myval<<val;
    if(val<0) {
      emItersBox->SetValue(wxT("0"));
      wxMessageBox(wxT("Value must be >=0."), wxT("Input Validation"));
    }
    if(val<=0)OnEmCbx(event);
}

void ChromoPainterWindow::OnEmCbx(wxCommandEvent & event)
{
    int val=wxAtoi(emItersBox->GetValue());
    if(val==0){
      enNeCbx->SetValue(false);
      enCpCbx->SetValue(false);
      enMuCbx->SetValue(false);
      enGmuCbx->SetValue(false);
      wxMessageBox(wxT("You must set a positive value for the number of EM iterations (-i) before choosing what to do EM for."), wxT("Input Validation"));
    }
    if(enMuCbx->GetValue()==true && enGmuCbx->GetValue()==true) {
      enMuCbx->SetValue(false);
      enGmuCbx->SetValue(false);
      wxMessageBox(wxT("Cannot maximise over both mutation and global mutation probabilities."), wxT("Input Validation"));
    }
}

void ChromoPainterWindow::OnChunksPerRegion(wxCommandEvent & event){
    if(chunksBox->GetValue()==wxT("")) return;
    int val=wxAtoi(chunksBox->GetValue());
    wxString myval;
    myval<<val;
    if(val<=0) {
      chunksBox->SetValue(wxT("100"));
      wxMessageBox(wxT("Value must be >0."), wxT("Input Validation"));
    }
}

void ChromoPainterWindow::OnSamplesPerRecip(wxCommandEvent & event){
    if(samplesBox->GetValue()==wxT("")) return;
    int val=wxAtoi(samplesBox->GetValue());
    wxString myval;
    myval<<val;
    if(val<=0) {
      samplesBox->SetValue(wxT("10"));
      wxMessageBox(wxT("Value must be >0."), wxT("Input Validation"));
    }
}

 /*
void ChromoPainterWindow::OnIdle(wxIdleEvent& event)
{
     cout<<"Idle check: "<<waitingforrun<<", "<<wxGetApp().m_threads.Count()<<endl;
    wxCriticalSectionLocker enter(wxGetApp().m_critsect);
    if(waitingforrun && wxGetApp().m_threads.Count()==0){
      cout<<"Run has finished."<<endl;
      setToRunMode();
      waitingforrun=false;
      //successBox();


    }
    event.Skip();

}*/

