
#ifndef CHROMOPAINTER_H
#define CHROMOPAINTER_H

#define MAINWIN_ID_LINKEDCHOICE 500
#define MAINWIN_ID_HAPLOBUTTON 501
#define MAINWIN_ID_RECOMBBUTTON 502
#define MAINWIN_ID_DONORBUTTON 503
#define MAINWIN_ID_OUTPUTBUTTON 504
#define MAINWIN_ID_RUNBUTTON 505
#define MAINWIN_ID_EMITERS 506
#define MAINWIN_ID_EMITERSCBX 507
#define MAINWIN_ID_CHUNKSPERREGION 508
#define MAINWIN_ID_SAMPLESPERRECIPIENT 509
#define MAINWIN_ID_DONORCBX 510
#define MAINWIN_ID_HELPBUTTON 511
#define MAINWIN_ID_RUNFAKEBUTTON 512

#define RUNFINISHED_EVENT 100000

#include <wx/wx.h>
#include <vector>

#include "execchromo.h"

extern "C" {
#include "../ChromoPainterMutEM.h"
}

using namespace std;

class ChromoPainterWindow : public wxFrame
{
  friend class SettingsIO;
public:
  ChromoPainterWindow(const wxString& title);
  void OnHelpButton(wxCommandEvent & event);
  void OnLinkedChoice(wxCommandEvent & event);
  void OnHaploButton(wxCommandEvent & event);
  void OnRecombButton(wxCommandEvent & event);
  void OnDonorCbx(wxCommandEvent & event);
  void OnDonorButton(wxCommandEvent & event);
  void OnOutputButton(wxCommandEvent & event);
  void OnRunButton(wxCommandEvent & event);
  void OnRunFakeButton(wxCommandEvent & event);
  void OnEMiters(wxCommandEvent & event);
  void OnEmCbx(wxCommandEvent & event);
  void OnChunksPerRegion(wxCommandEvent & event);
  void OnSamplesPerRecip(wxCommandEvent & event);

  void onRunFinished(wxCommandEvent& evt)
    {
      setToRunMode();
      setStatus(evt.GetInt());
    }

  void runModel(bool fake=false);
  bool stopModel();
  void setToRunMode();
  void setToStopMode();
  void setStatus(bool flag);


 protected:
  wxString haplofile,recombfile,donorfile,outputfile;
  wxString haplodir,recombdir,donordir,outputdir;
  wxString filesep;
// BUTTONS:
  wxFlexGridSizer *fgsBottom;
  wxFlexGridSizer *fgsTop;
  wxFlexGridSizer *fgsRight;
  wxFlexGridSizer *fgsLeft;
  wxFlexGridSizer *fgs;
  wxPanel *panel;
  wxPanel *panelTop;
  wxPanel *panelLeft;
  wxPanel *panelRight;
  wxPanel *panelBottom;

  wxButton *helpButton;
  wxComboBox *modelType;
  wxButton *haploButton;
  wxButton *recombButton;
  wxCheckBox *donorcbx;
  wxButton *donorButton;
  wxButton *outputButton;

  wxButton *runFakeButton;
  wxButton *runButton;


  wxTextCtrl *extrasBox;

  wxCheckBox *enNeCbx;
  wxCheckBox *enCpCbx;
  wxCheckBox *enMuCbx;
  wxCheckBox *enGmuCbx;
  wxTextCtrl *emItersBox;

  wxTextCtrl *chunksBox;
  wxTextCtrl *samplesBox;

  wxCheckBox *haploidCbx;
  wxCheckBox *conditionOwnCbx;
  wxCheckBox *priorCbx;

};

#endif
