
#ifndef REORDERALL_H
#define REORDERALL_H

#include <wx/wx.h>
#include <wx/listbox.h>
//#include <wx/listctrl.h>
//#include <wx/dnd.h>
#include <wx/event.h>

#include "inputdata.h"
#include "reorderpop.h"

#define REORDERALL_ID_OKBUTTON 901
#define REORDERALL_ID_CANCELBUTTON 902
#define REORDERALL_ID_NEWORDER 903
#define REORDERALL_ID_UPBUTTON 904
#define REORDERALL_ID_DOWNBUTTON 905
#define REORDERALL_ID_APPLYBUTTON 906

using namespace std;


class ReorderAll : public wxFrame
{
  public:
  ReorderAll(InputData *inputdata,wxPanel *parent, int id,const wxString& title);
  void OnOkButton(wxCommandEvent & event);
  void OnApplyButton(wxCommandEvent & event);
  void OnSize(wxSizeEvent & event);
  vector<int> getFullIndex();
  inline void OnUpButton(wxCommandEvent & event){
    itemup();
  };
  inline void OnDownButton(wxCommandEvent & event){
    itemdown();
  };
 // void OnListDrag(wxListEvent & event);
  inline void OnCancelButton(wxCommandEvent & event){
    Close(true);
  };
  inline void OnMiddleWheel(wxMouseEvent & event){
      if(event.ControlDown()){
          if(event.GetWheelRotation()>0) itemup();
          else itemdown();
      }else event.Skip();
  }
  void OnDClick(wxMouseEvent & event);

  void itemup();
  void itemdown();
  protected:
    int draggeditem;
  wxPanel *toppanel;
  wxPanel *parent;
  wxScrolledWindow * scroller;
  wxButton *okButton;
  wxButton *cancelButton;
  wxButton *applyButton;
  wxButton *upButton;
  wxButton *downButton;
  int popnumber;
  InputData *inputdata;
  wxListBox *neworder;
  vector<int> oldindex;
  vector<int> newindex;
  wxArrayString oldvals;


};


#endif
