#ifndef SCALE_H
#define SCALE_H

#include <wx/wx.h>
#include <float.h>
#include <vector>

#include "visgrid.h"
#include "heatmap.h"

using namespace std;

class Scale : public wxVirtualPanel
{
public:
  Scale(Heatmap *hm,VisGrid *visgrid,wxPanel *parent, int id );
  Scale(VisGrid *visgrid,wxPanel *parent, int id );
  inline void setHM(Heatmap *hm){
    this->hm=hm;
  }
  inline void setSize(int s){
    size=s;
    SetMinSize(wxSize(s,-1));
    SetSize(wxSize(s,-1),wxSIZE_FORCE);
  };  
  inline void setSize(wxSize s){
    size=s.x;
    SetMinSize(s);
    SetSize(s,wxSIZE_FORCE);
  };    
  inline int getSize(){
    return(size);
  }
  void OnSize(wxSizeEvent& event);
  void OnPaint(wxPaintEvent& event);  
  void show(wxDC&  dc);
  
  void showLabels(wxDC&  dc,vector<wxString> labels,vector<double> vals,wxSize size,int ymin,int yrange);
  void cleanupLabels(vector<wxString> &labels,vector<double> &vals);
  long convertValToY(double val,int ymin,int yrange);
protected:
  int size;
 // int textsize;
  VisGrid *visgrid;
  Heatmap *hm;
};

#endif
