
#ifndef SCALECHOOSER_H
#define SCALECHOOSER_H

#include <wx/wx.h>
#include <wx/grid.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/combobox.h>
#include <wx/arrstr.h>
#include <wx/colordlg.h>
#include <wx/cmndata.h>

#include "heatmap.h"

#define SCALECHOOSER_ID_OKBUTTON 1
#define SCALECHOOSER_ID_CANCELBUTTON 2
#define SCALECHOOSER_ID_INFERBUTTON 3
//#define SCALECHOOSER_ID_NEWBUTTON 4
#define SCALECHOOSER_ID_APPLYBUTTON 5
#define SCALECHOOSER_ID_DEFAULTSBOX 6

using namespace std;

class ScaleChooser : public wxFrame
{
  public:
  ScaleChooser(Heatmap *heatmap,wxPanel *parent, int id,const wxString& title);
  void OnOkButton(wxCommandEvent & event);
  void OnApplyButton(wxCommandEvent & event);
  void OnSize(wxSizeEvent & event);
  void OnInferButton(wxCommandEvent & event);
  void OnDefaultChoice(wxCommandEvent & event);
  inline void OnCancelButton(wxCommandEvent & event){
    Close(true);
  };
  void OnGridCellClick(wxGridEvent &event);
  void OnGridCellChanged(wxGridEvent &event);
  void OnGridKeyDown(wxKeyEvent &event);
  void UpdateOnColourChange(int row,wxColour newcolour);
  void UpdateOnLabelEdit(int row);
  wxColour getCol(vector<int> rgbval);
  wxString colVecAsString(vector<int> rgbval);
  
  void updateGrid(vector<vector<int> > hmcols, vector<double> hmtimes);
  void updateGrid(vector<vector<double> > hmcols, vector<double> hmtimes);
  void reorderRows(int changedrow);
  void removeRow(int rowrem);
  void assignNewColour(int row,wxString valwx);
  protected:

  wxPanel *toppanel;
  wxPanel *parent;
  wxGrid * namegrid;
  wxScrolledWindow * scroller;
  wxComboBox *defaultsBox;
  wxButton *okButton;
  wxButton *applyButton;
  wxButton *cancelButton;
  wxButton *inferButton;
  wxButton *newButton;
  wxFlexGridSizer *vsizer;
  wxFlexGridSizer *hsizer;
  Heatmap *heatmap;
  
  vector<vector<int> > hmcols;
  vector<double> hmtimes;
};

#endif
