#ifndef SHOWLABELS_H
#define SHOWLABELS_H

#include <wx/wx.h>
#include <vector>

#include "inputdata.h"
#include "visgrid.h"
#include "../node.h"
#include "../data.h"


using namespace std;

class ShowLabels : public wxVirtualPanel
{
public:
  ShowLabels(InputData *indat,VisGrid *visgrid,bool isylab,wxPanel *parent, int id);


  void setGrid();

  void OnSize(wxSizeEvent& event);
  void OnPaint(wxPaintEvent& event);
  void OnLeftDown(wxMouseEvent & event);  
  inline void setSize(int s){
    if(isylab) SetMinSize(wxSize(-1,s));
    else SetMinSize(wxSize(s,-1));
    if(isylab) SetSize(wxSize(-1,s),wxSIZE_FORCE);
    else SetSize(wxSize(s,-1),wxSIZE_FORCE);
    mysize=s;
  };
  inline int getSize(){
    return(mysize);
//    wxSize s=GetMinSize();
//    if(isylab) return(s.y);
//    else return(s.x);
  };
  double getLefting(Node* node);///< lefting of the node, correcting for possibly missing continents
  int GetFontSize(int numlinespace);
  void show(wxDC&  dc);
protected:
  int mysize;
  wxPanel *m_parent;
  InputData *dat;
  VisGrid *visgrid;
  vector <int> textpts;
  int textsize;
  int classifyboxsize;
  bool isylab;
  std::vector<Node*> nodes;

};

#endif
