#ifndef SHOWTREE_H
#define SHOWTREE_H

#include <wx/wx.h>
#include <vector>

#include "inputdata.h"
#include "visgrid.h"
#include "../node.h"
#include "../data.h"
#include "reorderpop.h"
#include "reorderall.h"

using namespace std;

class FineDisplay;

class ShowTree : public wxVirtualPanel
{
public:
  ShowTree(InputData *indat,VisGrid *visgrid,bool isylab,FineDisplay *parent, int id);

  void OnSize(wxSizeEvent& event);
  void OnPaint(wxPaintEvent& event);
  void OnLeftDown(wxMouseEvent & event);
  double getLefting(Node* node);///< lefting of the node, correcting for possibly missing continents
  inline void setSize(int s){
    if(isylab) SetMinSize(wxSize(-1,s));
    else SetMinSize(wxSize(s,-1));
    if(isylab) SetSize(wxSize(-1,s),wxSIZE_FORCE);
    else SetSize(wxSize(s,-1),wxSIZE_FORCE);
    size=s;
  };
  inline int getSize(){
    return(size);
//    wxSize s=GetMinSize();
//    if(isylab) return(s.y);
//    else return(s.x);
  };
  void show(wxDC&  dc);
protected:
  int size;
  FineDisplay *m_parent;
  VisGrid *visgrid;
  InputData *dat;
  vector <int> textpts;
  int textsize;
  bool isylab;
  std::vector<Node*> nodes;

};

#endif
