
#include <wx/progdlg.h>

#include "finegui.h"
#include "mainwin.h"
#include "settings_io.h"

IMPLEMENT_APP(FineGui)

using namespace std;

bool FineGui::OnInit()
{
  disabledisplay=false;
  rungui=true;
  finestructurefile=wxT("");
  copyfile=wxT("");
  mcmcfile=wxT("");
  treefile=wxT("");
  mcmcfile2=wxT("");
  treefile2=wxT("");
  
   processArgs();
    wxString openfile;
    if(!rungui){
      return false;
    }

    FineMainWindow *mainwin = new FineMainWindow(wxT("Finestructure GUI"));

    if (copyfile.size()>0) mainwin->setCopyFile(copyfile);
    if (fixedfile.size()>0) mainwin->setFixedFile(fixedfile);
    if (mcmcfile.size()>0) mainwin->setMcmcFile(mcmcfile);
    if (treefile.size()>0) mainwin->setTreeFile(treefile);
    if ((mcmcfile2.size()>0)||(treefile2.size()>0)) mainwin->SetupInputData2();
    if (mcmcfile2.size()>0) mainwin->setMcmcFile2(mcmcfile2);
    if (treefile2.size()>0) mainwin->setTreeFile2(treefile2);

    if (finestructurefile.size()>0){
      openfile=wxString(finestructurefile);
      cout<<"Will try to load file "<<std::string(openfile.mb_str()).c_str()<<endl;
    }
    

    SettingsIO *settings = new SettingsIO(mainwin);
    mainwin->setSettings(settings);
    if(!disabledisplay)   mainwin->setShowDisplay(true);
      
    mainwin->Show(true);

    settings->setFileName(wxT("."),openfile);
    if(openfile.size()>0){
    try{
      //settings->readTree();
    if(settings->openFileForReading()){
      if(disabledisplay)   mainwin->setShowDisplay(false);
      settings->readValues(NULL);
      settings->readValues(NULL,true);// second dataset
      vector <int> tpoporder=mainwin->getInputData()->getPopOrder();
      if(settings->shouldReadTree()) {
//	mainwin->getInputData()->setPopOrder(vector <int>());
	settings->readTree();
//	mainwin->getInputData()->applytree();
//	mainwin->getInputData()->setPopOrderFromTree();
      }
      settings->reopenFileForReading(); 
      settings->readSettings();
      settings->closeFileForReading();
      if(settings->shouldReadTree()) {// apply population order
	mainwin->getInputData()->reorderAll(tpoporder);
	mainwin->getInputData()->setPopOrderFromTree();
      }
      if(!disabledisplay)   mainwin->setShowDisplay(true);
    }
    }catch(std::string x){
      cout<<x<<endl;
      wxMessageBox(wxT("The requested file could not be opened as a finegui settings file."),wxT("Error opening file"));
    }
    }
    return true;
}


void FineGui::processArgs(){

  static const wxCmdLineEntryDesc g_cmdLineDesc [] =
  {
      { wxCMD_LINE_SWITCH, "h", "help", "displays help on the command line parameters",
	    wxCMD_LINE_VAL_NONE, wxCMD_LINE_OPTION_HELP },
      { wxCMD_LINE_SWITCH, "d","disableoutput", "disables the graphical output, for large data files" },
      {wxCMD_LINE_OPTION,"c","coinheritance","Set (without loading) the data (coinheritance) filename"},
      {wxCMD_LINE_OPTION,"F","fixed","Set (without loading) the fixed continent filename"},
      {wxCMD_LINE_OPTION,"m","mcmc","Set (without loading) the fineSTRUCTURE MCMC filename"},        
      {wxCMD_LINE_OPTION,"t","tree","Set (without loading) the fineSTRUCTURE Tree filename"},        
      {wxCMD_LINE_OPTION,"m2","mcmc","Set (without loading) the fineSTRUCTURE MCMC second filename"},        
      {wxCMD_LINE_OPTION,"t2","tree","Set (without loading) the fineSTRUCTURE Tree second filename"},        
      {wxCMD_LINE_OPTION,"f","finestructurefile","Load a fineSTRUCTURE settings file"},
      {wxCMD_LINE_PARAM,NULL,NULL,"Load a fineSTRUCTURE settings file",wxCMD_LINE_VAL_STRING,wxCMD_LINE_PARAM},
      { wxCMD_LINE_NONE },
  };
  wxCmdLineParser parser (g_cmdLineDesc, argc, argv);
  parser.Parse();
  if(parser.Found( wxT("h"))){
    rungui=false;
  }
  if(parser.Found( wxT("d"))){
    cout<<"Initially disabling graphical output"<<endl;
    disabledisplay=true;
  }
  parser.Found( wxT("f"),&finestructurefile);
  parser.Found( wxT("F"),&fixedfile);
  parser.Found( wxT("c"),&copyfile);
  parser.Found( wxT("m"),&mcmcfile);
  parser.Found( wxT("t"),&treefile);
  parser.Found( wxT("m2"),&mcmcfile2);
  parser.Found( wxT("t2"),&treefile2);
  if(parser.GetParamCount()>0) finestructurefile=parser.GetParam(0);
}

