#ifndef HEATMAP_H
#define HEATMAP_H

#include <wx/wx.h>
#include <float.h>
#include <vector>

#include "inputdata.h"
#include "visgrid.h"

using namespace std;

class Heatmap : public wxVirtualPanel
{
public:
  Heatmap(InputData *indat,InputData *indat2,VisGrid *visgrid,wxPanel *parent, int id );
  inline void showCopy(){
    visgrid->setDatavis(FSGUI_SHOW_COPYMATRIX);
  }
  inline void showPCM(){
    visgrid->setDatavis(FSGUI_SHOW_PCMMATRIX);
  }
  inline void showAggCopy(){
    visgrid->setDatavis(FSGUI_SHOW_COPYAGMATRIX);
  }
  inline void showAggCopySimple(){
    visgrid->setDatavis(FSGUI_SHOW_COPYAGMATRIXSIMPLE);
  }
  inline void showSingle(){
    visgrid->setDatavis2(FSGUI_SHOW_NONE);
  }
  inline void show2Copy(){
    visgrid->setDatavis2(FSGUI_SHOW_COPYMATRIX);
  }
  inline void show2PCM(){
    visgrid->setDatavis2(FSGUI_SHOW_PCMMATRIX);
  }
  inline void show2AggCopy(){
    visgrid->setDatavis2(FSGUI_SHOW_COPYAGMATRIX);
  }  
  inline double getMin(){
    return(smin);
  }
  inline double getMax(){
    return(smax);
  }
  inline vector<vector<double> > getScaleColours(){
    return(rgbpts);
  }
  inline vector<double> getScaleTimes(){
    return(rgbspeed);
  }
  vector<double> getDefaultSpeed();
  vector<vector<double> > getDefaultColours();
  inline void defaultScale(bool domin=true,bool domax=true){
    if(datX()<=0) return;
    if(domin) smin=DBL_MAX;
    if(domax) smax=DBL_MIN;
    int datavis=visgrid->getDatavis();
    for(int c1=0;c1<datX();c1++){
      for(int c2=0;c2<datY();c2++){
	if(domin) if(dat->getM(c1,c2,datavis)<smin && dat->getM(c1,c2,datavis) > 0) smin=dat->getM(c1,c2,datavis);
	if(domax) if(dat->getM(c1,c2,datavis)>smax) smax=dat->getM(c1,c2,datavis);
      }
    }
    if(smin==smax) smin=smax/1000.0;
  }///* Default scale: show whole range
  inline void setScale(){
    smax=visgrid->getScale();
    smin=visgrid->getScaleMin();
    defaultScale((smin<0),(smax<0));
  }
  wxColour getCol(double val);///* Gets the colour associated with a value
  wxColour getColNorm(double val);///* Gets the colour associated with a value (assumes (0,1) range)
  //inline void setScale(double smin_in, double smax_in){smin=smin_in;smax=smax_in;}///* Forces a particular scale
  void OnSize(wxSizeEvent& event);
  void OnPaint(wxPaintEvent& event);
  inline void OnErase(wxEraseEvent& event){};
  inline long datX(){
    return(dat->getMsize(false,visgrid->getDatavis()));
  }
  inline long datY(){
    return(dat->getMsize(true,visgrid->getDatavis()));
  }
  inline wxSize getSize(){
    return(size);
  }
  inline void setSize(wxSize newsize){
    size=newsize;
    SetSize(newsize);    
  }
  void defaultColours();
  vector<vector<double> > wxStringAsColourVector(wxString myval);
  vector<double> wxStringAsColourTimes(wxString myval);
  bool setColours(vector<vector<double> > rgbptsin,vector< double > speed);
  void show(wxDC&  dc);
  protected:
  wxSize size;
  wxPanel *m_parent;
  bool presetscale;
  double smin,smax; //scale min and max
  bool plotPops;
  vector< vector<double> > rgbpts;
  vector< double > rgbspeed;
  double totrgbspeed;
  VisGrid *visgrid;
  InputData *dat;
  InputData *dat2;  
};

#endif
