#include "inputdata.h"

//#define DEBUGPRINT(x) cout<<x<<endl
#define DEBUGPRINT(x)

wxVirtualPanel::wxVirtualPanel(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style, const wxString& name):
  wxPanel((wxPanel *)parent, id, pos, size, style,name)
{
}

void wxVirtualPanel::show(wxDC&  dc)
{
  cout<<"Showing in virtual mode"<<endl;
}

InputData::InputData(){
  popscale=1.0;
  rescaletree=false;
  d=NULL;
  dbackup=NULL;
  tree=NULL;
  beststate=NULL;
  copyfile=wxT("");
  copydir=wxT("");
  metafile=wxT("");
  metadir=wxT("");
  mcmcfile=wxT("");
  mcmcdir=wxT("");
  copyskip=0;
  copyxhead=true;
  copyyhead=true;
  treetestmax=10000;
  treehillclimbsteps=10000;
  treetype=3;
  td.push_back(vector<double> (1,0));
  makerng(false);
  mcmcburnin=10000;
  mcmcrunlength=10000;
  mcmcskip=100;
  mcmcconst=1.0;
  usefixedfile=false;
  usemod=false;
  supersize=1.0;
}


void InputData::importFromFile(const wxString& filename)
{
}

void InputData::exportToFile(const wxString& filename)
{
}

bool InputData::readCopyFile()
{
  wxFileName tmp2(copydir,copyfile);
  wxString tmp=tmp2.GetFullPath();
  cout<<"reading copy data: "<<tmp.mb_str()<<endl;
  Data *d2;
  try{
    d2=new Data(std::string(tmp.mb_str()),copyskip,copyyhead,copyxhead);
    if(d!=NULL) {delete(d); d=NULL;delete(dbackup); dbackup=NULL;}
    d=d2;
    if(usefixedfile) {
      cout<<"reading fixed file: "<<tmp.mb_str()<<endl;
      wxFileName tmp3(fixeddir,fixedfile);
      wxString tmp4=tmp3.GetFullPath();
      d->makeSuperFromFile(std::string(tmp4.mb_str()));
    }
    cout<<"success..."<<endl;
    defaultorder=vector<int>(d->getDim(),0);
    for(unsigned int c1=0;c1<defaultorder.size();c1++) defaultorder[c1]=c1;
    renamed.clear();
    renamed=vector<wxString>(d->getDim(),wxT(""));
    for(int c1=0;c1<d->getDim();c1++) renamed[c1]= wxString(d->getnames(c1).c_str(), wxConvUTF8);
    dbackup=new Data(d);
    calcModifierRaw(-1,-1);
    return(true);
  }catch(string str){
    cerr<<str<<endl;
//    wxMessageBox(wxString(str.c_str(), wxConvUTF8),wxT("Error reading copy file"));
    return(false);
  }
}

bool InputData::runMCMC(wxPanel *parent){
  wxFileName tmcmcfile(mcmcdir,mcmcfile);
  wxString tmcmcfilename=tmcmcfile.GetFullPath();
  if(d==NULL) return(false);// Can't read empty data!
  cout<<"generating mcmc: "<<tmcmcfilename.mb_str()<<endl;

    try{
    // open output file
    wxProgressDialog mcmcProg(wxT("MCMC running"), wxT("MCMC progress"),100, parent,
		wxPD_APP_MODAL | wxPD_CAN_ABORT | wxPD_ELAPSED_TIME | wxPD_AUTO_HIDE | wxPD_ESTIMATED_TIME | wxPD_REMAINING_TIME);
    mcmcProg.Update(0);
    filebuf fb;
    try{
    fb.open (std::string(tmcmcfilename.mb_str()).c_str(),ios::out);
    }catch(std::string x){
	cerr<<"Error opening file!"<<endl<<x<<endl; return 0;}
    ostream os (&fb);
    Data td(d);
  // generate state
    int betamod=BETAMOD_F2;
    int datainference = INFDATA_COUNTS;
    double corfactor=mcmcconst;
    int initpop=-1;
    double alpha=1.0;
     bool verbose=false;
    std::vector<double> bvec=getBvec(betamod,datainference,corfactor);
    State *state=new State(d,initpop,bvec,alpha,betamod,corfactor,NULL,datainference);/// gets deleted by InfMCMC

    InfMCMC infMCMC(d,state,NULL,datainference,0,verbose);
    infMCMC.exportXmlHead(&os,corfactor,mcmcburnin,mcmcrunlength,mcmcskip);
	infMCMC.exportXmlComment(&os,"");
	if(verbose) cout<<"BURN IN PHASE"<<endl;
	for(long c1=0;c1<mcmcburnin;c1++){
	  infMCMC.metropolis(c1,1,1,NULL,mcmcburnin);
	  if(!mcmcProg.Update(100.0*(double)c1/(double)mcmcburnin/2.0)){infMCMC.exportXmlTail(&os);fb.close();return(false);};
	}
	if(verbose) cout<<"MCMC PHASE"<<endl;
	infMCMC.resetCounters();
	for(long c1=0;c1<mcmcrunlength;c1++){
	  infMCMC.metropolis(c1,1,mcmcskip,&os,mcmcrunlength);
	  if(!mcmcProg.Update(100.0*((double)c1/(double)mcmcburnin/2.0+0.5))){infMCMC.exportXmlTail(&os);fb.close();return(false);};
	}
//    InfMCMC infMCMC=GlobalRunMCMC(d,state,&os,mcmcburnin,mcmcrunlength,mcmcskip,"",datainference,NULL,verbose);
	infMCMC.exportXmlTail(&os);
    fb.close();
	cout<<"success!"<<endl;
	//tree->printTree(&cout);
  }catch(string str){
    cerr<<str<<endl;
//    wxMessageBox(wxString(str.c_str(), wxConvUTF8),wxT("Error reading copy file"));
    return(false);
  }
  return(true);

}

bool InputData::readPairwiseCoincidence()
{
  wxFileName tmp2(mcmcdir,mcmcfile);
  wxString tmp=tmp2.GetFullPath();
  if(d==NULL) return(false);// Can't read empty data!
  cout<<"reading MCMC data: "<<tmp.mb_str()<<endl;
  try{
    FsXml *infile=new FsXml(std::string(tmp.mb_str()));
    infile->gotoLineContaining("<header>");
    try{
      wxString cvalstr(infile->getParam("inflation").c_str(), wxConvUTF8);
      setMcmcConst(cvalstr);
      cvalstr= wxString(infile->getParam("burnin").c_str(), wxConvUTF8);
      setMcmcBurnin(cvalstr);
      cvalstr= wxString(infile->getParam("mcmclength").c_str(), wxConvUTF8);
      setMcmcRuntime(cvalstr);
      cvalstr= wxString(infile->getParam("skip").c_str(), wxConvUTF8);
      setMcmcSkip(cvalstr);
      readdatafilename= wxString(infile->getParam("datafilename").c_str(), wxConvUTF8);
    }catch(string x){
      cout<<"Headers missing from output file."<<endl;
    }
    delete(infile);
    infile=new FsXml(std::string(tmp.mb_str()));
    InfExtract iext(d,infile,true);
    pcmat.clear();
    for(unsigned int c1=0;c1<iext.getMeanX()->size();c1++){

      pcmat.push_back(iext.getMeanX()->at(c1));
    }
    cout<<"success..."<<endl;
// get the header details if available
    delete infile;
  }catch(string str){
    cerr<<str<<endl;
    return(false);
//    wxMessageBox(wxString(str.c_str(), wxConvUTF8),wxT("Error reading copy file"));
  }
  return(true);
}

bool InputData::readMCMCtraces()
{
  wxFileName tmp2(mcmcdir,mcmcfile);
  wxString tmp=tmp2.GetFullPath();
  if(d==NULL) return(false);// Can't read empty data!
  cout<<"reading MCMC data: "<<tmp.mb_str()<<endl;
  try{
    FsXml *infile=new FsXml(std::string(tmp.mb_str()));
    infile->gotoLineContaining("<header>");
    try{
      wxString cvalstr(infile->getParam("inflation").c_str(), wxConvUTF8);
      setMcmcConst(cvalstr);
      cvalstr= wxString(infile->getParam("burnin").c_str(), wxConvUTF8);
      setMcmcBurnin(cvalstr);
      cvalstr= wxString(infile->getParam("mcmclength").c_str(), wxConvUTF8);
      setMcmcRuntime(cvalstr);
      cvalstr= wxString(infile->getParam("skip").c_str(), wxConvUTF8);
      setMcmcSkip(cvalstr);
      readdatafilename= wxString(infile->getParam("datafilename").c_str(), wxConvUTF8);
    }catch(string x){
      cout<<"Headers missing from output file."<<endl;
    }
    delete(infile);
    F.clear();
    alpha.clear();
    beta.clear();
    delta.clear();
    populations.clear();
    FsXml *fs=new FsXml(std::string(tmp.mb_str()));
    State *state=NULL;
    int betamod=BETAMOD_F2;
    int datainference = INFDATA_COUNTS;
    double corfactor=mcmcconst;
    std::vector<double> bvec=getBvec(betamod,datainference,corfactor);

/// ******    NOTE: The following assumes a BETAMOD_F2 model.  Will need to allow for other priors

    	streampos fpos=fs->gotoLineContaining("<Iteration>");
	int counts=0;
	while(!fs->eof() && fpos>=0) {
		counts++;
		if(fpos>0) state=new State(d,fs,bvec,1.0,betamod,corfactor,true,NULL,datainference);
		populations.push_back(state->getP());
		alpha.push_back(state->getAlpha());
		beta.push_back(state->getSumBeta());
		delta.push_back(state->getDelta(0));
		F.push_back(state->getBetaF(0));
		delete(state);
		fpos=fs->gotoNextLineContaining("<Iteration>");
	}
    cout<<"success..."<<endl;
// get the header details if available
    delete fs;
  }catch(string str){
    cerr<<str<<endl;
    return(false);
//    wxMessageBox(wxString(str.c_str(), wxConvUTF8),wxT("Error reading copy file"));
  }
  return(true);
}


void InputData::calcPopBranches()
{
    std::vector<Node*> nlist=getNodes();
    if(nlist.size()==0) return;
    popnodes=vector<int>(beststate->getP(),-1);
    popnames=vector<wxString>(beststate->getP(),wxT(""));
    indlist.clear();
    for(int popon=0;popon<beststate->getP();popon++){
      indlist.push_back(beststate->getIndInPop(popon));
    }
    int numcontsfound=0;
    contindex=vector<int>(d->numIgnore(),-1);
    for(unsigned long c1=0;c1<nlist.size();c1++){
      for(int popon=0;popon<beststate->getP();popon++){

	if(nlist[c1]->isPopNode(indlist[popon])){
	  wxString popnum;popnum<<popon;
	  if(indlist[popon].size()==1) popnames[popon]=getName(indlist[popon][0]);
	  else popnames[popon]=wxT("Pop")+popnum;
	  popnodes[popon]=nlist[c1]->getId();
//	  cout<<"Found pop "<<popon<<" as node "<<nlist[c1]->getId()<<"("<<c1<<")"<<endl;
//	  for(unsigned int c2=0;c2<indlist[popon].size();c2++) cout<<indlist[popon][c2]<<",";
//	  cout<<endl;
	  if(nlist[c1]->getFather()==NULL && nlist[c1]!=tree->getRoot()){
	    contindex[numcontsfound]=popon;
	    numcontsfound++;
	  }
	}
      }
    }
  /*  std::vector<Node*> tmpN=tree->getNodes();
    for(int c1=0;c1<6;c1++){
      int tmp=tree->whichPopNode(c1);
//      Node * tmpNp=
      //tmpN
      order[c1]=order[0];
      order[0]=tmp;
  }*/
}

void InputData::calcCopyAverages()
{
  popaverages=vector< vector<double> >(getNumPops(),vector<double>(getNumPops(),0.0));
  vector< vector<long> > tdenom=vector< vector<long> >(getNumPops(),vector<long>(getNumPops(),0));
  for(long c1=0;c1<getN();c1++){for(long c2=0;c2<getN();c2++){
    popaverages[beststate->getPop(c1)][beststate->getPop(c2)] += d->getMatrix()->at(c1)[c2];
    if(c1!=c2) tdenom[beststate->getPop(c1)][beststate->getPop(c2)]+= d->nindiv(c1)*d->nindiv(c2);
    else tdenom[beststate->getPop(c1)][beststate->getPop(c2)]+= d->nindiv(c1)*(d->nindiv(c2)-1);
  }}
  for(unsigned long c1=0;c1<popaverages.size();c1++){for(unsigned long c2=0;c2<popaverages[c1].size();c2++){
      if(tdenom[c1][c2]>0) popaverages[c1][c2] /= (double)tdenom[c1][c2];
  }}
}

bool InputData::generateTree(wxPanel* parent)
{
  wxFileName tmcmcfile(mcmcdir,mcmcfile);
  wxString tmcmcfilename=tmcmcfile.GetFullPath();
  if(d==NULL) return(false);// Can't read empty data!
cout<<"generating tree from "<<tmcmcfilename.mb_str()<<endl;// "<<ttreefilename.mb_str()<<"
  try{
    // open output file
    /*filebuf fb;
    try{
    fb.open (std::string(ttreefilename.mb_str()).c_str(),ios::out);
    }catch(std::string x){
	cerr<<"Error opening file!"<<endl<<x<<endl; return 0;}
    ostream os (&fb);*/
    Data td(d);
  // generate tree
    int betamod=BETAMOD_F2;
    int datainference = INFDATA_COUNTS;
    //double myalpha=1.0;
    double corfactor=mcmcconst;
    wxProgressDialog treeProg(wxT("Tree generation running"), wxT("Tree progress (nonlinear)"),100, parent,
		wxPD_APP_MODAL | wxPD_CAN_ABORT | wxPD_ELAPSED_TIME | wxPD_AUTO_HIDE);
    treeProg.Update(0);
    bool verbose=false;
    std::vector<double> bvec=getBvec(betamod,datainference,corfactor);

    Inf1 *tmptree = new Inf1(mergeTree(treetype, &td, std::string(tmcmcfilename.mb_str()),
		       treetestmax,treehillclimbsteps, corfactor,betamod, bvec,INFDATA_COUNTS,MODELTYPE_FINESTRUCTURE, NULL, NULL, true,false,0,verbose));
    treeProg.Update(50);
  // write tree
	if(beststate!=NULL) {delete(beststate);beststate=NULL;}
	beststate = new State(tmptree->getState());
	beststate->setData(d);


	try{tmptree->mergeHillClimb(NULL,false,true);}catch(std::string x){cout<<x<<endl;exit(0);}
    treeProg.Update(100);
	FsXml *infile=new FsXml(std::string(tmcmcfilename.mb_str()));
	InfExtract3 iext3(d,infile,tmptree->getNodes(),verbose);
	//FsXml *infile=new FsXml(fs);
	//	InfExtract3 iext3(d,infile,inf1.getNodes(),opt().verbose);
	//	delete(infile);
//	inf1.diagonaliseOnM(d->getMatrix(),false);

/*   	tmptree->printTree(&os);
	tmptree->exportXmlTail(&os);
	fb.close();*/

	cout<<"success!"<<endl;
	tmptree->printTree(&cout);
	if(tree!=NULL) delete(tree);

	tree=tmptree;
	calcPopBranches();
        applytree();
	calcPopBranches();
	calcCopyAverages();
	calcModifierAgg(-1,-1);
	displaylabels=vector<int>(getNumPops(),1);
	setPopOrderFromTree();
	informNodesOfPopStatus();
	applytree();
	if(!writeTree())return(false);
  }catch(string str){
    cerr<<str<<endl;

//    wxMessageBox(wxString(std::string(str.c_str()), wxConvUTF8),wxT("Error reading copy file"));
    return(false);
  }
  return(true);
}

bool InputData::writeTree()
{
  wxFileName ttreefile(treedir,treefile);
  wxString ttreefilename=ttreefile.GetFullPath();
    filebuf fb;
    try{
    fb.open (std::string(ttreefilename.mb_str()).c_str(),ios::out);
    }catch(std::string x){
	cerr<<"Error opening file!"<<endl<<x<<endl; return 0;}
    ostream os (&fb);
    tree->exportXmlHead(&os,std::string(mcmcfile.mb_str()),string("MergeTree"),mcmcconst,treehillclimbsteps);
    writeTree(&os);
    tree->exportXmlTail(&os);
    fb.close();
    return(true);
}

bool InputData::writeTree(ostream *os )
{
  try{
    if(beststate!=NULL) beststate->iterPrint(os);
    else throw(std::string("No state to print!"));
    if(tree!=NULL) tree->printTree(os);
    else throw(std::string("No tree to print!"));
  }catch(string x){
    cout<<x<<endl;
    return(false);
  }
  return(true);
}

bool InputData::readTree()
{

  wxFileName ttreefile(treedir,treefile);
  wxString ttreefilename=ttreefile.GetFullPath();
  return(readTree(ttreefilename));
}

bool InputData::readTree(wxString filename)
{
  if(d==NULL) return(false);// Can't read empty data!
  cout<<"Reading tree: "<<filename.mb_str()<<endl;
  try{
    int betamod=BETAMOD_F2;
    int datainference = INFDATA_COUNTS;
    double corfactor=mcmcconst;
    double alpha=1.0;
    std::vector<double> bvec=getBvec(betamod,datainference,corfactor);
    Inf1 *tmptree = new Inf1(GlobalReadTree(std::string(filename.mb_str()),d,alpha,corfactor,betamod,bvec,
	      datainference,MODELTYPE_FINESTRUCTURE,false));
	cout<<"success!"<<endl;
	if(beststate!=NULL) {delete(beststate);beststate=NULL;}
	beststate = new State(tmptree->getState());
	if(tree!=NULL) delete(tree);
	tree=tmptree;
	calcPopBranches();
	applytree();
	calcPopBranches();
	calcCopyAverages();
	calcModifierAgg(-1,-1);
	displaylabels=vector<int>(getNumPops(),1);
	setPopOrderFromTree();
	informNodesOfPopStatus();
	applytree();
  }catch(string str){
    cerr<<str<<endl;
//    wxMessageBox(wxString(str.c_str(), wxConvUTF8),wxT("Error reading copy file"));
    return(false);
  }
  return(true);
}

long InputData::insidePopNode(Node *n)
{
  std::vector<Node*> nodes=getNodes();
  while(true){
    for(unsigned long c1=0;c1<popnodes.size();c1++){
      if(n==nodes[popnodes[c1]]) return(c1);
    }
    if(n->getFather()==NULL)return(-1);
    n=n->getFather();
  }
  return(-1);
}

bool InputData::reorderPop(int popnum,vector<int> neworder)
{
   std::vector<Node*> nodes = getNodes();
   if(nodes.size()==0) return(false);
   int popnodenum=getPopNode(popnum);
   Node * poproot=nodes[popnodenum];
   //**** FIX THIS: tree can get negative distances
   //double dist=poproot->getLeft()->getDist();
   std::vector<int> internalind=poproot->internalsUnder();
   for(unsigned int c1=0;c1<internalind.size();c1++){
     nodes[internalind[c1]]->setLeft(nodes[neworder[c1]]);
     if(c1==internalind.size()-1)  nodes[internalind[c1]]->setRight(nodes[neworder[c1+1]]);
     else nodes[internalind[c1]]->setRight(nodes[internalind[c1+1]]);
   }
   applytree();
   return(true);
}

bool InputData::reorderAll(vector<int> neworder)
{
  vector<long> tcontorder(d->numIgnore(),-1);
  vector<long> torder(d->numIgnore(),-1);
  vector<double> newlefting(d->numIgnore(),-1);
  vector<wxString> oldpopnames(d->numIgnore(),wxT(""));

  int curcontinent=0;
  /// Calculate the new order of the continents (only)
  for(unsigned int c1=0;c1<neworder.size();c1++) {
    int found=-1;
/*    cout<<" pop "<<c1<<" go "<<getorder(c1)<<endl;
    for(unsigned int c2=0;c2<d->getDim();c2++) if(beststate->getPop(c2)==poporder[c1]){found=c2;break;}
    if(found<0) {cerr<<"Error in reorderall: invalid population!"<<endl;throw(string("Invalid population in reorderall"));}
    cout<<" Old="<<poporder[c1]<<" New="<<neworder[c1]<<" found="<<found<<endl;
    if(getorder(found)<d->numIgnore()) cout<<"Watching this"<<endl;*/

    for(unsigned int c2=0;c2<contindex.size();c2++) {
      if(neworder[c1]==contindex[c2]){// find out if this is a continent
	for(unsigned int c3=0;c3<poporder.size();c3++) {// find its position in the old list
	  if(neworder[c1]==poporder[c3]) {found=c3;break;}
	}
	if(found<0) {cerr<<"NOT FOUND POPULATION IN NEWORDER!"<<endl;throw(string("NOT FOUND POPULATION IN NEWORDER!"));}
	DEBUGPRINT("Oldindex="<<poporder[found]<<" Newindex="<<neworder[c1]);
	DEBUGPRINT("New location "<<c1<<" old location "<<found);
	DEBUGPRINT("Continent "<<std::string(popnames[contindex[c2]].mb_str()));
	DEBUGPRINT("Indiv "<<std::string(getName(order[c2]).mb_str()));
	// insert the population in the new order
	tcontorder[curcontinent] =contindex[c2];
	torder[curcontinent]     =order[c2];
	oldpopnames[curcontinent]=popnames[poporder[found]];
	newlefting[curcontinent]=getNodes()[popnodes[poporder[found]]]->getLefting();
	curcontinent++;
	break;//Go to next indiv in c1;
      }
    }
  }
  /// sort nodes into the visualised order
  sort(newlefting.begin(), newlefting.end());
  /// Apply the new order to the continents
  for(unsigned int c1=0;c1<torder.size();c1++){
    DEBUGPRINT("Placing Continent "<<std::string(popnames[tcontorder[c1]].mb_str())<<" at location "<<c1);
    DEBUGPRINT("Placing Individual "<<std::string(getName(torder[c1]).mb_str())<<" at location "<<c1);
    order[c1]=torder[c1];
    contindex[c1]=tcontorder[c1];
    popnames[neworder[c1]]=oldpopnames[c1];
    getNodes()[popnodes[neworder[c1]]]->setLefting(newlefting[c1]);
  }
  poporder=neworder;
  //applytree();
  /*for(unsigned int c1=0;c1<contindex.size();c1++) {
    cout<<"Location "<<poporder[c1]<<" ";
    cout<<"Continent "<<std::string(popnames[contindex[c1]].mb_str())<<" ... ";
    cout<<"Indiv "<<std::string(getName(order[c1]).mb_str())<<" ... ";
    cout<<"Contindex "<<contindex[c1]<<endl;
  }*/

  // popnames[getPopOrder(i) // this is how we get the population name
  // equiv: popnames[poporder[i]]
  // dat->getName(dat->getorder()->at(c1)); // this is how we get the individual name
  // equiv: getName(order[c1])
  return(true);
}

void InputData::reorderAllDefault(bool reset)
{
  if(tree==NULL) return;
  if(reset)poporder=vector<int>();

}

void InputData::calcModifierRaw(double min,double max)
{
  if(d==NULL) return;

  modifiedData.clear();
  vector<double> colMax(d->getDim(),DBL_MIN);
  vector<double> colMin(d->getDim(),DBL_MAX);
  vector<double> rowMax(d->getDim(),DBL_MIN);
  vector<double> rowMin(d->getDim(),DBL_MAX);

  /*
  contScaleRawCopyRatio=vector<double> (d->getDim(),0);
  contScaleRawScaleRatio=vector<double> (d->getDim(),0);
  double thiscontSum=0,othersum=0;
  int conton=0;
  int numinthis=d->getDim() - d->numSuper();
  */

  for(int c1=0;c1<d->getDim();c1++){
    modifiedData.push_back(vector<double> (d->getDim(),0));
    for(int c2=0;c2<d->getDim();c2++){
      if(c1!=c2) modifiedData[c1][c2] = d->getMatrix()->at(c1)[c2]/d->nindiv(c2)/d->nindiv(c1);
      else if(d->nindiv(c1)==0) modifiedData[c1][c2]=0;
      else modifiedData[c1][c2] = d->getMatrix()->at(c1)[c2]/d->nindiv(c2)/(d->nindiv(c1)-1);
/*
      if(d->nindiv(c2) > 1 && d->nindiv(c1)==1){
	contScaleRawCopyRatio[c2] += d->getMatrix()->at(c1)[c2];
  //      cout<<"Index["<<getorder()->at(c1)<<"]="<<contindex[getorder()->at(c1)]<<endl;
      }else if(d->nindiv(c1) == 1 && d->nindiv(c2)==1){
	thiscontSum+=d->getMatrix()->at(c1)[c2];
      }else {othersum +=d->getMatrix()->at(c1)[c2];}
      */
      if(colMax[c2]<modifiedData[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) colMax[c2]=modifiedData[c1][c2];
      if(colMin[c2]>modifiedData[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) colMin[c2]=modifiedData[c1][c2];
      if(rowMax[c1]<modifiedData[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) rowMax[c1]=modifiedData[c1][c2];
      if(rowMin[c1]>modifiedData[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) rowMin[c1]=modifiedData[c1][c2];

    }
  }

  double modifierRawMaxA=DBL_MIN;
  double modifierRawMinA=DBL_MAX;
  double modifierRawMaxB=DBL_MIN;
  double modifierRawMinB=DBL_MAX;

  for(int c1=0;c1<d->getDim();c1++){
    if(modifierRawMaxA<colMax[c1] && d->nindiv(c1)==1) modifierRawMaxA=colMax[c1];
    if(modifierRawMinA>colMin[c1] && d->nindiv(c1)==1) modifierRawMinA=colMin[c1];
    if(modifierRawMaxB<rowMax[c1] && d->nindiv(c1)==1) modifierRawMaxB=rowMax[c1];
    if(modifierRawMinB>rowMin[c1] && d->nindiv(c1)==1) modifierRawMinB=rowMin[c1];
  }
  if(min>0) modifierRawMinA=min;
  if(max>0) modifierRawMaxA=max;
  if(min>0) modifierRawMinB=min;
  if(max>0) modifierRawMaxB=max;
  for(int c1=0;c1<d->getDim();c1++){
    for(int c2=0;c2<d->getDim();c2++){
      //if((d->nindiv(c1)!=1 || d->nindiv(c2)!=1)&& !(d->nindiv(c1)!=1 && d->nindiv(c2)!=1) &&c1!=c2) cout<<"v="<<(modifiedData[c1][c2] - colMin[c2])/(colMax[c2]-colMin[c2])<<endl;
      //if(d->nindiv(c1)!=1) {contScaleRawScaleRatio[c1]=colMax[c1]-colMin[c1];
      //}else contScaleRawScaleRatio[c1]=1;
      if(d->nindiv(c2)!=1) modifiedData[c1][c2] = (modifiedData[c1][c2] - colMin[c2])/(colMax[c2]-colMin[c2])*(modifierRawMaxA-modifierRawMinA) + modifierRawMinA;
      if(d->nindiv(c1)!=1) modifiedData[c1][c2] = (modifiedData[c1][c2] - rowMin[c1])/(rowMax[c1]-rowMin[c1])*(modifierRawMaxB-modifierRawMinB) + modifierRawMinB;
      if(d->nindiv(c1)!=1 && d->nindiv(c2)!=1) modifiedData[c1][c2] = 0;
    }
  }
/*
  for(int c1=0;c1<contScaleRawCopyRatio.size();c1++){if(contScaleRawCopyRatio[c1]>0) contScaleRawCopyRatio[c1]=contScaleRawCopyRatio[c1]*numinthis/d->nindiv(c1)/thiscontSum;}
  for(int c1=0;c1<order.size();c1++){
    if(contScaleRawCopyRatio[order[c1]]>0){
      cout<<"Order="<<order[c1]<<" Cont = "<<d->getnames(order[c1])<<" ratio = "<<contScaleRawCopyRatio[order[c1]]<<" scale="<<contScaleRawScaleRatio[order[c1]]<<" range="<<colMin[order[c1]]<<"-"<<colMax[order[c1]]<<endl;
    }
  }*/
  contScaleRawMin=colMin;
  contScaleRawMax=colMax;
  contScaleRowRawMin=rowMin;
  contScaleRowRawMax=rowMax;

}

void InputData::calcModifierAgg(double min,double max)
{
  if(d==NULL) return;
  if(popaverages.size()==0) return;
  vector<double> colMax(d->getDim(),DBL_MIN);
  vector<double> colMin(d->getDim(),DBL_MAX);
  vector<double> rowMax(d->getDim(),DBL_MIN);
  vector<double> rowMin(d->getDim(),DBL_MAX);
  /*
  contScaleAggCopyRatio=vector<double> (getNumContinents(),0);
  contScaleAggScaleRatio=vector<double> (getNumContinents(),0);
  double thiscontSum=0;
  */
  modifiedData2.clear();
  for(int c1=0;c1<d->getDim();c1++){
    modifiedData2.push_back(vector<double> (d->getDim(),0));
    for(int c2=0;c2<d->getDim();c2++){
      modifiedData2[c1][c2] = popaverages[beststate->getPop(c1)][beststate->getPop(c2)];
      /*
      if(beststate->getPop(c1)<contindex.size()&& beststate->getPop(c2)>=contindex.size()){
	contScaleAggCopyRatio[beststate->getPop(c1)] += modifiedData2[c1][c2] * d->nindiv(beststate->getPop(c1));
  //      cout<<"Index["<<getorder()->at(c1)<<"]="<<contindex[getorder()->at(c1)]<<endl;
      }else if(c1>=contindex.size()&& c2>=contindex.size()){
	thiscontSum+=modifiedData2[c1][c2];
      }*/

      if(beststate->getPlength(beststate->getPop(c1))==beststate->getPsize(beststate->getPop(c1))){
	if(colMax[c2]<modifiedData2[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) colMax[c2]=modifiedData2[c1][c2];
	if(colMin[c2]>modifiedData2[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) colMin[c2]=modifiedData2[c1][c2];
      }
      if(beststate->getPlength(beststate->getPop(c2))==beststate->getPsize(beststate->getPop(c2))){
	if(rowMax[c1]<modifiedData2[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) rowMax[c1]=modifiedData2[c1][c2];
	if(rowMin[c1]>modifiedData2[c1][c2] && c1!=c2 && (!d->getIgnore(c1) || !d->getIgnore(c2))) rowMin[c1]=modifiedData2[c1][c2];
      }
    }
  }
  //for(int c1=0;c1<contScaleAggCopyRatio.size();c1++){cout<<"pop "<<c1<<" sum = "<<contScaleAggCopyRatio[c1]<<endl;}
  //cout<<"rest sum = "<<thiscontSum<<endl;
  //for(int c1=0;c1<d->getDim();c1++){cout<<colMin[c1]<<",";}
  //cout<<endl;
  double modifierRawMaxA=DBL_MIN;
  double modifierRawMinA=DBL_MAX;
  double modifierRawMaxB=DBL_MIN;
  double modifierRawMinB=DBL_MAX;
  for(int c1=0;c1<d->getDim();c1++){
    if(modifierRawMaxA<colMax[c1] && d->nindiv(c1)==1) modifierRawMaxA=colMax[c1];
    if(modifierRawMinA>colMin[c1] && d->nindiv(c1)==1) modifierRawMinA=colMin[c1];
    if(modifierRawMaxB<rowMax[c1] && d->nindiv(c1)==1) modifierRawMaxB=rowMax[c1];
    if(modifierRawMinB>rowMin[c1] && d->nindiv(c1)==1) modifierRawMinB=rowMin[c1];
  }
  if(min>0) modifierRawMinA=min;
  if(max>0) modifierRawMaxA=max;
  if(min>0) modifierRawMinB=min;
  if(max>0) modifierRawMaxB=max;

  for(int c1=0;c1<d->getDim();c1++){
    for(int c2=0;c2<d->getDim();c2++){
//      if((d->nindiv(c1)!=1 || d->nindiv(c2)!=1)&& !(d->nindiv(c1)!=1 && d->nindiv(c2)!=1) &&c1!=c2) cout<<"v="<<(modifiedData[c1][c2] - colMin[c2])/(colMax[c2]-colMin[c2])<<endl;
      if(d->nindiv(c2)!=1) modifiedData2[c1][c2] = (modifiedData2[c1][c2] - colMin[c2])/(colMax[c2]-colMin[c2])*(modifierRawMaxA-modifierRawMinA) + modifierRawMinA;
      if(d->nindiv(c1)!=1) modifiedData2[c1][c2] = (modifiedData2[c1][c2] - rowMin[c1])/(rowMax[c1]-rowMin[c1])*(modifierRawMaxB-modifierRawMinB) + modifierRawMinB;
      if(d->nindiv(c1)!=1 && d->nindiv(c2)!=1) modifiedData2[c1][c2] = 0;

    }
  }

  contScaleAggMin=colMin;
  contScaleAggMax=colMax;
  contScaleRowAggMin=rowMin;
  contScaleRowAggMax=rowMax;
}

void InputData::informNodesOfPopStatus(){
  std::vector<Node*> nodes=getNodes();
  for(unsigned int c1=0;c1<popnodes.size();c1++) {
    nodes[getPopNode(c1)]->tellPopNodes(nodes[getPopNode(c1)]);
  }
}

void InputData::applytree(){
    tree->getRoot()->calcChildrenBelow(popscale);
    std::vector<Node*> nodes=getNodes();

    double neff=d->numIgnore()*(supersize-1.0);
    if(popscale==1.0) {
      neff += d->getDim();
    }else{
      for(unsigned int c1=0;c1<popnodes.size();c1++) {
	neff += nodes[getPopNode(c1)]->getChildrenBelow();
      }
    }
//    cout<<"Applytree with ps="<<popscale<<endl;
    tree->getRoot()->calcToTheLeft(d->numIgnore()*supersize,popscale);
    tree->getRoot()->calcLefting  (neff, rescaletree);

    order=(tree->getRoot()->tipsUnder());
    int numignored=0;
    if((int)poporder.size()<beststate->getP()) poporder=vector<int>(beststate->getP(),-1);
    for(int c1=0;c1<d->getDim();c1++){
      if(d->getIgnore(c1)) {
	order.insert(order.begin()+numignored,c1);
	numignored++;
      }
    }
    int numtotheleft=0;
    for(int c1=0;c1<d->getDim();c1++){
      if(nodes[c1]->getFather()==NULL) {
	//nodes[c1]->calcToTheLeft(numtotheleft*supersize + supersize/2.0);
	nodes[c1]->calcToTheLeft(numtotheleft*supersize+(max(1.0,supersize)-1.0)/2.0);
	nodes[c1]->calcLefting(neff, rescaletree);
	poporder[numtotheleft]=beststate->getPop(c1);
	DEBUGPRINT("Adding node ["<<c1<<"]="<<nodes[c1]->newick(d)<<" at lefting "<<nodes[c1]->getLefting());
	numtotheleft++;
      }
    }
    for(int c1=0;c1<d->getDim();c1++){
      int tpop=beststate->getPop(c1);
      bool found=false;
      for(int c2=0;c2<numtotheleft;c2++) if(tpop==poporder[c2]){found=true;break;}
      if(!found){
	DEBUGPRINT("Ind "<<c1<<" "<<nodes[c1]->newick(d)<<" pop "<<tpop<<" order "<<numtotheleft);
	poporder[numtotheleft]=tpop;
	numtotheleft++;
      }
    }
    for(unsigned int c1=0;c1<poporder.size();c1++){
      if(poporder[c1]<0) {
	cout<<"WARING: Didn't find population for "<<c1<<" ("<<endl;//popnames[c1]<<")"<<endl;
	vector<int> tpop=getIndInPopIndexes(c1);
	for(unsigned int c2=0;c2<tpop.size();c2++) cout<<tpop[c2]<<":"<<flush;
	for(unsigned int c2=0;c2<tpop.size();c2++) cout<<getName(tpop[c1])<<","<<flush;
	cout<<endl;
      }
    }
//    poporder[c1]=tree->whichPopNode(c1);

}

void InputData::setPopOrderFromTree(){
  if(tree==NULL) return;
  std::vector<Node*> nodes=getNodes();
  treepoporder=vector<int>(poporder.size(),-1);
  vector<double> treeleftings(poporder.size(),-1);
  for(unsigned c1=0;c1<treeleftings.size();c1++){
//    cout<<"SPOFT "<<c1<<" GPO="<<getPopOrder(c1)<<" NID="<<nodes[popnodes[getPopOrder(c1)]]->getId()<<" lefting="<<nodes[popnodes[getPopOrder(c1)]]->getLefting()<<endl;
    treeleftings[c1]= nodes[popnodes[getPopOrder(c1)]]->getLefting();
  }
  double prevmin=-1;
  for(unsigned c1=0;c1<treepoporder.size();c1++){
    for(unsigned c2=0;c2<treeleftings.size();c2++){
      if(treepoporder[c1]<0){
	if(treeleftings[c2]>prevmin) {
	  treepoporder[c1]=c2;
	}
      }else if(treeleftings[treepoporder[c1]]>treeleftings[c2] && treeleftings[c2]>prevmin) {
	treepoporder[c1]=c2;
      }
    }
    prevmin=treeleftings[treepoporder[c1]];
  }
  for(unsigned c1=0;c1<treepoporder.size();c1++){
    if(treepoporder[c1]<0) {
      cerr<<"Error in tree poporders. Index "<<c1<<" has value "<<treepoporder[c1]<<endl;
      cerr<<" Leftings are: "<<flush;
      for(unsigned c2=0;c2<treeleftings.size();c2++) cerr<<treeleftings[c2]<<",";
      cerr<<endl;
      throw(string("InputData::setPopOrderFromTree error with tree poporders."));
    }
  }
}

vector<double> InputData::getPopSizes(double popscale){
    vector<double> ret(treepoporder.size(),0);
    for(unsigned int c1=0;c1<ret.size();c1++){
      if(popscale==1.0) ret[c1]=getIndInPopIndexes(treepoporder[c1],true).size();
      else ret[c1]=pow(getIndInPopIndexes(treepoporder[c1],true).size(),popscale);
    }
    return(ret);
}
