
#include "multiplot.h"
#include "finegui.xpm"
#include <wx/stdpaths.h>

PlotSpace::PlotSpace(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size , long style , const wxString& name)
  : wxPanel(parent,id,pos,size,style,name)
{
  data=vector<double>();
  data2=vector<double>();
    borderx=0.1;
    bordery=0.1;
    labx=0.1;
    laby=0.1;
  Connect(wxEVT_PAINT, wxPaintEventHandler(PlotSpace::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(PlotSpace::OnSize));
  Connect(wxEVT_ERASE_BACKGROUND, wxEraseEventHandler(PlotSpace::OnErase));

}


void PlotSpace::OnSize(wxSizeEvent& event)
{
  Refresh();
}

void PlotSpace::OnPaint(wxPaintEvent& event)
{
  wxBufferedPaintDC  dc(this);
  show(dc);
}

int PlotSpace::getformatscale(double difference)
{
  int formatscale=-1;
  int diff=0;
  if(difference==0) return(0);
  while(diff==0 && formatscale<8){
    formatscale++;
    diff=(int)floor(difference*pow(formatscale,10.0));

  }
  return(formatscale+2);
}

void PlotSpace::show(wxDC&  dc){
  dc.SetPen(wxPen(wxColour(255, 255,255)));
  dc.SetBrush(wxBrush(wxColour(255, 255,255)));
  dc.DrawRectangle(0,0, GetSize().x,GetSize().y);

  double xorigin=GetSize().x * borderx;
  double xgap=(GetSize().x - GetSize().x * borderx*2.0)/(double)data.size();
  double yorigin=GetSize().y * bordery;
  double yrange=(GetSize().y - GetSize().y * bordery*2.0);

  double smin=DBL_MAX;
  double smax=DBL_MIN;
  for(unsigned int c1=0;c1<data.size();c1++){
      if(data[c1]<smin) smin=data[c1];
      if(data[c1]>smax) smax=data[c1];
  }
  for(unsigned int c1=0;c1<data2.size();c1++){
      if(data2[c1]<smin) smin=data2[c1];
      if(data2[c1]>smax) smax=data2[c1];
  }
  if(smax/smin<1.01){ smin = smin*0.99; smax=smax*1.01;}
  if(data.size()==0) return;
    dc.SetPen(wxPen(wxColour(0, 0,0)));
    dc.SetBrush(wxBrush(wxColour(0,0,0)));
  dc.DrawLine(xorigin,GetSize().y - yorigin,xorigin+xgap*data.size(),GetSize().y-yorigin);
  dc.DrawLine(xorigin,GetSize().y - yorigin,xorigin,GetSize().y-yorigin-yrange);

  wxFont font(10, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);

  dc.SetFont(font);

  dc.SetTextForeground(wxColour(0,0,0));
  int swidth, sheight;
  wxString text = wxString::Format(wxT("%i"), 0);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,xorigin-swidth/2.0,GetSize().y - yorigin+sheight);

  text = wxString::Format(wxT("%i"), (int)data.size());
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,xorigin+xgap*data.size()-swidth/2.0,GetSize().y - yorigin+sheight);

  int formatscale=getformatscale(smax-smin);//pow(1.0/(smax-smin),1/10);
/*cout<<"formatscale="<<formatscale<<endl;

cout<<"formatscale (100)="<<getformatscale(100)<<endl;
cout<<"formatscale (1)="<<getformatscale(1)<<endl;
cout<<"formatscale (0.01)="<<getformatscale(0.01)<<endl;
cout<<"formatscale (0.0001)="<<getformatscale(0.0001)<<endl;*/

wxString format=wxT("%0.");
  format<<formatscale;
  format<<wxT("f");
  text = wxString::Format(format, smin);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,xorigin- swidth,GetSize().y - yorigin-sheight/2.0);

  text = wxString::Format(format, smax);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,xorigin- swidth,GetSize().y - yorigin-yrange-sheight/2.0);

    dc.SetPen(wxPen(wxColour(255, 0,0)));
    dc.SetBrush(wxBrush(wxColour(255,0,0)));
  for(unsigned int c1=0;c1<data.size()-1;c1++){
    wxCoord x1 = wxCoord(xorigin + c1*xgap);
    wxCoord y1 = wxCoord(GetSize().y - (yorigin + yrange*(data[c1]-smin)/(smax-smin)));
    wxCoord x2 = wxCoord(xorigin + (c1+1)*xgap);
    wxCoord y2 = wxCoord(GetSize().y - (yorigin + yrange*(data[c1+1]-smin)/(smax-smin)));
    dc.DrawLine(x1,y1,x2,y2);
  }
    dc.SetPen(wxPen(wxColour(0,255,0)));
    dc.SetBrush(wxBrush(wxColour(0,255,0)));
    if(data2.size()>0){
  for(unsigned int c1=0;c1<data2.size()-1;c1++){
    wxCoord x1 = wxCoord(xorigin + c1*xgap);
    wxCoord y1 = wxCoord(GetSize().y - (yorigin + yrange*(data2[c1]-smin)/(smax-smin)));
    wxCoord x2 = wxCoord(xorigin + (c1+1)*xgap);
    wxCoord y2 = wxCoord(GetSize().y - (yorigin + yrange*(data2[c1+1]-smin)/(smax-smin)));
    dc.DrawLine(x1,y1,x2,y2);
  }
    }
}



void PlotSpace::exportToFile(const wxString& filename)
{
  wxInitAllImageHandlers();

  wxMemoryDC  memory;
  wxString filetype=filename.AfterLast(wxChar('.'));
  cout<<filename.mb_str()<<":"<<filetype.mb_str()<<endl;
  //  wxSize csize =GetVirtualSize();

  wxBitmap bitmap = wxBitmap( GetSize().x,GetSize().y,-1);
  memory.SelectObject(bitmap);
  show(memory);
  //dc.Blit( GetPosition().x,GetPosition().y, GetSize().x,GetSize().y, &memory, 0,0);

  if(filetype.CmpNoCase(wxT("png"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_PNG );
  else if(filetype.CmpNoCase(wxT("bmp"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_BMP );
  else if(filetype.CmpNoCase(wxT("jpg"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_JPEG );
  else if(filetype.CmpNoCase(wxT("jpeg"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_JPEG );
  else bitmap.SaveFile(filename+wxT(".jpg"), wxBITMAP_TYPE_JPEG );


}


MultiPlot::MultiPlot(InputData *inputdata,InputData *inputdata2,const wxString& title)
       : wxFrame(NULL, wxID_ANY, title, wxDefaultPosition, wxSize(280, 180))
{
  this->inputdata=inputdata;
  this->inputdata2=inputdata2;
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
  SetMinSize(wxSize(720,540));

  scrollsize=50;
  panel = new wxPanel(this, -1);
  fgs = new wxFlexGridSizer(1,2,0,0);

  int sidescollsize=25;
  sidescroller= new  wxScrolledWindow(panel, -1, wxPoint(0,0), wxSize(180,-1), wxVSCROLL);
  sidescroller->SetMinSize(wxSize(180,-1));
  panelTop = new wxPanel(sidescroller,-1, wxPoint(0,0), wxSize(160,800));
  panelTop->SetMinSize( wxSize(160,800));
  sidescroller->SetScrollbars(sidescollsize, sidescollsize, sidescroller->GetSize().x/sidescollsize, sidescroller->GetSize().y/sidescollsize);
  sidescroller->Scroll(0,0);
  wxBoxSizer *tsideslider=new wxBoxSizer(wxHORIZONTAL);
  tsideslider->Add(panelTop);
    sidescroller->SetSizer(tsideslider);
  tsideslider->SetVirtualSizeHints(sidescroller);

  finescroller= new  wxScrolledWindow(panel, -1, wxDefaultPosition, wxDefaultSize, wxHSCROLL | wxVSCROLL);
  finescroller->SetScrollbars(scrollsize, scrollsize, finescroller->GetMinSize().x/scrollsize, finescroller->GetMinSize().y/scrollsize);
  finescroller->Scroll(0,0);

  wxBoxSizer *tslider=new wxBoxSizer(wxHORIZONTAL);
  drawdisplay = new PlotSpace((wxPanel *)finescroller, -1, wxDefaultPosition, wxSize(1000,1000), wxSUNKEN_BORDER);

  fgsTop = new wxFlexGridSizer(11, 1, 9, 10);

  closeButton=new wxButton(panelTop, MULTIPLOT_ID_CLOSE, wxT("Close"));
  HelpButton=new wxButton(panelTop, MULTIPLOT_ID_HELP, wxT("Help"));
  ExportButton=new wxButton(panelTop, MULTIPLOT_ID_EXPORT, wxT("Export Image"));
  CsvButton=new wxButton(panelTop, MULTIPLOT_ID_EXPORTCSV, wxT("Export CSV Data"));


  plotData=new wxComboBox((wxWindow*)panelTop, MULTIPLOT_ID_CHOICE, plotchoices[0],wxDefaultPosition,wxSize(130,20),NUMCHOICES,
			    plotchoices,wxCB_READONLY);

  fgsTop->Add(closeButton);
  fgsTop->Add(HelpButton);
  fgsTop->Add(ExportButton);
  fgsTop->Add(CsvButton);
  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Plot Type")));
  fgsTop->Add(plotData);

  tslider->Add(drawdisplay);
  finescroller->SetSizer(tslider);

  fgs->Add(sidescroller, 1, wxALL | wxEXPAND, 5);
  fgs->Add(finescroller, 1, wxALL | wxEXPAND, 5);

  fgsTop->AddGrowableCol(0,1);

// add sizers to everything
  fgs->AddGrowableRow(0, 1);
  fgs->AddGrowableCol(1, 1);
  panelTop->SetSizerAndFit(fgsTop);
//  panelTop->SetSizer(fgsTop);
  panel->SetSizer(fgs);

  Connect(MULTIPLOT_ID_CLOSE, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MultiPlot::OnQuit));
  Connect(MULTIPLOT_ID_HELP, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MultiPlot::OnHelp));
  Connect(MULTIPLOT_ID_EXPORT, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MultiPlot::OnExport));
  Connect(MULTIPLOT_ID_EXPORTCSV, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(MultiPlot::OnExportCsv));
  Connect(MULTIPLOT_ID_CHOICE,wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(MultiPlot::OnChoice));
  Centre();
  Refresh();
  setPlot();
}

void MultiPlot::OnExport(wxCommandEvent& WXUNUSED(event))
{
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select file for image export (supported formats: .png, .bmp, .jpg)"),
						   inputdata->getCopyDir(),wxT("output.png"),
						   wxT("PNG files (*.png)|*.png|BMP files (*.bmp)|*.bmp|JPG files (*.jpeg;*.jpeg)|*.jpg;*.jpeg|All Files|*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    wxFileName tfile(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
    drawdisplay->exportToFile(tfile.GetFullPath());
  }
}

void MultiPlot::OnExportCsv(wxCommandEvent& WXUNUSED(event))
{
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select file for CSV export (supported formats: .csv)"),inputdata->getCopyDir(),wxT("output.csv"),
						   wxT("CSV files (*.csv)"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    wxFileName tfile(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
    string tfilename=std::string(tfile.GetFullPath().mb_str());
    filebuf *fb=new(filebuf);
    fb->open (tfilename.c_str(),ios::out);
    ostream os(fb);
    os<<"Iteration";
    os<<",K,alpha,beta,delta,F";
    if(inputdata2->haveMCMCtraces()) os<<",K2,alpha2,beta2,delta2,F2";
    os<<endl;
    for(unsigned int c1=0;c1<inputdata->getPopHistory()->size();c1++){
      os<<c1<<","<<inputdata->getPopHistoryD(c1)<<","<<inputdata->getAlphaHistoryD(c1)<<","<<inputdata->getBetaHistoryD(c1)<<","<<inputdata->getDeltaHistoryD(c1)<<","<<inputdata->getFHistoryD(c1);
      if(inputdata2->haveMCMCtraces()) os<<c1<<","<<inputdata2->getPopHistoryD(c1)<<","<<inputdata2->getAlphaHistoryD(c1)<<","<<inputdata2->getBetaHistoryD(c1)<<","<<inputdata2->getDeltaHistoryD(c1)<<","<<inputdata2->getFHistoryD(c1);
      os<<endl;
    }
    delete(fb);
  }
}


void MultiPlot::OnQuit(wxCommandEvent & event)
{
  Close(true);
}

void MultiPlot::OnHelp(wxCommandEvent & event)
{
  wxMessageBox(wxT("Traceplot functionality is currently very limited.\n\n\
  1) Choose a \'Plot Type\', i.e. which MCMC variable you want to plot.\n\n\
  2) You can export an image (i.e. the plot you are looking at) to a PNG/BMP/JPG file with 'Export Image'.\n\n\
  3) You can export the MCMC traces to a comma separated file with 'Export CSV data'.  This exports all quantities that can be plotted, and is how you should produce publication quality plots.\n\n\
  Note that there is a \'feature\' that when you generate non-standard fineSTRUCTURE samples using the command line, e.g. if you are using a non-standard prior model, it will not be displayed correctly here.  It is instead interpreted as a standard prior.  If you do this, you will need to extract the trace data directly from the MCMC xml file."),wxT("Traceplot help"));
}

void MultiPlot::OnChoice(wxCommandEvent & event)
{
  setPlot();
  //wxMessageBox(wxT("Good choice."),wxT("Traceplot help"));
}

void MultiPlot::setPlot()
{
  if(!inputdata->haveMCMCtraces()) inputdata->readMCMCtraces();
  if(inputdata2->hasPCM()) if(!inputdata2->haveMCMCtraces()) inputdata2->readMCMCtraces();
  int choice=getChoice();
  switch(choice){
    case 0: drawdisplay->setData(inputdata->getPopHistory());
    if(inputdata2->haveMCMCtraces()) drawdisplay->setData2(inputdata2->getPopHistory());
    break;
    case 1: drawdisplay->setData(inputdata->getFHistory());
    if(inputdata2->haveMCMCtraces())drawdisplay->setData2(inputdata2->getFHistory());
    break;
    case 2: drawdisplay->setData(inputdata->getDeltaHistory());
    if(inputdata2->haveMCMCtraces())drawdisplay->setData2(inputdata2->getDeltaHistory());
    break;
    case 3: drawdisplay->setData(inputdata->getBetaHistory());
    if(inputdata2->haveMCMCtraces())drawdisplay->setData2(inputdata2->getBetaHistory());
    break;
    case 4: drawdisplay->setData(inputdata->getAlphaHistory());
    if(inputdata2->haveMCMCtraces())drawdisplay->setData2(inputdata2->getAlphaHistory());
    break;
    default: break;
  }
  drawdisplay->setDataName(plotchoices[choice]);
  drawdisplay->Refresh();
}
