
#ifndef MULTIPLOT_H
#define MULTIPLOT_H

#include <wx/wx.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/dcbuffer.h>

#include <vector>
#include <float.h>
#include <sstream>
#include <fstream>

#include "inputdata.h"

using namespace std;

#define MULTIPLOT_ID_HELP 1001
#define MULTIPLOT_ID_CLOSE 1002
#define MULTIPLOT_ID_EXPORT 1003
#define MULTIPLOT_ID_CHOICE 1004
#define MULTIPLOT_ID_EXPORTCSV 1005 

#define NUMCHOICES 4
//const wxString plotchoices [NUMCHOICES]= {wxT("populations"),wxT("f"),wxT("delta"),wxT("beta"),wxT("alpha") };
const wxString plotchoices [NUMCHOICES]= {wxT("populations"),wxT("f"),wxT("delta"),wxT("beta")};


class PlotSpace: public wxPanel
{
  public:
    
    PlotSpace(wxWindow* parent, wxWindowID id = wxID_ANY, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL, const wxString& name = wxT("panel"));
    int getformatscale(double difference);    
    inline void setData(vector<double> *d){
      data.clear();
      for(unsigned int c1=0;c1<d->size();c1++) data.push_back(d->at(c1));
    }
    inline void setData(vector<int> *d){
      data.clear();
      for(unsigned int c1=0;c1<d->size();c1++) data.push_back((double)d->at(c1));
    }
    inline void setData2(vector<double> *d){
      data2.clear();
      for(unsigned int c1=0;c1<d->size();c1++) data2.push_back(d->at(c1));
    }    
    inline void setDataName(wxString name){
      dataname=name;
    }
    void OnSize(wxSizeEvent& event);
    void OnPaint(wxPaintEvent& event);
    inline void OnErase(wxEraseEvent& event){};
    void show(wxDC&  dc);
    void exportToFile(const wxString& filename) ;
    
  protected:
    vector<double> data;
    vector<double> data2;
    wxString dataname;
    double borderx,bordery;
    double labx,laby;
};

class MultiPlot : public wxFrame
{
  friend class SettingsIO;
public:
  MultiPlot(InputData *inputdata,InputData *inputdata2,const wxString& title);
  void OnQuit(wxCommandEvent & event);
  void OnExport(wxCommandEvent & event);
  void OnExportCsv(wxCommandEvent & event);
  void OnHelp(wxCommandEvent & event);
  void OnChoice(wxCommandEvent & event);
  void setPlot();
  inline int getChoice(){
    for(unsigned int c1=0;c1<NUMCHOICES;c1++){
      if(plotData->GetValue()==plotchoices[c1]) return(c1);
    }
    return(-1);
  }
  protected:
// LAYOUT
  int scrollsize;
  wxPanel *panel;
  wxPanel *panelTop;
  PlotSpace *drawdisplay;
  
  wxFlexGridSizer *fgs;
  wxFlexGridSizer *fgsTop;
  wxScrolledWindow *finescroller;
  wxScrolledWindow *sidescroller;

//
  wxButton *closeButton;
  wxButton *HelpButton;
  wxButton *ExportButton;
  wxButton *CsvButton;
  wxComboBox *plotData; 
  
  // CONTENT
  InputData *inputdata;
  InputData *inputdata2;

};

#endif
