
#include <wx/stdpaths.h>
#include "finegui.xpm"

#include "nameswindow.h"


NamesWindow::NamesWindow(InputData *inputdata,wxPanel *parent, int id,const wxString& title):
      wxFrame(parent, id, title, wxDefaultPosition, wxDefaultSize)
{
  SetSize(wxSize(420,600));
  this->inputdata=inputdata;
  this->parent=parent;

    #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);

//  namegrid = new wxGrid(this,-1, wxPoint(0,40), GetSize(), wxWANTS_CHARS, wxPanelNameStr);
  namegrid = new wxGrid(this,-1, wxPoint(0,30), wxSize(420,600), wxWANTS_CHARS, wxPanelNameStr);
  vsizer=new wxFlexGridSizer(2,1,0,0);
  hsizer=new wxFlexGridSizer(1,2,0,0);
  vsizer->AddGrowableRow(1);
  vsizer->AddGrowableCol(0);
  hsizer->AddGrowableCol(0);
  hsizer->AddGrowableCol(1);
  toppanel = new wxPanel(this, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_NONE);
  toppanel->SetMinSize(wxSize(200,30));
  toppanel->SetSize(wxSize(200,30));
  okButton=new wxButton(toppanel, NAMESWINDOW_ID_OKBUTTON, wxT("Accept"));
  cancelButton=new wxButton(toppanel, NAMESWINDOW_ID_CANCELBUTTON, wxT("Cancel"));
  hsizer->Add(okButton,1,wxEXPAND);
  hsizer->Add(cancelButton,1,wxEXPAND);
  hsizer->SetSizeHints( toppanel );
  toppanel->SetSizerAndFit(hsizer);
  namegrid->CreateGrid( inputdata->getN(), 2 );

    // And set grid cell contents as strings
  for(int c1=0;c1<inputdata->getN();c1++){
    namegrid->SetCellValue( c1, 0, inputdata->getName(c1));
    namegrid->SetCellValue( c1, 1, inputdata->getName(c1));
    namegrid->SetReadOnly( c1, 0 );
    namegrid->SetCellBackgroundColour( c1, 0, wxColour(230,230,230));
  }
  if(inputdata->getN()>0){
  namegrid->SetColLabelValue(0,wxT("     Initial Value     "));
  namegrid->SetColLabelValue(1,wxT("       New Value       "));
  }
  vsizer->Add(toppanel,1,wxEXPAND);
  vsizer->Add(namegrid,1,wxEXPAND);
  SetSizerAndFit(vsizer);
    Fit();
//  vsizer->SetSizeHints( this);
//
  namegrid->SetColMinimalWidth( 0, 280 );
  namegrid->SetColMinimalWidth( 1, 280 );
  namegrid->Fit();
  namegrid->ForceRefresh();
  Connect(NAMESWINDOW_ID_OKBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(NamesWindow::OnOkButton));
  Connect(NAMESWINDOW_ID_CANCELBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(NamesWindow::OnCancelButton));
  Connect( wxEVT_SIZE, wxSizeEventHandler( NamesWindow::OnSize ));
;
}

void NamesWindow::OnOkButton(wxCommandEvent & event)
{
  for(int c1=0;c1<inputdata->getN();c1++){
    inputdata->setName(c1,namegrid->GetCellValue( c1, 1));
  }
  parent->Refresh();
  Close(true);
}

void NamesWindow::OnSize(wxSizeEvent & event)
{
  // vsizer->Fit(this);
  wxSize newnamesize=GetSize();
  newnamesize.y-=50;
  newnamesize.x-=10;
  namegrid->SetSize(newnamesize);
}
