
#include "pca.h"
#include "finegui.xpm"
#include <wx/stdpaths.h>

#define NUMLEGCHOICES 4
const wxString leglocchoices [NUMLEGCHOICES]= {wxT("BottomRight"),wxT("BottomLeft"),wxT("TopRight"),wxT("TopLeft") };
#define NUMALTCHOICES 2
const wxString altptchoices [NUMALTCHOICES]= {wxT("None"),wxT("Cross") };

PlotSpacePCA::PlotSpacePCA(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size , long style , const wxString& name)
  : wxPanel(parent,id,pos,size,style,name)
{
  dataX=vector<double>();
  dataY=vector<double>();
    borderx=0.1;
    bordery=0.1;
    labx=0.1;
    laby=0.1;
    numpops=0;
    ptsize=3;
    legloc=0;
    legfontsize=10;
    secondsymbol=0;
  Connect(wxEVT_PAINT, wxPaintEventHandler(PlotSpacePCA::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(PlotSpacePCA::OnSize));
  Connect(wxEVT_ERASE_BACKGROUND, wxEraseEventHandler(PlotSpacePCA::OnErase));

}


void PlotSpacePCA::OnSize(wxSizeEvent& event)
{
  Refresh();
}

void PlotSpacePCA::OnPaint(wxPaintEvent& event)
{
  wxBufferedPaintDC  dc(this);
  show(dc);
}

void PlotSpacePCA::show(wxDC&  dc){
  dc.SetPen(wxPen(wxColour(255, 255,255)));
  dc.SetBrush(wxBrush(wxColour(255, 255,255)));
  dc.DrawRectangle(0,0, GetSize().x,GetSize().y);
  if(dataX.size()==0) return;
  if(dataY.size()!=dataX.size()) return;
  double xorigin=GetSize().x * borderx;
  double xrange=(GetSize().x - GetSize().x * borderx*2.0);
  double yorigin=GetSize().y * bordery;
  double yrange=(GetSize().y - GetSize().y * bordery*2.0);
  double x0=xorigin + xrange/2.0;
  double y0=yorigin + yrange/2.0;

  double smaxX=0;
  double smaxY=0;
  for(unsigned int c1=0;c1<dataX.size();c1++){
      if(fabs(dataX[c1])>smaxX) smaxX=fabs(dataX[c1]);
  }
  for(unsigned int c1=0;c1<dataY.size();c1++){
      if(fabs(dataY[c1])>smaxY) smaxY=fabs(dataY[c1]);
  }

    dc.SetPen(wxPen(wxColour(0, 0,0)));
    dc.SetBrush(wxBrush(wxColour(0,0,0)));
  dc.DrawLine(x0,GetSize().y - y0,x0+xrange/2.0,GetSize().y-y0);
  dc.DrawLine(x0,GetSize().y - y0,x0-xrange/2.0,GetSize().y-y0);
  dc.DrawLine(x0,GetSize().y - y0,x0,GetSize().y-y0-yrange/2.0);
  dc.DrawLine(x0,GetSize().y - y0,x0,GetSize().y-y0+yrange/2.0);

  dc.DrawLine(x0+xrange/2.0,GetSize().y-y0,x0+xrange/2.0,GetSize().y-y0+5);
  dc.DrawLine(x0-xrange/2.0,GetSize().y-y0,x0-xrange/2.0,GetSize().y-y0+5);
  dc.DrawLine(x0,GetSize().y-y0-yrange/2.0,x0-5,GetSize().y-y0-yrange/2.0);
  dc.DrawLine(x0,GetSize().y-y0+yrange/2.0,x0-5,GetSize().y-y0+yrange/2.0);

  wxFont font(10, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);

  dc.SetFont(font);

  dc.SetTextForeground(wxColour(0,0,0));
  int swidth, sheight;
  wxString text = wxString::Format(wxT("%i"), 0);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,x0-swidth-10,GetSize().y - y0+sheight/2.0);

  text = wxString::Format(wxT("%0.2f"), smaxX);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,x0-swidth/2.0+xrange/2.0,GetSize().y - y0+sheight/2.0);

  text = wxString::Format(wxT("-%0.2f"), smaxX);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,x0-swidth/2.0-xrange/2.0,GetSize().y - y0+sheight/2.0);

  text = wxString::Format(wxT("%0.2f"), smaxY);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,x0-swidth-10,GetSize().y - y0-sheight/2.0-yrange/2.0);

  text = wxString::Format(wxT("-%0.2f"), smaxY);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,x0-swidth-10,GetSize().y - y0-sheight/2.0+yrange/2.0);

  text = nameX;
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,GetSize().x-swidth-10,GetSize().y - y0-5.0*sheight/2.0);

  text = wxString::Format(wxT("(%0.2e)"), eval[0]);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,GetSize().x-swidth-10,GetSize().y - y0-3.0*sheight/2.0);

  text =nameY + wxString::Format(wxT(" (%0.2e)"), eval[1]);
  GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);
  dc.DrawText(text,x0-swidth/2.0,GetSize().y - y0 - yrange/2 - sheight-10);
// plot the data
  for(unsigned int c1=0;c1<dataX.size();c1++){
    wxColour col=getCol(pops[c1]);
    dc.SetPen(wxPen(col));
    dc.SetBrush(wxBrush(col));
    wxCoord x = wxCoord(x0 + (xrange/2.0)*dataX[c1]/(smaxX));
    wxCoord y = wxCoord(y0 + (yrange/2.0)*dataY[c1]/(smaxY));
    dc.DrawCircle(x, y, ptsize);
  }
  dc.SetPen(wxPen(wxColour(0,255,0)));
  dc.SetBrush(wxBrush(wxColour(0,255,0)));
// plot the second data if required
  if(secondsymbol>=0){
    for(unsigned int c1=0;c1<dataX.size();c1++){
      wxColour col=getCol(pops[c1]);
      dc.SetPen(wxPen(col));
      dc.SetBrush(wxBrush(col));
      wxCoord x = wxCoord(x0 + (xrange/2.0)*dataX[c1]/(smaxX));
      wxCoord y = wxCoord(y0 + (yrange/2.0)*dataY[c1]/(smaxY));
      if(secondsymbol==0) {
	//dc.DrawCircle(x, y, );
	dc.DrawLine(x+ptsize/2.0,y+ptsize/2.0,x-ptsize/2.0,y-ptsize/2.0);
	dc.DrawLine(x-ptsize/2.0,y-ptsize/2.0,x+ptsize/2.0,y+ptsize/2.0);
      }
    }
    dc.SetPen(wxPen(wxColour(0,255,0)));
    dc.SetBrush(wxBrush(wxColour(0,255,0)));
  }
// legend
  wxFont legfont(legfontsize, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);

  dc.SetFont(legfont);

  dc.SetTextForeground(wxColour(0,0,0));
  vector<int> swidths(numpops,0);
  vector<int> sheights(numpops,0);
  for(int c1=0;c1<numpops;c1++) GetTextExtent(popnames[c1],&swidths[c1],&sheights[c1],NULL, NULL, &legfont);
  int legwidth = 0;
  int legheight = 0;
  for(int c1=0;c1<numpops;c1++) if(swidths[c1]>legwidth) legwidth=swidths[c1];
  for(int c1=0;c1<numpops;c1++) legheight+=sheights[c1];
  legwidth+=20;
  int legtopleftx=0;
  int legtoplefty=0;
  switch(legloc){
    case 0: legtopleftx=x0 + (xrange/2.0) - legwidth;
	    legtoplefty=y0 + (yrange/2.0) - legheight; break;
    case 1: legtopleftx=x0 - (xrange/2.0);
	    legtoplefty=y0 + (yrange/2.0) - legheight; break;
    case 2: legtopleftx=x0 + (xrange/2.0) - legwidth;
	    legtoplefty=y0 - (yrange/2.0); break;
    default: legtopleftx=x0 - (xrange/2.0);
	    legtoplefty=y0 - (yrange/2.0); break;
  }
  for(int c1=0;c1<numpops;c1++){
    dc.DrawText(popnames[c1],legtopleftx + 20,legtoplefty + c1 * sheights[0]-sheights[0]/2.0);
    wxColour col=getCol(c1);
    dc.SetPen(wxPen(col));
    dc.SetBrush(wxBrush(col));
    wxCoord x = wxCoord(legtopleftx + 10);
    wxCoord y = wxCoord(legtoplefty + c1 * sheights[0]);
    dc.DrawCircle(x, y, ptsize);
  }

}

wxColour PlotSpacePCA::getColNorm(double val){
  double nmax=5;
    if(val<= -0.000001) return(wxColour(255,255,255));
    if(val<= 0) return(wxColour(255,255,0));
  if(val<=1.0/nmax) return(wxColour(255,255 - val*nmax*255,0));
  val-=1.0/nmax;
  if(val<=1.0/nmax) return(wxColour(255,0,val*nmax*255));
  val-=1.0/nmax;
  if(val<=1.0/nmax) return(wxColour(255 - val*nmax*255,0,255));
  val-=1.0/nmax;
  if(val<=1.0/nmax) return(wxColour(0,val*nmax*255,255));
  val-=1.0/nmax;
  if(val<=1.0/nmax) return(wxColour(0,255,255 - val*nmax*255));
  val-=1.0/nmax;
  if(val<=0.000001)return(wxColour(0,0,255));
  return(wxColour(0,0,0));
}

wxColour PlotSpacePCA::getCol(int val){
  if(numpops==1) return(wxColour(0,255,0));
  return(getColNorm((double)val/numpops));
}



void PlotSpacePCA::exportToFile(const wxString& filename)
{
  wxInitAllImageHandlers();

  wxMemoryDC  memory;
  wxString filetype=filename.AfterLast(wxChar('.'));
  cout<<filename.mb_str()<<":"<<filetype.mb_str()<<endl;
//  wxSize csize =GetVirtualSize();

  wxBitmap bitmap = wxBitmap( GetSize().x,GetSize().y,-1);
  memory.SelectObject(bitmap);
  show(memory);
  //dc.Blit( GetPosition().x,GetPosition().y, GetSize().x,GetSize().y, &memory, 0,0);

  if(filetype.CmpNoCase(wxT("png"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_PNG );
  else if(filetype.CmpNoCase(wxT("bmp"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_BMP );
  else if(filetype.CmpNoCase(wxT("jpg"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_JPEG );
  else if(filetype.CmpNoCase(wxT("jpeg"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_JPEG );
  else bitmap.SaveFile(filename+wxT(".jpg"), wxBITMAP_TYPE_JPEG );


}

////////////////////////// *******************************************************
PcaPlot::PcaPlot(InputData *inputdata,InputData *inputdata2,const wxString& title)
       : wxFrame(NULL, wxID_ANY, title, wxDefaultPosition, wxSize(280, 180))
{
  this->inputdata=inputdata;
  this->inputdata2=inputdata2;
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
  SetMinSize(wxSize(720,540));

  scrollsize=50;
  panel = new wxPanel(this, -1);
  fgs = new wxFlexGridSizer(1,2,0,0);

  int sidescollsize=25;
  sidescroller= new  wxScrolledWindow(panel, -1, wxPoint(0,0), wxSize(180,-1), wxVSCROLL);
  sidescroller->SetMinSize(wxSize(180,-1));
  panelTop = new wxPanel(sidescroller,-1, wxPoint(0,0), wxSize(160,800));
  panelTop->SetMinSize( wxSize(160,800));
  sidescroller->SetScrollbars(sidescollsize, sidescollsize, sidescroller->GetSize().x/sidescollsize, sidescroller->GetSize().y/sidescollsize);
  sidescroller->Scroll(0,0);
  wxBoxSizer *tsideslider=new wxBoxSizer(wxHORIZONTAL);
  tsideslider->Add(panelTop);
    sidescroller->SetSizer(tsideslider);
  tsideslider->SetVirtualSizeHints(sidescroller);

  finescroller= new  wxScrolledWindow(panel, -1, wxDefaultPosition, wxDefaultSize, wxHSCROLL | wxVSCROLL);
  finescroller->SetScrollbars(scrollsize, scrollsize, finescroller->GetMinSize().x/scrollsize, finescroller->GetMinSize().y/scrollsize);
  finescroller->Scroll(0,0);

  wxBoxSizer *tslider=new wxBoxSizer(wxHORIZONTAL);
  drawdisplay = new PlotSpacePCA((wxPanel *)finescroller, -1, wxDefaultPosition, wxSize(1000,1000), wxSUNKEN_BORDER);

  fgsTop = new wxFlexGridSizer(11, 1, 9, 10);

  closeButton=new wxButton(panelTop, PCAPLOT_ID_CLOSE, wxT("Close"));
  HelpButton=new wxButton(panelTop, PCAPLOT_ID_HELP, wxT("Help"));
  ExportButton=new wxButton(panelTop, PCAPLOT_ID_EXPORT, wxT("Export Image"));
  CsvButton=new wxButton(panelTop, PCAPLOT_ID_EXPORTCSV, wxT("Export CSV Data"));

  int n=inputdata->getMsize(false,FSGUI_SHOW_COPYMATRIX);

  pcompnames.Clear();
  for(int c1=0;c1<n;c1++){
    wxString tmp;
    tmp<<wxT("Component ")<<c1+1;
    pcompnames.Add(tmp);
  }
  plotComp1=new wxComboBox((wxWindow*)panelTop, PCAPLOT_ID_CHOICE1, pcompnames[0],wxDefaultPosition,wxSize(130,20),
			    pcompnames,wxCB_READONLY);
  plotComp2=new wxComboBox((wxWindow*)panelTop, PCAPLOT_ID_CHOICE2, pcompnames[1],wxDefaultPosition,wxSize(130,20),
			    pcompnames,wxCB_READONLY);
  fgsTop->Add(closeButton);
  fgsTop->Add(HelpButton);
  fgsTop->Add(ExportButton);
  fgsTop->Add(CsvButton);
  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Select Axes")));
  fgsTop->Add(plotComp1);
  fgsTop->Add(plotComp2);
  tslider->Add(drawdisplay);

  wxGridSizer * ptsize_size=new wxGridSizer(2,2,0,0);
  ptsizectrl = new wxTextCtrl(panelTop, PCAPLOT_ID_PTSIZE, drawdisplay->getPtSize(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  ptsize_size->Add(new wxStaticText(panelTop, -1, wxT("Point Size:")));
  ptsize_size->Add(ptsizectrl);
  legsizectrl = new wxTextCtrl(panelTop, PCAPLOT_ID_LEGSIZE, drawdisplay->getLegSize(), wxDefaultPosition, wxSize(50,-1), wxTE_PROCESS_ENTER , wxDefaultValidator, wxTextCtrlNameStr);
  ptsize_size->Add(new wxStaticText(panelTop, -1, wxT("Legend Size:")));
  ptsize_size->Add(legsizectrl);
  fgsTop->Add(ptsize_size);

  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Legend Location:")));
  legloc=new wxComboBox((wxWindow*)panelTop, PCAPLOT_ID_LEGLOC, leglocchoices[0],wxDefaultPosition,wxSize(130,20),
			    NUMLEGCHOICES,leglocchoices,wxCB_READONLY);
  fgsTop->Add(legloc);

/*  fgsTop->Add(new wxStaticText(panelTop, -1, wxT("Second data Symbol:")));
  altptctrl=new wxComboBox((wxWindow*)panelTop, PCAPLOT_ID_ALTPT, altptchoices[drawdisplay->getSecSym()],wxDefaultPosition,wxSize(130,20),
			    NUMALTCHOICES,altptchoices,wxCB_READONLY);
  fgsTop->Add(altptctrl);*/

  finescroller->SetSizer(tslider);

  fgs->Add(sidescroller, 1, wxALL | wxEXPAND, 5);
  fgs->Add(finescroller, 1, wxALL | wxEXPAND, 5);

  fgsTop->AddGrowableCol(0,1);

// add sizers to everything
  fgs->AddGrowableRow(0, 1);
  fgs->AddGrowableCol(1, 1);
  panelTop->SetSizerAndFit(fgsTop);
//  panelTop->SetSizer(fgsTop);
  panel->SetSizer(fgs);
  Connect(PCAPLOT_ID_CLOSE, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PcaPlot::OnQuit));
  Connect(PCAPLOT_ID_HELP, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PcaPlot::OnHelp));
  Connect(PCAPLOT_ID_EXPORT, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PcaPlot::OnExport));
  Connect(PCAPLOT_ID_EXPORTCSV, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PcaPlot::OnExportCsv));
  Connect(PCAPLOT_ID_CHOICE1,wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(PcaPlot::OnChoice));
  Connect(PCAPLOT_ID_CHOICE2,wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(PcaPlot::OnChoice2));
  Connect(PCAPLOT_ID_PTSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(PcaPlot::OnPtSize));
  Connect(PCAPLOT_ID_LEGSIZE, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler(PcaPlot::OnLegSize));
  Connect(PCAPLOT_ID_LEGLOC,wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(PcaPlot::OnLegLoc));
  Connect(PCAPLOT_ID_ALTPT,wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(PcaPlot::OnAltPt));
  Centre();
  Refresh();
  if(!inputdata->hasData()){
     wxMessageBox(wxT("Load some data first, in the \"File/Manage Files\" menu."),wxT("PCA needs data"));
     Close();
  }
  svdOfData(1);
  setPlot();

  
  ExportButton->SetToolTip(wxT("Export the currently visible figure to an image file."));
  CsvButton->SetToolTip(wxT("Export the entire PCA eigenvalues and eigenvectors to a CSV file for professional plotting."));
  plotComp1->SetToolTip(wxT("Choose the Eigevector to display on the horizontal axis (may respond to mouse wheel scrolling)."));    
  plotComp2->SetToolTip(wxT("Choose the Eigevector to display on the vertical axis (may respond to mouse wheel scrolling)."));
  ptsizectrl->SetToolTip(wxT("Size of the points, in pixels"));      
  legsizectrl->SetToolTip(wxT("Size of the legend text, in pixels"));    
  legloc->SetToolTip(wxT("Move the legend to the most convenient place"));    
}

void PcaPlot::OnExport(wxCommandEvent& WXUNUSED(event))
{
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select file for image export (supported formats: .png, .bmp, .jpg)"),
						   inputdata->getCopyDir(),wxT("output.png"),
						   wxT("PNG files (*.png)|*.png|BMP files (*.bmp)|*.bmp|JPG files (*.jpeg;*.jpeg)|*.jpg;*.jpeg|All Files|*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    wxFileName tfile(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
    drawdisplay->exportToFile(tfile.GetFullPath());
  }
}

void PcaPlot::OnExportCsv(wxCommandEvent& WXUNUSED(event))
{
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select file for CSV export (supported formats: .csv)"),inputdata->getCopyDir(),wxT("output.csv"),
						   wxT("CSV files (*.csv)"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
    wxFileName tfile(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
    string tfilename=std::string(tfile.GetFullPath().mb_str());
    filebuf *fb=new(filebuf);
    fb->open (tfilename.c_str(),ios::out);
    ostream os(fb);
    os<<"Label,";
    for(unsigned int c1=0;c1+1<svdM.size();c1++){
      os<<std::string(pcompnames[c1].mb_str())<<",";
    }
    if(svdM.size()>0) os<<std::string(pcompnames[svdM.size()-1].mb_str());
    os<<endl<<"Eigenvalue,";
    for(unsigned int c1=0;c1+1<svdM.size();c1++) os<<eval[c1]<<",";
    os<<eval[svdM.size()-1]<<endl;

    for(unsigned int c1=0;c1<svdM.size();c1++){
      //os<<std::string(inputdata->getName(inputdata->getorder(c1)).mb_str())<<",";
      os<<std::string(inputdata->getName(c1).mb_str())<<",";
      for(unsigned int c2=0;c2+1<svdM.size();c2++) os<<svdM[c2][c1]<<",";
      if(svdM.size()>0) os<<svdM[svdM.size()-1][c1];
      os<<endl;
    }
    delete(fb);
  }
}


void PcaPlot::OnQuit(wxCommandEvent & event)
{
  Close(true);
}

void PcaPlot::OnHelp(wxCommandEvent & event)
{
  wxMessageBox(wxT("The PCA plot facility is not complete and is inflexible.  It is best for exploritory analysis.  The PCA is performed as described in Lawson Et Al 2011 (PLoS Genetics).\n\n\
  1) Choose the pairs of components to plot under \'Select Axes\'.\n\n\
  2) You can export the current image (displayed on screen) via \'Export Image\'.\n\n\
  3) You can export the whole matrix of eigenvalues and vectors via \'Export CSV Data\'. This produces a CSV file where the first column is the individual name and the rest are components.  The first row is the eigenvalue, and the rest are the eigenvector components.  Therefore you can plot columns of this data (excluding the first row) to obtain the picture presented.\n\n\
  4) Individuals are coloured according to the population assignment.  Population labels are shown.\n\
  \t4a) By default therefore, you will see clusters of colour according to how fineSTRUCTURE has assigned individuals.\n\n\
  \t4b) You can instead plot labelled populations by writing a custom tree file where individuals are clustered according to their label.  The easiest way to do this is to take a MCMC iteration from your current data and create a MCMC file containing just a single iteration, for which you modify the <Pop> tag.  Then you generate a tree based on this file, using the observed populations."),wxT("PCA plot help"));
}

void PcaPlot::OnChoice(wxCommandEvent & event)
{
  setPlot();
}

void PcaPlot::OnLegLoc(wxCommandEvent & event)
{
  for(int c1=0;c1<NUMLEGCHOICES;c1++) if(legloc->GetValue()==leglocchoices[c1]) drawdisplay->setLegLoc(c1);
  drawdisplay->Refresh();
}

void PcaPlot::OnAltPt(wxCommandEvent & event)
{
  for(int c1=0;c1<NUMALTCHOICES;c1++) if(altptctrl->GetValue()==altptchoices[c1]) drawdisplay->setSecSym(c1);
  drawdisplay->Refresh();
}

void PcaPlot::setPlot()
{
  if(!inputdata->hasData()) return;
  int choice1=getChoice(1);
  int choice2=getChoice(2);
  drawdisplay->setXData(&svdM[choice1]);
  drawdisplay->setYData(&svdM[choice2]);
  drawdisplay->setPopNames(popnames);
  vector<double> t;
  t.push_back(eval[choice1]);
  t.push_back(eval[choice2]);
  drawdisplay->setEvals(t);
  drawdisplay->setXName(plotComp1->GetValue());
  drawdisplay->setYName(plotComp2->GetValue());
  drawdisplay->setPops(&pops);
  drawdisplay->setNumPops(numpops);
  drawdisplay->Refresh();
}

void PcaPlot::svdOfData(int matnum)
{
  int n=inputdata->getMsize(false,FSGUI_SHOW_COPYMATRIX);

  vector<vector<double> > *tdata;
  if(matnum!=2) tdata=inputdata->getdMatrix();
  else tdata=inputdata2->getdMatrix();
  PcaData tpca(tdata);
//  tpca.svdOfData();
  svdM=tpca.getMraw();
  eval=tpca.getEraw();
  pops=vector<int>(n,0);
  numpops=inputdata->getNumPops();

  if(inputdata->hasTree()){
    popnames.Clear();
    for(int c1=0;c1<inputdata->getNumPops();c1++){
      vector<int> indsinpop=inputdata->getIndInPopIndexes(c1,true);
      for(unsigned int c2=0;c2<indsinpop.size();c2++) pops[indsinpop[c2]]=c1;
      popnames.Add(inputdata->getPopName(c1,true));
    }
/*    for(unsigned int c1=0;c1<pops.size();c1++)  {
      pops[c1]=inputdata->getPop(inputdata->getorder(c1),true);
      if(pops[c1]>=numpops) numpops=pops[c1]+1;
    }
    for(int c1=0;c1<inputdata->getNumPops();c1++) popnames.Add(inputdata->getPopName(c1,true));
*/
  }
}
