
#ifndef POPSWINDOW_H
#define POPSWINDOW_H

#include <wx/wx.h>
#include <wx/grid.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/combobox.h>
#include <wx/arrstr.h>
#include <wx/tokenzr.h>

#include "inputdata.h"

#define POPSWINDOW_ID_OKBUTTON 1
#define POPSWINDOW_ID_CANCELBUTTON 2
#define POPSWINDOW_ID_INFERBUTTON 3

using namespace std;

class PopsWindow : public wxFrame
{
  public:
  PopsWindow(InputData *inputdata,wxPanel *parent, int id,const wxString& title);
  void OnOkButton(wxCommandEvent & event);
  void OnSize(wxSizeEvent & event);
  inline void OnCancelButton(wxCommandEvent & event){
    Close(true);
  };
  void OnInferButton(wxCommandEvent & event);
  wxString guessPopString(wxString tmp);

  protected:
  wxFlexGridSizer *vsizer;
  //wxFlexGridSizer *hsizer;
  wxPanel *toppanel;
  wxPanel *parent;
  wxGrid * namegrid;
  wxScrolledWindow * scroller;
  wxButton *okButton;
  wxButton *cancelButton;
  wxButton *inferButton;

  InputData *inputdata;

};

#endif
