
#include <wx/stdpaths.h>
#include "finegui.xpm"

#include "reorderpop.h"


ReorderPop::ReorderPop(int popnumber,InputData *inputdata,wxPanel *parent, int id,const wxString& title):
      wxFrame(NULL, id, title, wxDefaultPosition, wxDefaultSize)
{
  this->popnumber=popnumber;
  SetSize(wxSize(400,420));
  this->inputdata=inputdata;
  this->parent=parent;

  toppanel = new wxPanel(this, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_NONE);
  toppanel->SetMinSize(wxSize(400,30));
  toppanel->SetSize(wxSize(400,30));
  wxBoxSizer *vsizer=new wxBoxSizer(wxVERTICAL);
  wxBoxSizer *hsizer=new wxBoxSizer(wxHORIZONTAL);

  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);

  okButton=new wxButton(toppanel, REORDERPOP_ID_OKBUTTON, wxT("Accept"));
  cancelButton=new wxButton(toppanel, REORDERPOP_ID_CANCELBUTTON, wxT("Cancel"));
  applyButton=new wxButton(toppanel, REORDERPOP_ID_APPLYBUTTON, wxT("Apply"));
  upButton=new wxButton(toppanel, REORDERPOP_ID_UPBUTTON, wxT("Up"));
  downButton=new wxButton(toppanel, REORDERPOP_ID_DOWNBUTTON, wxT("Down"));
  hsizer->Add(okButton,1,wxEXPAND);
  hsizer->Add(cancelButton,1,wxEXPAND);
  hsizer->Add(applyButton,1,wxEXPAND);
  hsizer->Add(upButton,1,wxEXPAND);
  hsizer->Add(downButton,1,wxEXPAND);
  toppanel->SetSizerAndFit(hsizer);
  vsizer->Add(toppanel);
    hsizer->SetSizeHints( toppanel );
  //neworder= new wxListCtrl(this,REORDERPOP_ID_NEWORDER, wxPoint(0,40), wxSize(400,20), wxLC_ICON,  wxDefaultValidator,wxListCtrlNameStr);
  neworder= new wxListBox(this,REORDERPOP_ID_NEWORDER, wxPoint(0,40), wxSize(400,20));
  oldindex=inputdata->getIndInPopIndexes(popnumber);
  newindex=oldindex;
  vector<const wxString*> oldvals;
  for(unsigned long c1=0;c1<oldindex.size();c1++){
    oldvals.push_back(new wxString(inputdata->getName(oldindex[c1])));
  }
  for(unsigned long c1=0;c1<oldindex.size();c1++){
    wxString val=inputdata->getName(oldindex[c1]) ;
    neworder->Insert(val,c1);
  }
  vsizer->Add(neworder);
  vsizer->Fit(this);
  vsizer->SetSizeHints( this );
  SetSizerAndFit(vsizer);

  SetSize(wxSize(400,420));
  wxSize newnamesize=GetSize();
  newnamesize.y-=40;
  neworder->SetSize(newnamesize);
  SetSize(wxSize(400,420));
  Connect(REORDERPOP_ID_OKBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderPop::OnOkButton));
  Connect(REORDERPOP_ID_CANCELBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderPop::OnCancelButton));
  Connect( wxEVT_SIZE, wxSizeEventHandler( ReorderPop::OnSize ));
  //Connect(REORDERPOP_ID_NEWORDER, wxEVT_COMMAND_LIST_INSERT_ITEM, wxListEventHandler(ReorderPop::OnListDrag));
  Connect(REORDERPOP_ID_APPLYBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderPop::OnApplyButton));
  Connect(REORDERPOP_ID_UPBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderPop::OnUpButton));
  Connect(REORDERPOP_ID_DOWNBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderPop::OnDownButton));
  //Connect(-1, wxEVT_MOUSEWHEEL, wxMouseEventHandler(ReorderPop::OnMiddleWheel) );
  Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( ReorderPop::OnMiddleWheel ), NULL, this );
  neworder->Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( ReorderPop::OnMiddleWheel ), NULL, this );
  
  neworder->SetToolTip(wxT("Order of individuals. Try holding Ctrl and using the mouse wheel."));
  upButton->SetToolTip(wxT("Move selected population up by 1.  Try  holding Ctrl and scrolling the mouse wheel up instead."));
  downButton->SetToolTip(wxT("Move selected population down by 1.  Try  holding Ctrl and scrolling the mouse wheel down instead."));  
}

void ReorderPop::OnOkButton(wxCommandEvent & event)
{
  inputdata->reorderPop(popnumber,newindex);

  parent->Refresh();
  Close(true);
}

void ReorderPop::OnApplyButton(wxCommandEvent & event)
{
  inputdata->reorderPop(popnumber,newindex);
  parent->Refresh();
}

void ReorderPop::OnSize(wxSizeEvent & event)
{
  wxSize newnamesize=GetSize();
  newnamesize.y-=50;
  newnamesize.x-=10;
  neworder->SetSize(newnamesize);
}

/*void ReorderPop::OnListDrag(wxListEvent & event)
{
  //cout<<"I'm inserting "<<endl;
}*/

void ReorderPop::itemup()
{

  //wxArrayInt sel;
  //neworder->GetSelections(sel);
  //if(sel.size()==0) return;
  //int  i=sel[0];
  int i=neworder->GetSelection();
  if(i==wxNOT_FOUND) return;
  //cout<<"Moving item "<<i<<endl;
  if(i>0){
    long val=newindex[i];
    newindex.erase(newindex.begin()+i);
    newindex.insert(newindex.begin()+i-1,val);
    wxString valstring=neworder->GetStringSelection();
    neworder->Delete(i);
    neworder->Insert(valstring,i-1);
    neworder->Select(i-1);
  }
}

void ReorderPop::itemdown()
{
  int i=neworder->GetSelection();
  if(i==wxNOT_FOUND) return;

  if(i<(int)newindex.size()-1){
    long val=newindex[i];
    newindex.erase(newindex.begin()+i);
    newindex.insert(newindex.begin()+i+1,val);
    wxString valstring=neworder->GetStringSelection();
    neworder->Delete(i);
    neworder->Insert(valstring,i+1);
    neworder->Select(i+1);
  }
}

