
#ifndef REORDERPOP_H
#define REORDERPOP_H

#include <wx/wx.h>
#include <wx/listbox.h>
//#include <wx/listctrl.h>
//#include <wx/dnd.h>
#include <wx/event.h>

#include "inputdata.h"


#define REORDERPOP_ID_OKBUTTON 901
#define REORDERPOP_ID_CANCELBUTTON 902
#define REORDERPOP_ID_NEWORDER 903
#define REORDERPOP_ID_UPBUTTON 904
#define REORDERPOP_ID_DOWNBUTTON 905
#define REORDERPOP_ID_APPLYBUTTON 906

using namespace std;


class ReorderPop : public wxFrame
{
  public:
  ReorderPop(int popnumber,InputData *inputdata,wxPanel *parent, int id,const wxString& title);
  void OnOkButton(wxCommandEvent & event);
  void OnApplyButton(wxCommandEvent & event);
  void OnSize(wxSizeEvent & event);
  inline void OnUpButton(wxCommandEvent & event){
    itemup();
  };
  inline void OnDownButton(wxCommandEvent & event){
    itemdown();
  };
 // void OnListDrag(wxListEvent & event);
  inline void OnCancelButton(wxCommandEvent & event){
    Close(true);
  };
  inline void OnMiddleWheel(wxMouseEvent & event){
      if(event.ControlDown()){
          if(event.GetWheelRotation()>0) itemup();
          else itemdown();
      }else event.Skip();
  }

  void itemup();
  void itemdown();
  protected:
    int draggeditem;
  wxPanel *toppanel;
  wxPanel *parent;
  wxScrolledWindow * scroller;
  wxButton *okButton;
  wxButton *cancelButton;
  wxButton *applyButton;
  wxButton *upButton;
  wxButton *downButton;
  int popnumber;
  InputData *inputdata;
  wxListBox *neworder;
   vector<int> oldindex;
   vector<int> newindex;


};


#endif
