#include "scale.h"

Scale::Scale(Heatmap *hm,VisGrid *visgrid,wxPanel *parent, int id)
      : wxVirtualPanel(parent, id, wxDefaultPosition, wxSize(100, -1), wxBORDER_NONE)
{
  this->visgrid=visgrid;
  this->hm=hm;
  m_parent = parent;
  Connect(wxEVT_PAINT, wxPaintEventHandler(Scale::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(Scale::OnSize));
  setSize(100);
}

Scale::Scale(VisGrid *visgrid,wxPanel *parent, int id)
      : wxVirtualPanel(parent, id, wxDefaultPosition, wxSize(100, -1), wxBORDER_NONE)
{
  this->visgrid=visgrid;
  this->hm=NULL;
  m_parent = parent;
  Connect(wxEVT_PAINT, wxPaintEventHandler(Scale::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(Scale::OnSize));
  setSize(100);
}

void Scale::OnPaint(wxPaintEvent& event)
{
  wxPaintDC dc(this);
  show(dc);
}

void Scale::show(wxDC&  dc){
// Show the boundaries, if appropriate  
  if(hm==NULL) return;
  wxString lasttext=wxT("");
  wxFont font(visgrid->getScaleTextSize(), wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
  dc.SetFont(font);
  dc.SetPen(wxPen(wxColour(255, 255,255)));
  dc.SetBrush(wxBrush(wxColour(255, 255,255)));
  dc.DrawRectangle(0,0, GetSize().x,GetSize().y);
  wxSize size=GetSize();

  size-=wxSize(10,120);
  int sbs=visgrid->getScaleBarSize();
  long thisgrad=visgrid->getGrad();
  long yrange=ceil(size.y/(1.0+thisgrad));
  long yrangefull=size.y;
  long ytop0=floor(size.y+20- size.y*(-1.0)/(1.0+thisgrad)+20);

  if(visgrid->getScaleMin()>0){

    dc.SetPen(wxPen(wxColor(155,155,155)));
    dc.SetBrush(wxBrush(wxColor(155,155,155)));//wxBrush(hm->getColNorm(c1/(double)visgrid->getGrad())));
    
    dc.DrawRectangle(size.x-sbs,ytop0,sbs,20+yrange);
    dc.SetPen(wxPen(wxColor(255,255,255)));
    dc.SetBrush(wxBrush(wxColor(255,255,255)));//wxBrush(hm->getColNorm(c1/(double)visgrid->getGrad())));
  
    dc.DrawRectangle(size.x-sbs+1,ytop0-2,sbs-2,20+yrange-1);
    wxString text0= wxT("lower");
    int swidth0, sheight0;
    GetTextExtent(text0,&swidth0,&sheight0,NULL, NULL, &font);    
    dc.DrawText(text0, size.x-sbs-swidth0-5,ytop0 + 3.0*(yrange/2.0)+sheight0/2.0);    
  }
   if(visgrid->getScale()>0){
    dc.SetPen(wxPen(wxColor(0,0,0)));
    dc.SetBrush(wxBrush(wxColor(0,0,0)));//wxBrush(hm->getColNorm(c1/(double)visgrid->getGrad())));
    dc.DrawRectangle(size.x-sbs,yrange+20,sbs,20+yrange);
    wxString text= wxT("higher");
    int swidth, sheight;
    GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);    
    dc.DrawText(text, size.x-sbs-swidth-5,(20+yrange)*0.1+20-sheight/2.0);    
  } 
// construct the default vector to display
  vector<wxString> labels;
  vector<double> vals;
  int pc=0;
  for(int c1=0;c1<=thisgrad;c1++){
    double val=hm->getMin() + (hm->getMax()-hm->getMin())*c1/(double)thisgrad;
    double ytop=floor(size.y+20 - size.y*(c1+0.0)/(1.0+thisgrad)+20);
    if((pc==0 || c1==0 || c1==thisgrad)&&(val>=0)){
      wxString text = wxString::Format(visgrid->getScaleFormat(), val);
      labels.push_back(text);
      vals.push_back(val);
      lasttext=text;    
    }
    dc.SetPen(wxPen(hm->getCol(val)));
    dc.SetBrush(wxBrush(hm->getCol(val)));
    dc.DrawRectangle(size.x-sbs,ytop,sbs,yrange);      
    pc++;
    if(pc==visgrid->getScaleSkip()) pc=0;  
  }
  if(labels.size()==0) return;

  cleanupLabels(labels,vals);
  showLabels(dc,labels,vals,size,ytop0,yrangefull);
  
}

long Scale::convertValToY(double val,int ymin,int yrange){
  return(floor((double)ymin + (val-(double)hm->getMin())/(double)(hm->getMax() - hm->getMin()) * (double)(yrange)));
}

void Scale::showLabels(wxDC&  dc,vector<wxString> labels,vector<double> vals,wxSize size,int ymin,int yrange){
  wxFont font(visgrid->getScaleTextSize(), wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);
  for(int c1=0;c1<(int)labels.size();c1++){
    long ytop=convertValToY(vals[c1],ymin,-yrange);
    int swidth, sheight;
    wxString text=labels[c1];
    GetTextExtent(text,&swidth,&sheight,NULL, NULL, &font);    
    dc.DrawText(text, size.x-visgrid->getScaleBarSize()-swidth-5,ytop -sheight/2.0);//+ (yrange/2.0)
  }
}


void Scale::cleanupLabels(vector<wxString> &labels,vector<double> &vals){
  double value=0;
  labels[0].ToDouble(&value);
  vals[0]=value;
  for(unsigned int c1=1;c1<labels.size();c1++){
    if(labels[c1]==labels[c1-1]){
      labels.erase(labels.begin()+c1);
      vals.erase(vals.begin()+c1);
      c1--;
    }else {
      double value=0;
      labels[c1].ToDouble(&value);
      vals[c1]=value;
    }
  }
}

void Scale::OnSize(wxSizeEvent& event)
{
  Refresh();
}

