
#include <wx/stdpaths.h>
#include "finegui.xpm"

#include <wx/tokenzr.h>

#include "scalechooser.h"

#define NUMLISTCHOICES 3
const wxString listchoices [NUMLISTCHOICES]= {wxT("Custom"),wxT("Simple"),wxT("High Contrast 1") };


ScaleChooser::ScaleChooser(Heatmap *heatmap,wxPanel *parent, int id,const wxString& title):
      wxFrame(parent, id, title, wxDefaultPosition, wxDefaultSize)
{

      #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);

  SetSize(wxSize(520,300));
  this->heatmap=heatmap;
  this->parent=parent;
//  namegrid = new wxGrid(this,-1, wxPoint(0,40), GetSize(), wxWANTS_CHARS, wxPanelNameStr);
  namegrid = new wxGrid(this,-1, wxPoint(0,30), wxSize(520,300), wxWANTS_CHARS, wxPanelNameStr);
  namegrid->CreateGrid( 1, 4 ); 
  vsizer=new wxFlexGridSizer(2,1,0,0);
  hsizer=new wxFlexGridSizer(1,5,0,0);
  vsizer->AddGrowableRow(1);
  vsizer->AddGrowableCol(0);
  hsizer->AddGrowableCol(0);
  hsizer->AddGrowableCol(1);
  hsizer->AddGrowableCol(2);
  hsizer->AddGrowableCol(3);
  toppanel = new wxPanel(this, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_NONE);
  toppanel->SetMinSize(wxSize(250,30));
  toppanel->SetSize(wxSize(250,30));
  okButton=new wxButton(toppanel, SCALECHOOSER_ID_OKBUTTON, wxT("Accept"));
  applyButton=new wxButton(toppanel, SCALECHOOSER_ID_APPLYBUTTON, wxT("Apply"));  
  cancelButton=new wxButton(toppanel, SCALECHOOSER_ID_CANCELBUTTON, wxT("Cancel"));
  inferButton=new wxButton(toppanel, SCALECHOOSER_ID_INFERBUTTON, wxT("Reset"));
  //newButton=new wxButton(toppanel, SCALECHOOSER_ID_NEWBUTTON, wxT("Default"));
  defaultsBox=new wxComboBox(toppanel, SCALECHOOSER_ID_DEFAULTSBOX, listchoices[0],wxDefaultPosition,wxSize(200,30),NUMLISTCHOICES,
			    listchoices,wxCB_READONLY);		    
  hsizer->Add(okButton,1,wxEXPAND);
  hsizer->Add(applyButton,1,wxEXPAND);
  hsizer->Add(cancelButton,1,wxEXPAND);
  hsizer->Add(inferButton,1,wxEXPAND);
  //hsizer->Add(newButton,1,wxEXPAND);
  hsizer->Add(defaultsBox,1,wxEXPAND);
  hsizer->SetSizeHints( toppanel );
  toppanel->SetSizerAndFit(hsizer);
  
  vsizer->Add(toppanel,1,wxEXPAND);
  vsizer->Add(namegrid,1,wxEXPAND);
  SetSizerAndFit(vsizer);
    Fit();
//  vsizer->SetSizeHints( this);
//
  updateGrid(heatmap->getScaleColours(),heatmap->getScaleTimes());
  namegrid->SetColMinimalWidth( 0, 180 );
  namegrid->SetColMinimalWidth( 1, 180 );
  namegrid->SetColMinimalWidth( 2, 280 );
  namegrid->SetColMinimalWidth( 3, 280 );
  namegrid->Fit();
  namegrid->ForceRefresh();

  Connect(SCALECHOOSER_ID_OKBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ScaleChooser::OnOkButton));
  Connect(SCALECHOOSER_ID_APPLYBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ScaleChooser::OnApplyButton));
  Connect(SCALECHOOSER_ID_CANCELBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ScaleChooser::OnCancelButton));
  Connect(SCALECHOOSER_ID_INFERBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ScaleChooser::OnInferButton));
  //Connect(SCALECHOOSER_ID_NEWBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ScaleChooser::OnNewButton));
  Connect(SCALECHOOSER_ID_DEFAULTSBOX, wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler(ScaleChooser::OnDefaultChoice));
  Connect( wxEVT_GRID_CELL_LEFT_CLICK, wxGridEventHandler( ScaleChooser::OnGridCellClick ));
  Connect( wxEVT_GRID_CELL_LEFT_CLICK, wxGridEventHandler( ScaleChooser::OnGridCellClick ));
  Connect( wxID_ANY, wxEVT_KEY_DOWN,wxKeyEventHandler(ScaleChooser::OnGridKeyDown));

  Connect( wxEVT_GRID_CELL_CHANGE, wxGridEventHandler( ScaleChooser::OnGridCellChanged ));

//  Connect(SCALECHOOSER_ID_GRIDCLICK, wxEVT_GRID_CELL_LEFT_CLICKED, wxGridEvent(
  Connect( wxEVT_SIZE, wxSizeEventHandler( ScaleChooser::OnSize ));
  okButton->SetToolTip(wxT("Apply the current colours to the heatmap and close this window"));
  applyButton->SetToolTip(wxT("Apply the current colours to the heatmap"));
  cancelButton->SetToolTip(wxT("Close this window without changing the colour scheme"));
  inferButton->SetToolTip(wxT("Reset colours to how they were before this dialog was loaded"));
  defaultsBox->SetToolTip(wxT("Use one of the fineSTRUCTURE defaults"));
  namegrid->SetToolTip(wxT("Choose a new colour by clicking in the coloured column, or by specifying RGB values from 0 to 255.  Add a new colour by clicking in the final row.  Delete the current row with the \"Delete\" key.  The \"Length\" controls how much slowly the scale changes from this colour; the final value is ignored."));
}

void ScaleChooser::updateGrid(vector<vector<double> > hmcols, vector<double> hmtimes)
{
  if(hmcols.size()==0) return;
  vector<vector<int> > hmcolsint(hmcols.size(), vector<int>(3,0));
  for(unsigned int c1=0;c1<hmcols.size();c1++) for(unsigned int c2=0;c2<hmcols[c1].size();c2++) {
    if(c2<3) hmcolsint[c1][c2]=hmcols[c1][c2]*255;
  }
  updateGrid(hmcolsint,hmtimes);
}

void ScaleChooser::updateGrid(vector<vector<int> > hmcols, vector<double> hmtimes)
{
  
  this->hmcols = hmcols;
  this->hmtimes = hmtimes;
 while(namegrid->GetNumberRows()< (int)hmcols.size()+1) namegrid->InsertRows(namegrid->GetNumberRows(),1);
  while(namegrid->GetNumberRows()> (int)hmcols.size()+1) namegrid->DeleteRows(namegrid->GetNumberRows()-1,1);
    // And set grid cell contents as strings
  for(unsigned int c1=0;c1<hmcols.size();c1++){
    wxString counter,curtime;
    counter<<c1;
    curtime<<hmtimes[c1];
    namegrid->SetCellValue( c1, 0, counter);
    namegrid->SetCellValue( c1, 1, curtime);
    namegrid->SetCellValue( c1, 2, colVecAsString(hmcols[c1]));
    namegrid->SetReadOnly( c1, 3 );
    namegrid->SetCellBackgroundColour(c1, 3, getCol(hmcols[c1]));
  }
  namegrid->SetCellValue(hmcols.size(), 0, wxT(""));
  namegrid->SetCellValue(hmcols.size(), 1, wxT(""));
  namegrid->SetCellValue(hmcols.size(), 2, wxT(""));
  namegrid->SetCellBackgroundColour(hmcols.size(), 3, getCol(vector<int>(3,255)));
  if(hmcols.size()>0){
    namegrid->SetColLabelValue(0,wxT("Order"));
    namegrid->SetColLabelValue(1,wxT("Length"));
    namegrid->SetColLabelValue(2,wxT("          RGB         "));
    namegrid->SetColLabelValue(3,wxT("         Colour       "));
  }
}

void ScaleChooser::OnOkButton(wxCommandEvent & event)
{
  OnApplyButton(event);
  Close(true);
}

void ScaleChooser::OnApplyButton(wxCommandEvent & event)
{
  if(hmcols.size()==0) return;
  vector<vector<double> > rgbdbl(hmcols.size(), vector<double>(3,0));
  for(unsigned int c1=0;c1<hmcols.size();c1++) for(unsigned int c2=0;c2<hmcols[c1].size();c2++) {
    if(c2<3) rgbdbl[c1][c2]=(double)hmcols[c1][c2]/255.0;
  }
  if(hmtimes.size()>0) hmtimes[hmtimes.size()-1]=0;/// last time is meaningless
  heatmap->setColours(rgbdbl, hmtimes);
  parent->Refresh();
}


void ScaleChooser::OnSize(wxSizeEvent & event)
{
  // vsizer->Fit(this);
  wxSize newnamesize=GetSize();
  newnamesize.y-=50;
  newnamesize.x-=10;
  namegrid->SetSize(newnamesize);
}

void ScaleChooser::OnDefaultChoice(wxCommandEvent & event)
{
  vector<vector<double> > thmcols;
  vector<double> thmtimes;
  
  if(defaultsBox->GetValue()==listchoices[0]){
    return;
  }else if(defaultsBox->GetValue()==listchoices[1]){
    thmcols=heatmap->getDefaultColours();
    thmtimes=heatmap->getDefaultSpeed();
  }else if(defaultsBox->GetValue()==listchoices[2]){
    thmcols=heatmap->wxStringAsColourVector(wxT("1,1,1;1,0.921569,0.411765;0.823529,0.784314,0;1,0.521569,0;1,0,0;1,0,1;0.47451,0,1;0,0,1;0.00784314,0,0.556863;0.227451,0.227451,0.227451;0,0,0"));
    thmtimes=heatmap->wxStringAsColourTimes(wxT("0.1;0.1;0.1;0.1;0.1;1;1;1;1;1;0"));
  }
  updateGrid(thmcols,thmtimes);
  Refresh();
}

void ScaleChooser::OnInferButton(wxCommandEvent & event)
{
  namegrid->ClearGrid();
  updateGrid(heatmap->getScaleColours(),heatmap->getScaleTimes());
  Refresh();
}

void ScaleChooser::OnGridCellClick(wxGridEvent &event)
{
  int row=event.GetRow();
  int col=event.GetCol();
  if((col==3 &&(row>=0) && row<(int)hmcols.size()) || (row==(int) hmcols.size()) ){ // process click on colour
    wxColourData tcol;
    tcol.SetColour(namegrid->GetCellBackgroundColour(row,3));
    wxColourDialog tdialog(this,&tcol);

    if(tdialog.ShowModal()==wxID_OK){
//      cout<<"Accepted colour for row "<<row<<endl;
      if(row==(int) hmcols.size()){
	vector<int> tmp(3,0);
	hmcols.push_back(tmp);
	hmtimes.push_back(0);
	wxString counter;
	counter<<row;
	namegrid->SetCellValue(row,0,counter);
	namegrid->SetCellValue(row,1,wxT("0"));
	namegrid->SetCellValue(row,2,wxT("0, 0, 0"));
	if(row>0) if (hmtimes[row-1]==0) hmtimes[row-1]=1;
      }
      UpdateOnColourChange(row, tdialog.GetColourData().GetColour());
      updateGrid(hmcols,hmtimes);
      defaultsBox->SetValue(listchoices[0]);
    }
  }else{//skip
    event.Skip();
  }
}

void ScaleChooser::OnGridCellChanged(wxGridEvent &event)
{
  
  int row=event.GetRow();
  int col=event.GetCol();
  switch(col){
    case 0: reorderRows(row);break;
    case 1: if(!namegrid->GetCellValue(row,col).ToDouble(&(hmtimes[row]))){ wxString tmp;tmp<<hmtimes[row]; namegrid->SetCellValue(row,col, tmp); }; break;
    case 2: assignNewColour(row,namegrid->GetCellValue(row,col));break;
  }
  defaultsBox->SetValue(listchoices[0]);
  event.Skip();
}

void ScaleChooser::reorderRows(int changedrow)
{
  int newval=wxAtoi(namegrid->GetCellValue(changedrow, 0));
  if(newval<0) newval=0;
  if(newval>=(int)hmcols.size()) newval=hmcols.size()-1;
  int updatedrow=changedrow;
  
  if(changedrow==(int)hmtimes.size()-1) hmtimes[changedrow]=1;
  
  hmtimes.insert(hmtimes.begin()+ newval,hmtimes[changedrow]);
  hmcols.insert(hmcols.begin() + newval,hmcols[changedrow]);
  if(newval<changedrow) updatedrow++;
  hmtimes.erase(hmtimes.begin() + updatedrow);
  hmcols.erase(hmcols.begin() + updatedrow);
  
  if(changedrow==(int)hmtimes.size()-1) hmtimes[hmtimes.size()-1]=0;
  
  wxString counter;
  counter<<changedrow;
  namegrid->SetCellValue(changedrow, 0,counter);
  updateGrid(hmcols,hmtimes);
  defaultsBox->SetValue(listchoices[0]);
//  cout<<"Reorder on row "<<changedrow<<endl;
}

void ScaleChooser::assignNewColour(int row,wxString valwx)
{
  
    wxStringTokenizer tokenizer(valwx, wxT(","));
    vector<int> newcol(3,0);
    int count=0;
    bool success=false;
    while ( tokenizer.HasMoreTokens() )
    {
        wxString token = tokenizer.GetNextToken();
	if(count<3) {
	  int tval = wxAtoi(token);
	  if(tval<0) tval=0;
	  if(tval>255) tval=255;
	  newcol[count++]=tval;
	}
	if(count>=3) success=true;
    }
  if(!success) {
 //   cout<<"failed to assign colour ("<<newcol[0]<<","<<newcol[1]<<","<<newcol[2]<<") to row "<<row<<endl;
    namegrid->SetCellValue(row,2,colVecAsString(hmcols[row]));
    return;
  }
  for(int i=0;i<3;i++) hmcols[row][i] = newcol[i];
  namegrid->SetCellValue(row,2,colVecAsString(hmcols[row]));
  namegrid->SetCellBackgroundColour(row, 3, getCol(hmcols[row]));
//  cout<<"Assign colour ("<<newcol[0]<<","<<newcol[1]<<","<<newcol[2]<<") to row "<<row<<endl;
  
}
  
void ScaleChooser::UpdateOnColourChange(int row,wxColour newcolour)
{
//  cout<<"Updating row "<<row<<endl;
  hmcols[row][0] = newcolour.Red();
  hmcols[row][1] = newcolour.Green();  
  hmcols[row][2] = newcolour.Blue();  
  namegrid->SetCellValue(row,2,colVecAsString(hmcols[row]));
  namegrid->SetCellBackgroundColour(row, 3, getCol(hmcols[row]));
  Refresh();
}

void ScaleChooser::UpdateOnLabelEdit(int row)
{
}

wxColour ScaleChooser::getCol(vector<int> rgbval)
{
  return(wxColour(rgbval[0],rgbval[1],rgbval[2]));
}

wxString ScaleChooser::colVecAsString(vector<int> rgbval)
{
  wxString tmp;
  for(unsigned int c1=0;c1<rgbval.size()-1;c1++){
    tmp<<rgbval[c1];
    tmp.Append(wxT(", "));
  }
  tmp<<rgbval[rgbval.size()-1];
  return(tmp);
}

void ScaleChooser::removeRow(int rowrem)
{
   hmcols.erase(hmcols.begin()+rowrem);
   hmtimes.erase(hmtimes.begin()+rowrem);
   namegrid->SetCellValue(hmcols.size(),0,wxT(""));
   hmtimes[hmtimes.size()-1]=0;
}

void ScaleChooser::OnGridKeyDown(wxKeyEvent &event)
{
    if(event.GetKeyCode()==WXK_DELETE){
    int currow=namegrid->GetGridCursorRow();
    cout<<" deleting "<<currow<<endl;
    removeRow(currow);
    updateGrid(hmcols,hmtimes);
    defaultsBox->SetValue(listchoices[0]);
    /*
    cout<<namegrid->IsSelection()<<endl;
    wxArrayInt rowselect=namegrid->GetSelectedRows();
    if(rowselect.GetCount()>0) {
      removeRow(rowselect[0]);
    }
    wxGridCellCoordsArray selections =namegrid->GetSelectedCells();
    if(selections.GetCount()>0) {
      removeRow(selections[0].GetRow());
    } */ 
/*    //wxArrayInt selections;
    cout<<"A"<<endl;
      int i=filesSelected->GetSelection();
    cout<<"B"<<endl;
    if(i==wxNOT_FOUND) return;
    cout<<"C"<<endl;
    int sel=filesSelected->GetSelection();
    cout<<"got selections..."<<endl;
    //for(unsigned int c1=0;c1<selections.Count();c1++){
        //cout<<"deleting "<<selections[c1]<<endl;
      cout<<"deleting "<<(int)sel<<endl;
//    }
*/
  }else {
    event.Skip();
  }

}
