#include "settings_io.h"

//#define DEBUGPRINT(x) cout<<x<<endl
#define DEBUGPRINT(x)

SettingsIO::SettingsIO(FineMainWindow *mainwin)
{
  this->inputdata=mainwin->getInputData();
  this->inputdata2=mainwin->getInputData2();
  //this->finedisplay=mainwin->getFineDisplay();
  this->mainwin=mainwin;
  fsxml=NULL;
  fb=NULL;
  os=NULL;
  status=SETTINGS_CLEAR;
  readtree=false;
  filename=wxFileName(wxT("."),wxT("fsgui_settings.xml"));
}

void SettingsIO::writeHeader()
{
  if(status!=SETTINGS_WRITE || os==NULL) return;
  writeTag(string("fsgui_settings"),true);
}

void SettingsIO::writeFooter()
{
  if(status!=SETTINGS_WRITE || os==NULL) return;
  writeTag(string("/fsgui_settings"),true);
}

void SettingsIO::writeSettings()
{
  if(status!=SETTINGS_WRITE || os==NULL) return;
  writeTag(string("settings"),true);

  writeOneLineTag(wxT("showXtree"),asWxString(mainwin->showXtree->IsChecked()));
  writeOneLineTag(wxT("showYtree"),asWxString(mainwin->showYtree->IsChecked()));
  writeOneLineTag(wxT("showXlab"),asWxString(mainwin->showXlab->IsChecked()));
  writeOneLineTag(wxT("showYlab"),asWxString(mainwin->showYlab->IsChecked()));
  writeOneLineTag(wxT("showScale"),asWxString(mainwin->showScale->IsChecked()));

  writeOneLineTag(wxT("wholeXsize"),mainwin->wholeXsize->GetValue());
  writeOneLineTag(wxT("wholeYsize"),mainwin->wholeYsize->GetValue());

  writeOneLineTag(wxT("treeXsize"),mainwin->treeXsize->GetValue());
  writeOneLineTag(wxT("treeYsize"),mainwin->treeYsize->GetValue());
  writeOneLineTag(wxT("treePenWidth"),mainwin->treePenWidth->GetValue());

  writeOneLineTag(wxT("labelXsize"),mainwin->labelXsize->GetValue());
  writeOneLineTag(wxT("labelYsize"),mainwin->labelYsize->GetValue());
  writeOneLineTag(wxT("fontSize"),mainwin->fontSize->GetValue());

  writeOneLineTag(wxT("usePopLabels"),asWxString(mainwin->usePopLabels->IsChecked()));
  writeOneLineTag(wxT("perpPopLabels"),asWxString(mainwin->perpPopLabels->IsChecked()));

  writeOneLineTag(wxT("scaleWidth"),mainwin->scaleWidth->GetValue());
  writeOneLineTag(wxT("scaleBarSize"),mainwin->scaleBarSize->GetValue());
  writeOneLineTag(wxT("scaleTextSize"),mainwin->scaleTextSize->GetValue());
  writeOneLineTag(wxT("scaleFormat"),mainwin->scaleFormat->GetValue());
  writeOneLineTag(wxT("scaleMax"),mainwin->scaleMax->GetValue());

  writeOneLineTag(wxT("sepcontscale"),asWxString(inputdata->getUseMod()));
  writeOneLineTag(wxT("contsize"),asWxString(inputdata->getContSize()));
  writeOneLineTag(wxT("showContinentRows"),asWxString(mainwin->showContinentRows->IsChecked()));
  writeOneLineTag(wxT("showContinentCols"),asWxString(mainwin->showContinentCols->IsChecked()));
  writeOneLineTag(wxT("showClassification"),asWxString(mainwin->useClassifyLabels->IsChecked()));
  writeOneLineTag(wxT("classificationSize"),mainwin->classificationSize->GetValue());
  
  vector<vector<double> > scalecol=mainwin->getFineDisplay()->getScaleColours();
  wxString scalecolwx;
  for(unsigned int c1=0;c1<scalecol.size();c1++){
    scalecolwx<<scalecol[c1][0]; scalecolwx.Append(wxT(",")); scalecolwx<<scalecol[c1][1]; scalecolwx.Append(wxT(",")); scalecolwx<<scalecol[c1][2];
    if(c1<scalecol.size()-1) scalecolwx.Append(wxT(";"));
  }
  writeOneLineTag(wxT("scalecolours"),scalecolwx);

  vector<double> scaletimes=mainwin->getFineDisplay()->getScaleTimes();
  wxString scaletimewx;
  for(unsigned int c1=0;c1<scalecol.size();c1++){ 
    scaletimewx<<scaletimes[c1]; if(c1<scaletimes.size()-1) scaletimewx.Append(wxT(";"));
  }
  writeOneLineTag(wxT("scaletimes"),scaletimewx); 
  
  writeTag(string("/settings"),true);
}

void SettingsIO::readSettings(wxProgressDialog *readProg,int pcur, int pmax)
{
  wxCommandEvent event;
  string val;
  if(status!=SETTINGS_READ || fsxml==NULL) return;
  //fsxml->rewind();
  std::streampos sp = fsxml->gotoLineContaining(string("<settings>"));
  double numchange=27;
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Reading settings") ;

  try{val=fsxml->getParam(string("showXtree"), sp);
  mainwin->checkXtree(stringToInt(val),false);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read Xtree") ;

  try{val=fsxml->getParam(string("showYtree"), sp);
  mainwin->checkYtree(stringToInt(val),false);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read Ytree") ;

  try{val=fsxml->getParam(string("showXlab"), sp);
  mainwin->checkXlabels(stringToInt(val),false);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read showXlab") ;

  try{val=fsxml->getParam(string("showYlab"), sp);
  mainwin->checkYlabels(stringToInt(val),false);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read showYlab") ;

  try{val=fsxml->getParam(string("showScale"), sp);
  mainwin->showScale->SetValue(stringToInt(val));
  mainwin->applyShowScale(false);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read showScale") ;

  try{val=fsxml->getParam(string("wholeXsize"), sp);
  mainwin->wholeXsize->SetValue(asWxString(val));
  mainwin->OnXsizeCtl(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read wholeXsize") ;

  try{val=fsxml->getParam(string("wholeYsize"), sp);
  mainwin->wholeYsize->SetValue(asWxString(val));
  mainwin->OnYsizeCtl(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read wholeYsize") ;

  try{val=fsxml->getParam(string("treeXsize"), sp);
  mainwin->treeXsize->SetValue(asWxString(val));
  mainwin->OnTreeXsizeCtl(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read treeXsize") ;

  try{val=fsxml->getParam(string("treeYsize"), sp);
  mainwin->treeYsize->SetValue(asWxString(val));
  mainwin->OnTreeYsizeCtl(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read treeYsize") ;

  try{val=fsxml->getParam(string("treePenWidth"), sp);
  mainwin->treePenWidth->SetValue(asWxString(val));
  mainwin->OnTreePenWidth(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read treePenWidth") ;

  try{val=fsxml->getParam(string("labelXsize"), sp);
  mainwin->labelXsize->SetValue(asWxString(val));
  mainwin->OnLabelXsizeCtl(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read labelXsize") ;

  try{val=fsxml->getParam(string("labelYsize"), sp);
  mainwin->labelYsize->SetValue(asWxString(val));
  mainwin->OnLabelYsizeCtl(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read labelYsize") ;

  try{val=fsxml->getParam(string("fontSize"), sp);
  mainwin->fontSize->SetValue(asWxString(val));
  mainwin->OnFontSize(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read fontSize") ;

  try{val=fsxml->getParam(string("usePopLabels"), sp);
  mainwin->checkUsePopLabels(stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read usePopLabels") ;

  try{val=fsxml->getParam(string("perpPopLabels"), sp);
  mainwin->perpPopLabels->SetValue(stringToInt(val));
  mainwin->checkPerpPopLabels(stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read perpPopLabels") ;

  try{val=fsxml->getParam(string("scaleWidth"), sp);
  mainwin->scaleWidth->SetValue(asWxString(val));
  mainwin->OnScaleWidth(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read scaleWidth") ;

  try{val=fsxml->getParam(string("scaleBarSize"), sp);
  mainwin->scaleBarSize->SetValue(asWxString(val));
  mainwin->OnScaleBarSize(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read scaleBarSize") ;

  try{val=fsxml->getParam(string("scaleTextSize"), sp);
  mainwin->scaleTextSize->SetValue(asWxString(val));
  mainwin->OnScaleTextSize(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read scaleTextSize") ;

  try{val=fsxml->getParam(string("scaleFormat"), sp);
  mainwin->scaleFormat->SetValue(asWxString(val));
  mainwin->OnScaleFormat(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read scaleFormat") ;

  try{val=fsxml->getParam(string("scaleMax"), sp);
  mainwin->scaleMax->SetValue(asWxString(val));
  mainwin->OnScaleMax(event);
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read scaleMax") ;

  try{val=fsxml->getParam(string("sepcontscale"), sp);
  mainwin->checkSepContScale((bool)stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read sepcontscale") ;

  try{val=fsxml->getParam(string("contsize"), sp);
  inputdata->setContSize(stringToInt(val));
  mainwin->contSize->SetValue(asWxString(val));
  mainwin->getFineDisplay()->refreshGrid();
  //finedisplay->Refresh();finedisplay->Update();
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read contsize") ;

  try{val=fsxml->getParam(string("showContinentRows"), sp);
  mainwin->checkUseContinentRows(stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read showContinentRows") ;

  try{val=fsxml->getParam(string("showContinentCols"), sp);
  mainwin->checkUseContinentCols(stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read showContinentCols") ;

  try{val=fsxml->getParam(string("showClassification"), sp);
  mainwin->checkUseClassifyLabels(stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read showClassification") ;

  try{val=fsxml->getParam(string("classificationSize"), sp);
  mainwin->classificationSize->SetValue(asWxString(val));
  mainwin->getFineDisplay()->setClassificationSize(stringToInt(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read classificationSize") ;

  vector<vector<double> > scalecol;
  vector<double> scaletimes;
  try{
    val=fsxml->getParam(string("scalecolours"), sp);
    wxString myval(val.c_str(), wxConvUTF8);
    scalecol = mainwin->getFineDisplay()->wxStringAsColourVector(myval);
    
    val=fsxml->getParam(string("scaletimes"), sp);  
    myval=wxString(val.c_str(), wxConvUTF8);    
    scaletimes = mainwin->getFineDisplay()->wxStringAsColourTimes(myval);
    
    if(scaletimes.size()==scalecol.size()) {
      mainwin->getFineDisplay()->setColours(scalecol,scaletimes);
    }
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Read scalecolours") ;  
  mainwin->getFineDisplay()->Refresh();
  DEBUGPRINT("DEBUG: Refreshed") ;

}

void SettingsIO::readValues(DataWindow *datawin,bool secondfile,wxProgressDialog *readProg,int pcur, int pmax)
{
  wxCommandEvent event;
  string val;
  if(status!=SETTINGS_READ || fsxml==NULL) return;
  wxString addition=wxT("");
  InputData *id=inputdata;
  if(secondfile){
    addition=wxT("2");
    id=inputdata2;
  }else   mainwin->unloadAllFiles();
  //fsxml->rewind();
  std::streampos sp = fsxml->gotoLineContaining(std::string((wxT("<values") + addition + wxT(">")).mb_str()));
  double numchange=20;

  if(readProg!=NULL) readProg->Update(pcur+=(double)(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: Reading Single Line Values") ;
  sp=readValuesSingle(sp,id,datawin,readProg,pcur,pmax);

  if(secondfile) {
    try{val=fsxml->getParam(string("view2enabled"), sp);
      mainwin->checkView2Enable(stringToInt(val));
    }catch(string x){cout<<x<<endl;};
    if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
    DEBUGPRINT("DEBUG: Read view2enabled") ;

    try{val=fsxml->getParam(string("usesecondata"), sp);
      mainwin->checkView2AltData(stringToInt(val));
    }catch(string x){cout<<x<<endl;};
    if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
    DEBUGPRINT("DEBUG: Read usesecondata") ;

    try{val=fsxml->getParam(string("currentview"), sp);
      int curview=stringToInt(val);
      switch(curview){
	case FSGUI_SHOW_COPYMATRIX: mainwin->checkView2RawData(true); mainwin->getFineDisplay()->setHeatmap2AsCopy();break;
	case FSGUI_SHOW_PCMMATRIX: mainwin->checkView2PairwiseCoincidence(true); mainwin->getFineDisplay()->setHeatmap2AsPCM();break;
	case FSGUI_SHOW_COPYAGMATRIX: mainwin->checkView2AggregatedData(true); mainwin->getFineDisplay()->setHeatmap2AsAggCopy();break;
      }
      mainwin->getFineDisplay()->setSecondVis(stringToInt(val));
      mainwin->Refresh();
    }catch(string x){cout<<x<<endl;};
    if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
    DEBUGPRINT("DEBUG: Read currentview... Done") ;
    return;
  }else {
        try{val=fsxml->getParam(string("currentview"), sp);
      int curview=stringToInt(val);
      switch(curview){
	case FSGUI_SHOW_COPYMATRIX: mainwin->checkViewRawData(true); mainwin->getFineDisplay()->setHeatmapAsCopy();break;
	case FSGUI_SHOW_PCMMATRIX: mainwin->checkViewPairwiseCoincidence(true); mainwin->getFineDisplay()->setHeatmapAsPCM();break;
	case FSGUI_SHOW_COPYAGMATRIX: mainwin->checkViewAggregatedData(true); mainwin->getFineDisplay()->setHeatmapAsAggCopy();break;
	case FSGUI_SHOW_COPYAGMATRIXSIMPLE: mainwin->checkViewAggregatedDataSimple(true); mainwin->getFineDisplay()->setHeatmapAsAggCopySimple();break;
      }
      mainwin->getFineDisplay()->setDataVis(stringToInt(val));
      mainwin->Refresh();
    }catch(string x){cout<<x<<endl;};
    try{val=fsxml->getParam(string("currentview"), sp);
    }catch(string x){cout<<x<<endl;};
    DEBUGPRINT("DEBUG: Read currentview") ;

    if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  }

  readIndNames(sp);
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: readIndNames") ;

  readPopNames(sp);
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: readPopNames") ;

  readPopOrder(sp);
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: readPopOrder") ;

  readDisplayLabels(sp);
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: readDisplayLabels") ;

  readClassificationDetails(sp);
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: readClassificationDetails") ;

  readClassificationColours(sp);
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: readClassificationDetails.. Done") ;

}


std::streampos SettingsIO::readValuesSingle(std::streampos sp,InputData *id, DataWindow *datawin,wxProgressDialog *readProg,int pcur, int pmax)
{
  wxCommandEvent event;
  string val;
  double numchange=21;

  try{val=fsxml->getParam(string("copyfile"), sp);
  id->setCopyName(asWxString(val));
  if(datawin!=NULL) datawin->copyfile->SetLabel(wxT("Filename: ")+id->getCopyName());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read copyfile") ;

  try{val=fsxml->getParam(string("copydir"), sp);
  id->setCopyDir(asWxString(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read copydir") ;

  try{val=fsxml->getParam(string("copyskip"), sp);
  id->setCopySkip(asWxString(val));
  if(datawin!=NULL) datawin->copyskip->SetValue(id->getCopySkip());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read copyskip") ;

  try{val=fsxml->getParam(string("copyxhead"), sp);
  id->setCopyX(stringToInt(val));
  if(datawin!=NULL) datawin->copycbxX->SetValue(id->getCopyX());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read copyxhead") ;

  try{val=fsxml->getParam(string("copyyhead"), sp);
  id->setCopyY(stringToInt(val));
  if(datawin!=NULL) datawin->copycbxY->SetValue(id->getCopyY());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read copyyhead") ;

  try{val=fsxml->getParam(string("usefixed"), sp);
  id->setUseFixed((bool)stringToInt(val));
  if(datawin!=NULL) datawin->fixedcbx->SetValue(id->getUseFixed());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read usefixed") ;

  try{val=fsxml->getParam(string("fixedfile"), sp);
  id->setFixedName(asWxString(val));
  if(datawin!=NULL) datawin->fixedfile->SetLabel(wxT("Filename: ")+id->getFixedName());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read fixedfile") ;

  try{val=fsxml->getParam(string("fixeddir"), sp);
  id->setFixedDir(asWxString(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read fixeddir") ;

  try{val=fsxml->getParam(string("mcmcfile"), sp);
  id->setMcmcName(asWxString(val));
  if(datawin!=NULL) datawin->mcmcfile->SetLabel(wxT("Filename: ")+id->getMcmcName());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read mcmcfile") ;

  try{val=fsxml->getParam(string("mcmcdir"), sp);
  id->setMcmcDir(asWxString(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read mcmcdir") ;

  try{val=fsxml->getParam(string("mcmcburnin"), sp);
  id->setMcmcBurnin(asWxString(val));
  if(datawin!=NULL) datawin->mcmcburnin->SetValue(id->getMcmcBurnin());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read mcmcburnin") ;

  try{val=fsxml->getParam(string("mcmcrunlength"), sp);
  id->setMcmcRuntime(asWxString(val));
  if(datawin!=NULL) datawin->mcmcruntime->SetValue(id->getMcmcRuntime());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read mcmcrunlength") ;

  try{val=fsxml->getParam(string("mcmcskip"), sp);
  id->setMcmcSkip(asWxString(val));
  if(datawin!=NULL) datawin->mcmcskip->SetValue(id->getMcmcSkip());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read mcmcskip") ;

  try{val=fsxml->getParam(string("treefile"), sp);
  id->setTreeName(asWxString(val));
  if(datawin!=NULL) datawin->treefile->SetLabel(wxT("Filename: ")+id->getTreeName());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read treefile") ;

  try{val=fsxml->getParam(string("treedir"), sp);
  id->setTreeDir(asWxString(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read treedir") ;

  try{val=fsxml->getParam(string("treehillclimbsteps"), sp);
  id->setTreeHillClimbSteps(asWxString(val));
  if(datawin!=NULL) datawin->treearg_numits->SetValue(id->getTreeHillClimbSteps());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read treehillclimbsteps") ;

  try{val=fsxml->getParam(string("treetestmax"), sp);
  id->setTreeTestMax(asWxString(val));
  if(datawin!=NULL) datawin->treearg_maxtry->SetValue(id->getTreeTestMax());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read treetestmax") ;

  try{val=fsxml->getParam(string("treetype"), sp);
  id->setTreeType(stringToInt(val));
  if(datawin!=NULL) datawin->setTreeType(id->getTreeType());
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read treetype") ;

  try{val=fsxml->getParam(string("usingcopymat"), sp);
  if(stringToInt(val)==1){
    id->readCopyFile();
    mainwin->enableViewRawData();
  }
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read usingcopymat") ;

  try{val=fsxml->getParam(string("usingcopymat"), sp);
  if(stringToInt(val)==1){
    id->readCopyFile();
    mainwin->enableViewRawData();
  }
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read usingcopymat") ;

  try{val=fsxml->getParam(string("usingpcm"), sp);
  if(stringToInt(val)==1){
    if(id->readPairwiseCoincidence()){
      mainwin->enableViewPairwiseCoincidence();
    }
  }
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read usingpcm") ;

 try{val=fsxml->getParam(string("popsizescale"), sp);
  mainwin->applyPopSizeScale(stringToDouble(val));
  }catch(string x){cout<<x<<endl;};
  if(readProg!=NULL) readProg->Update(pcur+=(pmax-pcur)/numchange);
  DEBUGPRINT("DEBUG: read popsizescale") ;
  
  try{val=fsxml->getParam(string("usingtree"), sp);
  if(stringToInt(val)==1){
    readtree=true;
    if(id->readTree()){
      mainwin->enableViewAggregatedData();
    }
  }
  
  }catch(string x){cout<<x<<endl;};
  DEBUGPRINT("DEBUG: read usingtree") ;

  return(sp);
}


void SettingsIO::writeValues(bool secondfile)
{
  if(status!=SETTINGS_WRITE || os==NULL) return;
  InputData *id=inputdata;
  wxString addition=wxT("");
  if(secondfile) {
    id=inputdata2;
    addition=wxT("2");
  }
  writeTag(wxT("values")+addition,true);

  writeOneLineTag(wxT("copyfile"),id->getCopyName());
  writeOneLineTag(wxT("copydir"),id->getCopyDir());
  writeOneLineTag(wxT("copyskip"),id->getCopySkip());
  writeOneLineTag(wxT("copyxhead"),asWxString(id->getCopyX()));
  writeOneLineTag(wxT("copyyhead"),asWxString(id->getCopyY()));
  writeOneLineTag(wxT("usefixed"),asWxString(id->getUseFixed()));
  writeOneLineTag(wxT("fixedfile"),id->getFixedName());
  writeOneLineTag(wxT("fixeddir"),id->getFixedDir());

  writeOneLineTag(wxT("mcmcfile"),id->getMcmcName());
  writeOneLineTag(wxT("mcmcdir"),id->getMcmcDir());
  writeOneLineTag(wxT("mcmcburnin"),id->getMcmcBurnin());
  writeOneLineTag(wxT("mcmcrunlength"),id->getMcmcRuntime());
  writeOneLineTag(wxT("mcmcskip"),id->getMcmcSkip());

  writeOneLineTag(wxT("treefile"),id->getTreeName());
  writeOneLineTag(wxT("treedir"),id->getTreeDir());
  writeOneLineTag(wxT("treehillclimbsteps"),id->getTreeHillClimbSteps());
  writeOneLineTag(wxT("treetestmax"),id->getTreeTestMax());
  writeOneLineTag(wxT("treetype"),asWxString(id->getTreeType()));

  writeOneLineTag(wxT("usingcopymat"),asWxString(id->hasData()));
  writeOneLineTag(wxT("usingpcm"),asWxString(id->hasPCM()));
  writeOneLineTag(wxT("usingtree"),asWxString(id->hasTree()));
  writeOneLineTag(wxT("popsizescale"),asWxString(mainwin->getPopSizeScale()));
  if(secondfile){
    writeOneLineTag(wxT("currentview"),asWxString(mainwin->getFineDisplay()->getSecondVis()));
    writeOneLineTag(wxT("view2enabled"),asWxString(mainwin->view2Enable->IsChecked()));
    writeOneLineTag(wxT("usesecondata"),asWxString(mainwin->getFineDisplay()->getData2()));
    writeTag(wxT("/values")+addition,true);
  }else{
    writeOneLineTag(wxT("currentview"),asWxString(mainwin->getFineDisplay()->getDataVis()));
    writeIndNames();
    if(inputdata->hasTree()) {
      writePopNames();
      writePopOrder();
      writeDisplayLabels();
    }
    writeClassificationDetails();
    writeClassificationColours();
    writeTag(string("/values"),true);
    if(inputdata->hasTree())inputdata->writeTree(os);
  }
}

void SettingsIO::writePopNames()
{
  wxString out;
  for(int c1=0;c1<inputdata->getNumPops()-1;c1++){
    out+=inputdata->getPopName(c1)+wxT(";");
  }
  out+=inputdata->getPopName(inputdata->getNumPops()-1);
   writeOneLineTag(wxT("popnames"),out);
}

void SettingsIO::writePopOrder()
{
  wxString out=wxT("");
  for(int c1=0;c1<inputdata->getNumPops()-1;c1++){
    out+=wxString::Format(wxT("%i"),inputdata->getPopOrder(c1))+wxT(";");
  DEBUGPRINT("DEBUG: poporder["<<c1<<"]="<<inputdata->getPopOrder(c1)) ;

  }
  if(inputdata->getNumPops()>0) {
      out+=wxString::Format(wxT("%i"),inputdata->getPopOrder(inputdata->getNumPops()-1));
      DEBUGPRINT("DEBUG: poporder["<<inputdata->getNumPops()-1<<"]="<<inputdata->getPopOrder(inputdata->getNumPops()-1)) ;
  }
   writeOneLineTag(wxT("poporder"),out);
}

void SettingsIO::writeIndNames()
{
  wxString out;
  for(int c1=0;c1<inputdata->getN()-1;c1++){
 //   cout<<"c1="<<c1<<flush;
 //  cout<<std::string(inputdata->getName(c1).mb_str())<<endl;
    out+=inputdata->getName(c1)+wxT(";");
  }
   out+=inputdata->getName(inputdata->getN()-1);
  writeOneLineTag(wxT("indnames"),out);
}

void SettingsIO::writeDisplayLabels()
{
  wxString out;
  for(int c1=0;c1<inputdata->getN()-1;c1++){
    out+=asWxString((int)inputdata->getDisplayLabel(c1))+wxT(";");
  }
  out+=asWxString((int)inputdata->getDisplayLabel(inputdata->getN()-1));
  writeOneLineTag(wxT("displaylabels"),out);
}

void SettingsIO::writeClassificationDetails()
{
  wxString out;
  for(int c1=0;c1<inputdata->getNumLabels()-1;c1++){
    out+=(inputdata->getLabelUnorderedWx(c1))+wxT(";");
  }
  out+=(inputdata->getLabelUnorderedWx(inputdata->getNumLabels()-1));
  writeOneLineTag(wxT("classificationlabels"),out);

  out.Clear();
  for(int c1=0;c1<inputdata->getN()-1;c1++){
    out+=asWxString((int)inputdata->getLabel(c1))+wxT(";");
  }
  out+=asWxString((int)inputdata->getLabel(inputdata->getN()-1));
  writeOneLineTag(wxT("classificationindex"),out);
}

void SettingsIO::writeClassificationColours()
{
  wxString out;
  wxColour tcol;
  vector <wxColour> tcolours=mainwin->getFineDisplay()->getLabelColUnordered();
  for(int c1=0;c1<(int)tcolours.size()-1;c1++){
    tcol=tcolours[c1];
    out+=tcol.GetAsString()+wxT(";");
  }
  if(tcolours.size()>0) {
    tcol=tcolours[tcolours.size()-1];
    out+=tcol.GetAsString();
  }
  writeOneLineTag(wxT("classificationcolours"),out);
}

bool SettingsIO::readPopNames(std::streampos &sp )
{
  wxString pname;
  int popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("popnames"), sp));
    while(val!=wxT("")){
      pname =val.BeforeFirst(';');
      if(popon>=inputdata->getNumPops()) {cout<<"name="<<pname.mb_str()<<endl; throw(std::string("Invalid population names read"));}
      inputdata->setPopName(popon,pname);
      popon++;
      val=val.AfterFirst(';');
    }
  }catch(string x){cout<<x<<endl;return(false);};
  return(true);
}

bool SettingsIO::readPopOrder(std::streampos &sp )
{
  wxString pname;
  vector<int> ret;
  long tmp;
  int popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("poporder"), sp));
    while(val!=wxT("")){
      pname =val.BeforeFirst(';');
      if(popon>=inputdata->getNumPops()) {cout<<"Value="<<pname.mb_str()<<endl; throw(std::string("Invalid population index read"));}
      //inputdata->setPopName(popon,pname);
      if(!pname.ToLong(&tmp)) return(false);
      ret.push_back(tmp);
      popon++;
      val=val.AfterFirst(';');
    }
    inputdata->setPopOrder(ret);
    //inputdata->reorderAll(ret);
  }catch(string x){cout<<x<<endl;return(false);};
  return(true);
}

bool SettingsIO::readIndNames(std::streampos &sp )
{
  wxString pname;
  int popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("indnames"), sp));
    while(val!=wxT("")){
      pname =val.BeforeFirst(';');
/*      wxString indnames=val.AfterFirst(':');
      vector<wxString> indnvec;
      while(val!=wxT("")){
	indnvec.push_back(indnames.BeforeFirst(','));
	indnames=indnames.AfterFirst(',');
      }*/

      if(popon>=inputdata->getN()) throw(std::string("Invalid name index read"));
      inputdata->setName(popon,pname);
      popon++;
      val=val.AfterFirst(';');
    }
  }catch(string x){cout<<x<<endl;return(false);};
  return(true);
}

bool SettingsIO::readDisplayLabels(std::streampos &sp )
{
  wxString pval;
  int popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("displaylabels"), sp));
    while(val!=wxT("")){
      pval =val.BeforeFirst(';');
      inputdata->setDisplayLabel(popon,wxAtoi(pval));
      popon++;
      val=val.AfterFirst(';');
    }
  }catch(string x){cout<<x<<endl;return(false);};
  return(true);
}

bool SettingsIO::readClassificationDetails(std::streampos &sp )
{
  vector<wxString> vals;
  vector<int> tindex;

  wxString pval;
  int popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("classificationlabels"), sp));
    while(val!=wxT("")){
      pval =val.BeforeFirst(';');
      vals.push_back(pval);
      popon++;
      val=val.AfterFirst(';');
    }
  }catch(string x){cout<<x<<endl;return(false);};

  pval.Clear();
  popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("classificationindex"), sp));
    while(val!=wxT("")){
      pval =val.BeforeFirst(';');
      tindex.push_back(wxAtoi(pval));
      popon++;
      val=val.AfterFirst(';');
    }
  }catch(string x){cout<<x<<endl;return(false);};

  inputdata->setAllLabels(vals,tindex);

  return(true);
}


bool SettingsIO::readClassificationColours(std::streampos &sp )
{
  vector<wxColour> colours;
  vector<int> tindex;

  wxString pval;
  int popon=0;
  try{wxString val=asWxString(fsxml->getParam(string("classificationcolours"), sp));
    while(val!=wxT("")){
      pval =val.BeforeFirst(';');
      DEBUGPRINT("DEBUG:"<<pval.mb_str(wxConvUTF8));
      colours.push_back(wxColour(pval));
      //colours.push_back(wxColour(0,0,0));
      popon++;
      val=val.AfterFirst(';');
    }
  }catch(string x){cout<<x<<endl;return(false);};

  if(inputdata->getorder()!=NULL) mainwin->getFineDisplay()->setLabelCol(inputdata->getorder(),colours);
  return(true);
}
