#ifndef SETTINGSIO_H
#define SETTINGSIO_H

#include <wx/string.h>
#include <wx/wx.h>
#include <wx/filename.h>

#include <vector>
#include <string>
#include <iostream>
#include <cstring>
#include <fstream>

#include "inputdata.h"
#include "wholedisplay.h"
#include "mainwin.h"
#include "datawin.h"
#include "../fsxml.h"

#define SETTINGS_WRITE 1
#define SETTINGS_CLEAR 0
#define SETTINGS_READ 2
using namespace std;
using namespace fines;

class SettingsIO
{

  public:
    SettingsIO(FineMainWindow *mainwin);
    inline void setFileName(wxFileName val){
      filename=val;
    };
    inline std::string getFileNameString(){
      wxString tval=filename.GetFullPath();
      std::string stlstring = std::string(tval.mb_str());
      return(stlstring);
    };
    inline wxString getFileNameOnlyString(){
      return(filename.GetFullName());
    };    
    inline wxString getFileDir(){
      return(filename.GetPath());
    };  
    inline wxFileName getFileName(){
      return(filename);
    };
    inline void setFileName(wxString dir,wxString fn){
      filename=wxFileName(dir,fn);
    };
    inline bool readTree(){
      if(status!=SETTINGS_CLEAR) {
	//mainwin->getFineDisplay()->setLabelCol(inputdata->getorder(),classificationcolours);
	return(false);
      }
      bool res=inputdata->readTree(filename.GetFullPath());
      
      return(res);
    }
    inline bool openFileForReading(){
      try{
	if(fsxml!=NULL) delete(fsxml);
	fsxml=new FsXml(getFileNameString());
	std::streampos sp = fsxml->gotoLineContaining(string("<fsgui_settings>"));	
	if(sp<0) {delete(fsxml); fsxml=NULL;return(false);}
	status=SETTINGS_READ;
	}catch(...){
	    cerr<<"Error opening file!"<<endl<<endl; return(false);}
	return(true);
    };
    inline void closeFileForReading(){
      if(fsxml!=NULL) delete(fsxml);
      fsxml=NULL;
      status=SETTINGS_CLEAR;
    }
    inline bool reopenFileForReading(){
    //    cout<<"Restarting file"<<endl; 
      closeFileForReading();
      return(openFileForReading());
    }
    inline bool openFileForWriting(){
      if(status==SETTINGS_CLEAR){
	if(fb!=NULL) delete(fb);
	if(os!=NULL) delete(os);
	fb=new filebuf();
	try{
	fb->open (getFileNameString().c_str(),ios::out);
	status=SETTINGS_WRITE;
	}catch(std::string x){
	    cerr<<"Error opening file!"<<endl<<endl; return(false);}
	os=new ostream(fb);
	return(true);
      }
      return(false);
    };
    inline void closeFileForWriting(){
	if(fb!=NULL) {
	  fb->close();	  
	  delete(fb);
	}
	if(os!=NULL) delete(os);
	status=SETTINGS_CLEAR;
	os=NULL;
	fb=NULL;
    }
    void writeHeader();
    void writeFooter();
    void writeSettings();
    void writeValues(bool secondfile=false);
    void readSettings(wxProgressDialog *prog=NULL,int pcur=0, int pmax=100);
    void readValues(DataWindow *datawin=NULL,bool secondfile=false,wxProgressDialog *prog=NULL,int pcur=0, int pmax=100); 
    std::streampos readValuesSingle(std::streampos sp, InputData *id, DataWindow *datawin,wxProgressDialog *readProg,int pcur, int pmax);
    inline void writeOneLineTag(wxString tag, wxString val){
    writeTag(tag);
    *os<<val.mb_str();
    writeTag(wxT("/")+tag,true);
    }
    inline void writeTag(wxString tag,bool end=false){
      writeTag(std::string(tag.mb_str()),end);
    }
    inline void writeTag(string tag,bool end=false){
      *os<<"<";
      *os<<tag<<">";
      if(end) *os<<endl;
    }
    inline wxString asWxString(string s){
      wxString mystring(s.c_str(), wxConvUTF8);
      return(mystring);
    }
    inline wxString asWxString(double i){
      wxString mystring;
      mystring<<i;
      return(mystring);
    }    
    inline wxString asWxString(int i){
      wxString mystring;
      mystring<<i;
      return(mystring);
    }    
    inline int stringToInt(string s){
      return(wxAtoi(asWxString(s)));
    }
    inline double stringToDouble(string s){
      return(wxAtof(asWxString(s)));
    }
    void writePopNames();
    void writePopOrder();
    void writeTreePopOrder();
    void writeIndNames();
    void writeDisplayLabels();
    void writeClassificationDetails();
    void writeClassificationColours();
    bool readPopNames(std::streampos &sp );
    bool readPopOrder(std::streampos &sp );
    bool readIndNames(std::streampos &sp );
    bool readDisplayLabels(std::streampos &sp );
    bool readClassificationDetails(std::streampos &sp );
    bool readClassificationColours(std::streampos &sp );
    inline bool shouldReadTree(){return(readtree);};
  private:
    wxFileName filename;
    InputData *inputdata;
    InputData *inputdata2;
    FineMainWindow *mainwin;
    FsXml *fsxml;
    filebuf *fb;
    ostream *os;
    int status;
    bool readtree;
};

#endif
