#include "wholedisplay.h"

FineDisplay::FineDisplay(InputData *inputdata,InputData *inputdata2,wxScrolledWindow *parent, int id ):
  wxPanel((wxPanel *)parent, id, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER)
//FineDisplay::FineDisplay(InputData *inputdata,wxPanel *parent, int id ):
//  wxScrolledWindow(parent, id, wxDefaultPosition, wxDefaultSize, wxHSCROLL | wxVSCROLL)
{
  this->parent=parent;
  this->inputdata=inputdata;
  this->inputdata2=inputdata2;
  visgrid=new VisGrid(1,1,1);
  scale = new Scale(visgrid,this, wxID_ANY);
  heatmap = new Heatmap(inputdata,inputdata2,visgrid,this, wxID_ANY);
  scale->setHM(heatmap);
  labelX = new ShowLabels(inputdata,visgrid,false,this, wxID_ANY);//new wxStaticText(this, -1, wxT("X labels"));
  labelY = new ShowLabels(inputdata,visgrid,true,this, wxID_ANY);

  treeX = new ShowTree(inputdata,visgrid,false,this, wxID_ANY);
  treeY = new ShowTree(inputdata,visgrid,true,this, wxID_ANY);

  Connect(wxEVT_PAINT, wxPaintEventHandler(FineDisplay::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(FineDisplay::OnSize));

  SetBackgroundColour(wxColour(*wxWHITE));
  setSize(wxSize(1000,900));
  setTreeXVis(false);
  setTreeYVis(false);
  
  
  wxString treetooltip=wxT("Click internal nodes to swap their order.  Click population nodes to open the reorder window.");
  wxString labeltooltip=wxT("When displaying population labels, click a label to hide/show it.");
  treeX->SetToolTip(treetooltip);
  treeY->SetToolTip(treetooltip);
  labelX->SetToolTip(labeltooltip);
  labelY->SetToolTip(labeltooltip);
  
}

void FineDisplay::exportToFile(const wxString& filename)
{
  wxString filetype=filename.AfterLast(wxChar('.'));

  if(filetype.CmpNoCase(wxT("ps"))==0){
    exportToPostscript(filename);
    return;
  }
  refreshGrid();
  int height=0,width=0;
   if(treeX->IsShown()) width+=treeX->getSize();
  if(treeY->IsShown()) height+=treeY->getSize();
  if(labelX->IsShown()) width+=labelX->getSize();
  if(labelY->IsShown()) height+=labelY->getSize();
  if(heatmap->IsShown()) {
      width+=heatmap->getSize().x;
      height+=heatmap->getSize().y;
  }
  if(scale->IsShown()) width+=scale->getSize();

  wxSize csize(width,height);
  
  wxInitAllImageHandlers();
  wxMemoryDC  memory;
  cout<<filename.mb_str()<<":"<<filetype.mb_str()<<endl;
  wxBitmap bitmap = wxBitmap( csize.x,csize.y, -1 );
  memory.SelectObject( bitmap );
  memory.SetPen(wxPen(wxColour(255, 255,255)));
  memory.SetBrush(wxBrush(wxColour(255, 255,255)));
  memory.DrawRectangle(0,0,csize.x,csize.y);

  show(memory);
  
  memory.SelectObject( wxNullBitmap);
  if(filetype.CmpNoCase(wxT("png"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_PNG );
  else if(filetype.CmpNoCase(wxT("bmp"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_BMP );
  else if(filetype.CmpNoCase(wxT("jpg"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_JPEG );
  else if(filetype.CmpNoCase(wxT("jpeg"))==0) bitmap.SaveFile(filename, wxBITMAP_TYPE_JPEG );
  else bitmap.SaveFile(filename+wxT(".jpg"), wxBITMAP_TYPE_JPEG );


}

void FineDisplay::OnPaint(wxPaintEvent& event)
{
  wxPaintDC dc(this);
  show(dc);
}
void FineDisplay::show(wxDC&  dc){
  if(treeX->IsShown()) showItem(dc,(wxVirtualPanel*)treeX);
  if(treeY->IsShown()) showItem(dc,(wxVirtualPanel*)treeY);
  if(labelX->IsShown()) showItem(dc,(wxVirtualPanel*)labelX);
  if(labelY->IsShown()) showItem(dc,(wxVirtualPanel*)labelY);
  if(heatmap->IsShown()) showItem(dc,(wxVirtualPanel*)heatmap);
  if(scale->IsShown()) showItem(dc,(wxVirtualPanel*)scale);
  
}
  

void FineDisplay::exportToPostscript(const wxString& filename)
{

  /*wxPrintData printdata;
  printdata.SetFilename(filename);
  printdata.SetPrintMode(wxPRINT_MODE_FILE);
  //printdata.SetFontMetricPath(wxT("/home/local/UOB/madjl/code/trunk/finestructure/gui/gs_afm/"));
  //printdata.SetAFMPath(wxT("/home/local/UOB/madjl/code/trunk/finestructure/gui/gs_afm/"));
//  wxPostScriptDC memory(printdata);

//  memory.SetResolution(100);

//  memory.StartDoc(wxT("printing..."));
       // Tell it where to find the AFM files

//  cout<<filename.mb_str()<<":Postscript"<<endl;
    // Tell it where to find the AFM files
//  memory.GetPrintData().SetFontMetricPath(wxGetApp().GetFontPath());

    // Set the resolution in points per inch (the default is 720)

  wxSize csize =GetVirtualSize();
  memory.SetPen(wxPen(wxColour(255, 255,255)));
  memory.SetBrush(wxBrush(wxColour(255, 255,255)));
  memory.DrawRectangle(0,0,csize.x,csize.y);

  showItem(memory,(wxVirtualPanel*)treeX);
  showItem(memory,(wxVirtualPanel*)treeY);
  showItem(memory,(wxVirtualPanel*)labelX);
  showItem(memory,(wxVirtualPanel*)labelY);
  showItem(memory,(wxVirtualPanel*)heatmap);
  showItem(memory,(wxVirtualPanel*)scale);
       memory.EndDoc();
*/
}


void FineDisplay::showItem(wxDC&  dc,wxVirtualPanel *pan, int bufleft,int bufright,int buftop,int bufbottom)
{
  wxBitmap bitmap = wxBitmap( pan->GetSize().x,pan->GetSize().y,-1);
//  bitmap.DestroyClippingRegion();
  wxMemoryDC  memory(bitmap);
//  memory.SelectObject(bitmap);
  pan->show(memory);
  dc.Blit( pan->GetPosition().x - bufleft,pan->GetPosition().y -bufbottom, pan->GetSize().x,pan->GetSize().y, &memory, 0,0);
}

void FineDisplay::fit(bool refresh){

  wxPoint tmp(0,0), ptreex=tmp,ptreey=tmp,plabx=tmp,plaby=tmp,phm=tmp,pscale=tmp;
  treeX->setSize(treeX->getSize());
  treeY->setSize(treeY->getSize());
  ptreex.x=0;
  ptreey.y=0;
  if(treeX->IsShown()) plabx.x=treeX->getSize();//treeX->GetSize().x;
  else plabx.x=0;
  if(treeY->IsShown()) plaby.y=treeY->getSize();//treeY->GetSize().y;
  else plaby.y=0;
  if(labelX->IsShown()) phm.x=plabx.x+labelX->getSize();//labelX->GetSize().x;
  else phm.x=plabx.x;
  if(labelY->IsShown()) phm.y=plaby.y+labelY->getSize(); //labelY->GetSize().y;
  else phm.y=plaby.y;
  plabx.y=phm.y;
  plaby.x=phm.x;
  ptreex.y=phm.y;
  ptreey.x=phm.x;

  pscale.y=phm.y;
  if(scale->IsShown()) pscale.x=getSize().x-scale->getSize();
  else pscale.x=getSize().x;

  heatmap->setSize(wxSize(pscale.x-phm.x,getSize().y-phm.y));
  refreshGrid();  
  
  scale->setSize(wxSize(scale->getSize(),getSize().y-phm.y));
  scale->SetPosition(pscale);
  
  heatmap->SetPosition(phm);

  if(labelX->IsShown()) labelX->SetPosition(plabx);
  if(labelY->IsShown()) labelY->SetPosition(plaby);
  
 
  treeX->SetPosition(ptreex);
  treeY->SetPosition(ptreey);
  treeY->SetSize(wxSize(pscale.x-ptreey.x,treeY->getSize()));
  if(labelY->IsShown()) labelY->SetSize(wxSize(pscale.x-plaby.x,labelY->getSize()));
  if(labelX->IsShown()) labelX->SetSize(wxSize(labelX->getSize(),getSize().y-phm.y));
  if(treeY->IsShown()) treeY->SetSize(wxSize(pscale.x-plaby.x,treeY->getSize()));
  if(treeX->IsShown()) treeX->SetSize(wxSize(treeX->getSize(),getSize().y-phm.y));

  if(refresh){
    Update();
    Refresh();
  }
  
}

void FineDisplay::OnSize(wxSizeEvent& event)
{
  fit(true);
}