#ifndef FINEDISPLAY_H
#define FINEDISPLAY_H

#include <wx/wx.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/dc.h>
#include <wx/dcps.h>
#include <wx/cmndata.h>

#include <vector>

#include "heatmap.h"
#include "showtree.h"
#include "showlabels.h"
#include "inputdata.h"
#include "visgrid.h"
#include "scale.h"

using namespace std;


class FineDisplay : public wxPanel
{
  public:
  FineDisplay(InputData *inputdata,InputData *inputdata2,wxScrolledWindow *parent, int id );

  void exportToFile(const wxString& filename);
  void exportToPostscript(const wxString& filename);
  inline void refreshGrid(){
    int tcontsize=1;
    if(inputdata->hasTree()) tcontsize = inputdata->getContSize();
    if(visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE) inputdata->ensureCorrectScaleTree(true,visgrid->getPopScale());
    else  inputdata->ensureCorrectScaleTree(false,1.0);
    if(visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE){
      visgrid->setGrid(inputdata->getN(visgrid->getDatavis()),inputdata->getPopSizes(visgrid->getPopScale()), heatmap->getSize().x, heatmap->getSize().y,
		      inputdata->getNumSuper(), tcontsize);      
    }else{
      visgrid->setGrid(inputdata->getN(visgrid->getDatavis()), heatmap->getSize().x, heatmap->getSize().y,
		      inputdata->getNumSuper(), tcontsize);
    }
    labelX->setGrid();
    labelY->setGrid();
    //Refresh();
  }
  inline wxSize getSize(){
    return(size);
  }
  inline void setSize(wxSize newsize){
    size=newsize;
    SetMinSize(newsize);    
  }
  inline int getDataVis(){
    return(visgrid->getDatavis());
  }
  inline void setDataVis(int val){
    visgrid->setDatavis(val);
  }
  inline void setTreeXVis(bool val){
    if(val) treeX->Show();
    else  treeX->Hide();
  }
  inline void setTreeYVis(bool val){
    if(val) treeY->Show();
    else  treeY->Hide();
  }
  inline void setLabXVis(bool val){
    if(val) labelX->Show();
    else  labelX->Hide();
  }
  inline void setLabYVis(bool val){
    if(val) labelY->Show();
    else  labelY->Hide();
  }
  inline void setXtreeSize(int val){
    treeX->setSize(val);
    fit();
  }
  inline void setYtreeSize(int val){
    treeY->setSize(val);
    fit();
  }
  inline void setShowScale(bool val){
    if(val) scale->Show();
    else  scale->Hide();
  }
  inline wxString getXtreeSizeWx(){
    wxString mystring;
    mystring << treeX->getSize();
    return(mystring);
  }
  inline wxString getYtreeSizeWx(){
    wxString mystring;
    mystring << treeY->getSize();
    return(mystring);
  }
  inline wxString getXlabelSizeWx(){
    wxString mystring;
    mystring << labelX->getSize();
    return(mystring);
  }
  inline wxString getYlabelSizeWx(){
    wxString mystring;
    mystring << labelY->getSize();
    return(mystring);
  }
  inline int getXtreeSize(){
    return(treeX->getSize());
  }
  inline int getYtreeSize(){
    return(treeY->getSize());
  }
  inline void setXlabelSize(int val){
    labelX->setSize(val);
    fit();
  }
  inline void setYlabelSize(int val){
    labelY->setSize(val);
    fit();
  }
  inline int getXlabelSize(){
    return(labelX->getSize());
  }
  inline int getYlabelSize(){
    return(labelY->getSize());
  }
  inline wxString getTreeWidthWx(){
    wxString ret;
    ret<<visgrid->getTreeWidth();
    return(ret);
  }
  inline int getTreeWidth(){
    return(visgrid->getTreeWidth());
  }
  inline void setTreeWidth(int val){
    visgrid->setTreeWidth(val);
  }
  inline void setFontSize(double val){
    visgrid->setFontSize(val);
  }
  inline double getFontSize(){
     return(visgrid->getFontSize());
  }
  inline wxString getFontSizeWx(){
    wxString ret;
    ret<<visgrid->getFontSize();
    return(ret);
  }
  inline void setUsePopLabels(bool val){
    visgrid->setUsePopLabels(val);
  }
  inline bool getUsePopLabels(){
    return(visgrid->getUsePopLabels());
  }
  inline void setPerpPopLabels(bool val){
    visgrid->setPerpPopLabels(val);
  }
  inline bool getPerpPopLabels(){
    return(visgrid->getPerpPopLabels());
  }
  inline void setUseClassifyLabels(bool val){
    visgrid->setUseClassificationLabels(val);
  }
  inline bool getUseClassifyLabels(){
    return(visgrid->getUseClassificationLabels());
  }  
  inline void setClassificationSize(int val){
    visgrid->setLabelGap(val);
  }
  inline wxString getClassificationSizeWx(){
    wxString ret;
    ret<<visgrid->getLabelGap();
    return(ret);
  }
  inline wxString getScaleSizeWx(){
    wxString ret;
    ret<<scale->getSize();
    return(ret);
  }
  inline wxString getScaleBarSizeWx(){
    wxString ret;
    ret<<visgrid->getScaleBarSize();
    return(ret);
  }
  inline wxString getScaleTextSizeWx(){
    wxString ret;
    ret<<visgrid->getScaleTextSize();
    return(ret);
  }
  inline wxString getScaleFormat(){
    wxString ret;
    ret<<visgrid->getScaleFormat();
    return(ret);
  }
  inline wxString getScaleMinWx(){
    wxString ret;
    ret<<visgrid->getScaleMin();
    return(ret);
  }
  inline wxString getScaleMaxWx(){
    wxString ret;
    ret<<visgrid->getScale();
    return(ret);
  }
  inline double getScaleMin(){
    return(visgrid->getScaleMin());
  }
  inline double getScaleMax(){
    return(visgrid->getScale());
  }
  inline void setScaleSize(int val){
    scale->setSize(val);
  }
  inline void setScaleBarSize(int val){
    visgrid->setScaleBarSize(val);
  }
  inline void setScaleTextSize(int val){
    visgrid->setScaleTextSize(val);
  }
  inline void setScaleFormat(wxString val){
    visgrid->setScaleFormat(val);
  }
  inline void setScaleMin(double val){
    visgrid->setScaleMin(val);
  }
  inline void setScaleMax(double val){
    visgrid->setScale(val);
  }
  inline void setData2(bool val){
    visgrid->setData2(val);
  }
  inline bool getData2(){
    return(visgrid->getData2());
  }
  void fit(bool refresh=false);
  inline void setHeatmapAsPCM(){
    heatmap->showPCM();
  }
  inline void setHeatmapAsCopy(){
    heatmap->showCopy();
  }
  inline void setHeatmapAsAggCopy(){
    heatmap->showAggCopy();
  }
  inline void setHeatmapAsAggCopySimple(){
    heatmap->showAggCopySimple();
  }  
  inline void setHeatmap2AsHeatmap(){
    heatmap->showSingle();
  }
  inline void setHeatmap2AsPCM(){
    heatmap->show2PCM();
  }
  inline void setHeatmap2AsCopy(){
    heatmap->show2Copy();
  }
  inline void setHeatmap2AsAggCopy(){
    heatmap->show2AggCopy();
  }  
  inline int getSecondVis(){
    return(visgrid->getDatavis2());
  }
  inline void setSecondVis(int val){
    return(visgrid->setDatavis2(val));
  }
  inline vector<wxColour> getLabelColUnordered(){
    return(visgrid->getLabelColUnordered());
  }
/*  inline wxString getLabelColUnorderedWxString(int index){
    wxColour tmpc=getLabelColUnordered(index);
    return(tmpc.GetAsString());
  }  */
  inline void setLabelCol(vector<int> *neworder,vector<wxColour> tcols) {
     visgrid->setLabelCol(neworder,tcols);
  }  
  inline wxColour getLabelCol(int index){
    return(visgrid->getLabelCol(index));
  }
  inline void setUseContinentCols(bool val){
    visgrid->setUseContinentCols(val);
  }
  inline void setUseContinentRows(bool val){
    visgrid->setUseContinentRows(val);
  }
  inline bool getUseContinentCols(){
    return(visgrid->getUseContinentCols());
  }
  inline bool getUseContinentRows(){
    return(visgrid->getUseContinentRows());
  }
  
  inline double getPopSizeScale(){
    return(visgrid->getPopScale());
  }
  inline wxString getPopSizeScaleWx(){
    wxString ret;
    ret<<visgrid->getPopScale();
    return(ret);
  }
  inline void setPopSizeScale(double val){
    visgrid->setPopScale(val);
  }
  inline Heatmap *getHeatmap(){
    return(heatmap);
  }
  inline vector<vector<double> > getScaleColours(){
    return(heatmap->getScaleColours());
  }
  inline vector<double> getScaleTimes(){
    return(heatmap->getScaleTimes());
  }
  inline vector<vector<double> > wxStringAsColourVector(wxString myval){
    return(heatmap->wxStringAsColourVector(myval));
  }
  inline vector<double> wxStringAsColourTimes(wxString myval){
        return(heatmap->wxStringAsColourTimes(myval));
  }
  inline void setColours(vector<vector<double> > rgbptsin,vector< double > speed){
    heatmap->setColours(rgbptsin,speed);
  }
  void OnPaint(wxPaintEvent& event);  
  void OnSize(wxSizeEvent& event);  
  void show(wxDC&  dc);  
  void showItem(wxDC&  dc,wxVirtualPanel *pan, int bufleft=0,int bufright=0,int buftop=0,int bufbottom=0);
  protected:
  wxSize size;
  wxScrolledWindow *parent;

  wxBoxSizer *hbox;

  wxFlexGridSizer *fgs;

  ShowLabels *labelX;
  ShowLabels *labelY;

  ShowTree *treeX;
  ShowTree *treeY;
  Scale *scale;
  Heatmap *heatmap;
  InputData *inputdata;
  InputData *inputdata2;
  VisGrid *visgrid;
};

#endif

