
#include <wx/stdpaths.h>

#include "mainwin.h"

#include "datawin.h"
#include "settings_io.h"
#include "finegui.xpm"
#include "messageboxex/messageboxex.h"

DataWindow::DataWindow(SettingsIO *settings,InputData *inputdata,FineDisplay *fd,bool full,FineMainWindow *parent,wxPanel *parentaspanel, int id, const wxString& title)
       : wxFrame(parentaspanel, id, title, wxDefaultPosition, wxDefaultSize)
{
  this->settings=settings;
  this->inputdata=inputdata;
  this->parent=parent;
  this->fd=fd;
//  parent->Refresh();
//  Close();
  isfull=full;
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
  //SetIcon(wxIcon(wxT("web.xpm")));
  //SetSize(wxSize(640,480));
  //SetMinSize(wxSize(640,480));
   //SetMinSize(wxSize(640,480));
  //SetMinSize(GetEffectiveMinSize()); Fit();
  panel = new wxPanel(this, -1);
  fgs = new wxFlexGridSizer(10,1,10,10);
  fgs->AddGrowableCol(0);

// Main panel area
  metacbx = new wxCheckBox(panel, DATAWINDOW_ID_METACBX, wxT("Meta file:"));
  copycbx = new wxCheckBox(panel, DATAWINDOW_ID_COPYCBX, wxT("Raw data file:"));
  mcmccbx = new wxCheckBox(panel, DATAWINDOW_ID_MCMCCBX, wxT("MCMC output file:"));
  treecbx = new wxCheckBox(panel, DATAWINDOW_ID_TREECBX, wxT("Processed Tree file:"));
  metapanel = new wxPanel(panel, -1,wxDefaultPosition, wxSize(600,65), wxBORDER_SUNKEN);
  copypanel = new wxPanel(panel, -1,wxDefaultPosition, wxSize(600,135), wxBORDER_SUNKEN);
  mcmcpanel = new wxPanel(panel, -1,wxDefaultPosition, wxSize(600,100), wxBORDER_SUNKEN);
  treepanel = new wxPanel(panel, -1,wxDefaultPosition, wxSize(600,100), wxBORDER_SUNKEN);

  metapanel->SetMinSize(wxSize(600,65));
  copypanel->SetMinSize(wxSize(600,135));
  mcmcpanel->SetMinSize(wxSize(600,100));
  treepanel->SetMinSize(wxSize(600,135));

  metacbx->SetValue(true);
  copycbx->SetValue(true);
  mcmccbx->SetValue(true);
  treecbx->SetValue(true);
  //metapanel->Hide();
  //treepanel->Hide();

  // Meta panel
  metafgs = new wxFlexGridSizer(3,2,6,6);
  metaButton=new wxButton(metapanel, DATAWINDOW_ID_METABUTTON, wxT("Change file"));
  //metafile=new wxStaticText(metapanel, -1, wxT("Filename: ")+settings->getFileNameOnlyString());
  metafile=new wxTextCtrl(metapanel, DATAWINDOW_ID_METAFILETEXTBOX, wxT("Filename: ")+settings->getFileNameOnlyString(), wxDefaultPosition,wxSize(515,30));
  //metafile->SetStyle(0,10,wxTEXT_ATTR_FONT_ITALIC);
  
  metaLoadButton=new wxButton(metapanel, DATAWINDOW_ID_METALOADBUTTON, wxT("Read file"));
  metaWriteButton=new wxButton(metapanel, DATAWINDOW_ID_METAWRITEBUTTON, wxT("Write file"));

  metafgs->Add(metaButton);		metafgs->Add(metafile);
  metafgs->Add(metaLoadButton);		metafgs->Add(metaWriteButton);
  metapanel->SetSizerAndFit(metafgs);


  // Copy panel
  copyfgs = new wxFlexGridSizer(4,2,6,6);
  copyButton=new wxButton(copypanel, DATAWINDOW_ID_COPYBUTTON, wxT("Change data file"),wxDefaultPosition, wxSize(150,30));
  copyLoadButton=new wxButton(copypanel, DATAWINDOW_ID_COPYLOADBUTTON, wxT("Read data file"),wxDefaultPosition, wxSize(150,30));
  //copyfile=new wxStaticText(copypanel, -1, wxT("Filename: ")+inputdata->getCopyName());
  copyfile=new wxTextCtrl(copypanel, DATAWINDOW_ID_DATAFILETEXTBOX, wxT("Filename: ")+inputdata->getCopyName(), wxDefaultPosition,wxSize(300,30) );
  //copyfile->SetForegroundColour(wxColour (20, 20, 20));
  wxBoxSizer *copyskipsizer = new wxBoxSizer(wxHORIZONTAL);
  copyextrapanel= new wxPanel(copypanel, -1);
  copyskip=new wxTextCtrl(copyextrapanel, -1, wxT("0"),wxDefaultPosition, wxSize(60,20));

  copyskipsizer->Add(new wxStaticText(copyextrapanel, -1, wxT("Skip lines:")));
  copyskipsizer->Add(copyskip);

  copyskipsizer->Add(new wxStaticText(copyextrapanel, -1, wxT("Inflation 'c':")));
  mcmcconst=new wxTextCtrl(copyextrapanel, -1, inputdata->getMcmcConst(),wxDefaultPosition, wxSize(60,20));
  copyskipsizer->Add(mcmcconst);
  copyextrapanel->SetSizerAndFit(copyskipsizer);

  wxBoxSizer *copycbxsizer = new wxBoxSizer(wxHORIZONTAL);
  copycbxX= new wxCheckBox(copypanel,  -1, wxT("X labels present?"));
  copycbxY= new wxCheckBox(copypanel,  -1, wxT("Y labels present?"));
  copycbxX->SetValue(inputdata->getCopyX());
  copycbxY->SetValue(inputdata->getCopyY());
  copycbxsizer->Add(copycbxX);
  copycbxsizer->Add(copycbxY);
  copyHideExtras= new wxCheckBox(copypanel,  DATAWINDOW_ID_SHOWCOPYEXTRAS, wxT("Enable extra options?"));

  fixedcbx = new wxCheckBox(copypanel, DATAWINDOW_ID_FIXEDCBX, wxT("Use fixed:               "));
  fixedcbx->SetValue(inputdata->getUseFixed());
  fixedFileButton=new wxButton(copypanel, DATAWINDOW_ID_FIXEDCHOOSEBUTTON, wxT("Change fixed file"), wxDefaultPosition,wxSize(150,30));

  fixedfile=new wxTextCtrl(copypanel, DATAWINDOW_ID_FIXEDFILETEXTBOX, wxT("Filename: ")+inputdata->getFixedName(), wxDefaultPosition,wxSize(300,30));
  fixedFileButton->Enable(fixedcbx->IsChecked());
  fixedfile->Enable(fixedcbx->IsChecked());  
  //copyfile->SetForegroundColour(wxColour (20, 20, 20));
  //fixedfile=new wxStaticText(copypanel, -1, wxT("Filename: ")+inputdata->getFixedName());
  wxBoxSizer *fixedskipsizer = new wxBoxSizer(wxHORIZONTAL);
  fixedskipsizer->Add(fixedcbx);
  fixedskipsizer->Add(fixedFileButton);

  copyextrapanel->Disable();
  copycbxX->Disable();
  copycbxY->Disable();

  wxBoxSizer *fixedbuttonsizer = new wxBoxSizer(wxHORIZONTAL);
  fixedbuttonsizer->Add(copyButton);
  fixedbuttonsizer->Add(copyLoadButton);
  //  fixedCreateButton=new wxButton(fixedpanel, DATAWINDOW_ID_FIXEDCREATEBUTTON, wxT("Create file"));

  copyfgs->Add(fixedskipsizer);		copyfgs->Add(fixedfile);
  copyfgs->Add(fixedbuttonsizer);	copyfgs->Add(copyfile);
  copyfgs->Add(new wxStaticText(copypanel, -1, wxT("")));		copyfgs->Add(copyextrapanel);
  copyfgs->Add(copyHideExtras);		copyfgs->Add(copycbxsizer);
  copypanel->SetSizerAndFit(copyfgs);

  // MCMC panel

  mcmcfgs = new wxFlexGridSizer(3,2,6,6);
  mcmcFileButton=new wxButton(mcmcpanel, DATAWINDOW_ID_MCMCFILEBUTTON, wxT("Change file"));
  mcmcGenerateButton=new wxButton(mcmcpanel, DATAWINDOW_ID_MCMCGENERATEBUTTON, wxT("Generate sample"));
  //mcmcfile=new wxStaticText(mcmcpanel, -1, wxT("Filename: ")+inputdata->getMcmcName());
  mcmcfile=new wxTextCtrl(mcmcpanel, DATAWINDOW_ID_MCMCFILETEXTBOX, wxT("Filename: ")+inputdata->getMcmcName(), wxDefaultPosition,wxSize(330,30));

  wxBoxSizer *mcmcloadsizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *mcmcskipsizer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *mcmcgensizer = new wxBoxSizer(wxHORIZONTAL);
  mcmcReadPCM=new wxButton(mcmcpanel, DATAWINDOW_ID_MCMCREADPCMBUTTON, wxT("Read Pairwise Coincidence"));
  mcmcHelp=new wxButton(mcmcpanel, DATAWINDOW_ID_MCMCHELPBUTTON, wxT("Help on MCMC options"));

  mcmcburnin=new wxTextCtrl(mcmcpanel, -1, inputdata->getMcmcBurnin(),wxDefaultPosition, wxSize(100,20));
  mcmcruntime=new wxTextCtrl(mcmcpanel, -1,inputdata->getMcmcRuntime(),wxDefaultPosition, wxSize(100,20));
  mcmcskip=new wxTextCtrl(mcmcpanel, -1, inputdata->getMcmcSkip(),wxDefaultPosition, wxSize(60,20));
  mcmcloadsizer->Add(mcmcFileButton);
  mcmcloadsizer->Add(mcmcHelp);
  mcmcgensizer->Add(mcmcGenerateButton);
  mcmcgensizer->Add(new wxStaticText(mcmcpanel, -1, wxT("Burnin:")));
  mcmcgensizer->Add(mcmcburnin);
  mcmcskipsizer->Add(new wxStaticText(mcmcpanel, -1, wxT("Runtime:")));
  mcmcskipsizer->Add(mcmcruntime);
  mcmcskipsizer->Add(new wxStaticText(mcmcpanel, -1, wxT("Skip:")));
  mcmcskipsizer->Add(mcmcskip);

  mcmcfgs->Add(mcmcloadsizer);		mcmcfgs->Add(mcmcfile);
  mcmcfgs->Add(mcmcgensizer);		mcmcfgs->Add(mcmcskipsizer);
  mcmcfgs->Add(mcmcReadPCM);
  mcmcpanel->SetSizerAndFit(mcmcfgs);

  // Tree panel

  treefgs = new wxFlexGridSizer(3,2,6,6);
  treeFileButton=new wxButton(treepanel, DATAWINDOW_ID_TREEFILEBUTTON, wxT("Change file"));
  treeGenerateButton=new wxButton(treepanel, DATAWINDOW_ID_TREEGENERATEBUTTON, wxT("Generate tree"));
  //treefile=new wxStaticText(treepanel, -1, wxT("Filename: ")+inputdata->getTreeName());
  treefile=new wxTextCtrl(treepanel, DATAWINDOW_ID_TREEFILETEXTBOX, wxT("Filename: ")+inputdata->getTreeName(), wxDefaultPosition,wxSize(335,30));

  wxBoxSizer *treeskipsizer1 = new wxBoxSizer(wxHORIZONTAL);
  treearg_maxtry=new wxTextCtrl(treepanel, -1,inputdata->getTreeTestMax(),wxDefaultPosition, wxSize(100,20));
  treeskipsizer1->Add(new wxStaticText(treepanel, -1, wxT("Max states per merge:")));
  treeskipsizer1->Add(treearg_maxtry);
  wxBoxSizer *treeskipsizer2 = new wxBoxSizer(wxHORIZONTAL);
  treearg_numits=new wxTextCtrl(treepanel, -1, inputdata->getTreeHillClimbSteps(),wxDefaultPosition, wxSize(100,20));
  treeskipsizer2->Add(new wxStaticText(treepanel, -1, wxT("Hill climbing Iterations:")));
  treeskipsizer2->Add(treearg_numits);
  wxBoxSizer *treeskipsizer3 = new wxBoxSizer(wxHORIZONTAL);
  const wxString modechoices [3]= {wxT("Observed"),wxT("Merge Climb"),wxT("Full Hill Climb") };
  treeType=new wxComboBox((wxWindow*)treepanel, -1, modechoices[inputdata->getTreeType()-1],wxDefaultPosition,wxSize(130,20),3,
			    modechoices,wxCB_READONLY);

  treeskipsizer3->Add(treeGenerateButton);
  treeskipsizer3->Add(new wxStaticText(treepanel, -1, wxT("Type:")));
  treeskipsizer3->Add(treeType);
  treeReadButton=new wxButton(treepanel, DATAWINDOW_ID_TREEREADPCMBUTTON, wxT("Read Tree"));
  treeWriteButton=new wxButton(treepanel, DATAWINDOW_ID_TREEWRITEPCMBUTTON, wxT("Write Tree"));
  wxBoxSizer *treerwsizer= new wxBoxSizer(wxHORIZONTAL);
  treerwsizer->Add(treeReadButton);
  treerwsizer->Add(treeWriteButton);
  /*
wxWindow*, int,              wxString,  const wxPoint&,        wxSize, int, const wxString [3], int, wxString)
wxWindow*, wxWindowID, const wxString&, const wxPoint&, const wxSize&, int, const wxString*, long int, const wxValidator&, const wxString&)
wxWindow*, wxWindowID, const wxString&, const wxPoint&, const wxSize&, const wxArrayString&, long int, const wxValidator&, const wxString&)
*/
  treefgs->Add(treeFileButton);		treefgs->Add(treefile);
  treefgs->Add(treeskipsizer3);		treefgs->Add(treeskipsizer1);
  treefgs->Add(treerwsizer);		treefgs->Add(treeskipsizer2);
  treepanel->SetSizerAndFit(treefgs);

// Done and help
  wxPanel *donepanel = new wxPanel(panel, -1,wxDefaultPosition, wxSize(600,30), wxBORDER_SUNKEN);
  datawinstatus = new wxStaticText(donepanel, -1, wxT("Status: Nothing to report"));
  acceptButton = new wxButton(donepanel, DATAWINDOW_ID_ACCEPTBUTTON, wxT("Done"),wxDefaultPosition,wxSize(150,30));
  helpButton = new wxButton(donepanel, DATAWINDOW_ID_HELPBUTTON, wxT("Help"),wxDefaultPosition,wxSize(150,30));
  wxGridSizer * donespacer=new wxFlexGridSizer(1,3,6,6);
  donespacer->Add(acceptButton);
  donespacer->Add(helpButton);
  donespacer->Add(datawinstatus);
  donepanel->SetSizerAndFit(donespacer);
 // Add stuff to main panel

  fgs->Add(donepanel, 1, wxEXPAND);

  fgs->Add(metacbx);
  fgs->Add(metapanel, 1, wxEXPAND);
  fgs->Add(copycbx);
  fgs->Add(copypanel, 1, wxEXPAND);
  fgs->Add(mcmccbx);
  fgs->Add(mcmcpanel, 1, wxEXPAND);
  fgs->Add(treecbx);
  fgs->Add(treepanel, 1, wxEXPAND);

  //#if defined(__WXMSW__)
  wxPanel *tmppanel= new wxPanel(panel, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN);
  tmppanel->SetMinSize(wxSize(600,30));
  fgs->Add(tmppanel);
  //#endif
  metafgs->AddGrowableCol(1);
  copyfgs->AddGrowableCol(1);
  mcmcfgs->AddGrowableCol(1);
  treefgs->AddGrowableCol(1);

  //fgs->AddGrowableCol(0, 1);

  /*
  metafile = new wxTextCtrl(panel, -1, inputdata->getMetaName(), wxDefaultPosition, wxSize(200,20));
  copyfile = new wxTextCtrl(panel, -1, inputdata->getCopyName(),  wxDefaultPosition, wxSize(200,20));
//  reload();
  acceptButton = new wxButton(panel, wxID_EXIT, wxT("Accept and load"));
  cancelButton = new wxButton(panel, wxID_CANCEL, wxT("Cancel"));
  helpButton = new wxButton(panel, wxID_HELP, wxT("Help"));
  validateButton = new wxButton(panel, DATAWINDOW_ID_VALIDATE, wxT("Validate"));


  fgs->Add(new wxStaticText(panel, -1, wxT("Metafile:")));
  m_cb = new wxCheckBox(panel, ID_CHECKBOX, wxT("Show title"),
  fgs->Add(metafile, 1, wxEXPAND);
  fgs->Add(new wxStaticText(panel, -1, wxT("Copy count file:")));
  fgs->Add(copyfile, 1, wxEXPAND);

  fgs->Add(helpButton);
  fgs->Add(validateButton);
  fgs->Add(cancelButton);
  fgs->Add(acceptButton);
// add sizers to everything
  */

  panel->SetSizerAndFit(fgs);

  if(!isfull){
    metacbx->Enable(false);
    metapanel->Hide();
  }

  fit();
/// CONNECTING STUFF
// Main buttons
  Connect(DATAWINDOW_ID_HELPBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMainHelp));
  Connect(DATAWINDOW_ID_ACCEPTBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnQuit));
// Checkboxes
  Connect(DATAWINDOW_ID_METACBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(DataWindow::OnMetaCbx));
  Connect(DATAWINDOW_ID_COPYCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(DataWindow::OnCopyCbx));
  Connect(DATAWINDOW_ID_SHOWCOPYEXTRAS, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(DataWindow::OnCopyShowExtras));
  Connect(DATAWINDOW_ID_FIXEDCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(DataWindow::OnFixedCbx));
  Connect(DATAWINDOW_ID_MCMCCBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(DataWindow::OnMcmcCbx));
  Connect(DATAWINDOW_ID_TREECBX, wxEVT_COMMAND_CHECKBOX_CLICKED, wxCommandEventHandler(DataWindow::OnTreeCbx));
// Connect Meta data
  Connect(DATAWINDOW_ID_METALOADBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMetaLoad));
  Connect(DATAWINDOW_ID_METAWRITEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMetaWrite));
  Connect(DATAWINDOW_ID_METABUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMetaFile));
// Connect Copy data
  Connect(DATAWINDOW_ID_COPYLOADBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnCopyLoad));
  Connect(DATAWINDOW_ID_COPYBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnCopyFile));
// Connect Fixed continent
  //Connect(DATAWINDOW_ID_FIXEDLOADBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnFixedLoad));
  //Connect(DATAWINDOW_ID_FIXEDCREATEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnFixedCreate));
  Connect(DATAWINDOW_ID_FIXEDCHOOSEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnFixedFile));
// Connect mcmc stuff
  Connect(DATAWINDOW_ID_MCMCFILEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMcmcFile));
  Connect(DATAWINDOW_ID_MCMCGENERATEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMcmcGenerate));
  Connect(DATAWINDOW_ID_MCMCREADPCMBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMcmcRead));
  Connect(DATAWINDOW_ID_MCMCHELPBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnMcmcHelp));
// Connect tree stuff

  Connect(DATAWINDOW_ID_TREEFILEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnTreeFile));
  Connect(DATAWINDOW_ID_TREEGENERATEBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnTreeGenerate));
  Connect(DATAWINDOW_ID_TREEREADPCMBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnTreeRead));
  Connect(DATAWINDOW_ID_TREEWRITEPCMBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(DataWindow::OnTreeWrite));
  
  Connect(DATAWINDOW_ID_METAFILETEXTBOX, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(DataWindow::OnMetaEdit));
  Connect(DATAWINDOW_ID_FIXEDFILETEXTBOX, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(DataWindow::OnFixedEdit));
  Connect(DATAWINDOW_ID_DATAFILETEXTBOX, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(DataWindow::OnDataEdit));
  Connect(DATAWINDOW_ID_MCMCFILETEXTBOX, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(DataWindow::OnMcmcEdit));
  Connect(DATAWINDOW_ID_TREEFILETEXTBOX, wxEVT_COMMAND_TEXT_UPDATED, wxCommandEventHandler(DataWindow::OnTreeEdit));
  
  Centre();

  metacbx->SetToolTip(wxT("Hide/Show the fineSTRUCTURE internal file format options"));
  copycbx->SetToolTip(wxT("Hide/Show the input data file section"));
  mcmccbx->SetToolTip(wxT("Hide/Show the MCMC options for fineSTRUCTURE"));
  treecbx->SetToolTip(wxT("Hide/Show the Tree options for fineSTRUCTURE"));
  fixedcbx->SetToolTip(wxT("Use a fixed continent file?"));

  helpButton->SetToolTip(wxT("Help on all options"));
  acceptButton->SetToolTip(wxT("Dismiss this window (all useful settings are maintained)"));

  metaButton->SetToolTip(wxT("Choose the fineSTRUCTURE settings file to read or write"));
  metaLoadButton->SetToolTip(wxT("Load the chosen file (which must exist)"));
  metaWriteButton->SetToolTip(wxT("Save to the chosen file (which will be overwritten)"));
  metafile->SetToolTip(wxT("Currently chosen fineSTRUCTURE settings file"));

  copyButton->SetToolTip(wxT("Choose an input data file (but don't yet read it)"));
  copyLoadButton->SetToolTip(wxT("Read the copy file with the currently chosen settings"));
  copyfile->SetToolTip(wxT("Currently chosen input file"));
  copyskip->SetToolTip(wxT("Choose the number of lines in the input file to skip (not necessary if you used ChromoPainter to generate the files)"));
  copycbxX->SetToolTip(wxT("Does the input file have row names? (Not necessary if you used ChromoPainter to generate the files)"));
  copycbxY->SetToolTip(wxT("Does the input file have column names? (Not necessary if you used ChromoPainter to generate the files)"));
  copyHideExtras->SetToolTip(wxT("Enable extra options that are not necessary for normal usage"));

  fixedFileButton->SetToolTip(wxT("Change the fixed population (\"Continent\") file, (read only if \"Use fixed\" enabled)"));
  fixedfile->SetToolTip(wxT("Currently chosen fixed population file"));

  mcmcFileButton->SetToolTip(wxT("Change the MCMC file name (without reading or writing to it)"));
  mcmcGenerateButton->SetToolTip(wxT("Generate a new MCMC sample with the currently chosen parameters (overwrites the file and loads the results)"));
  mcmcfile->SetToolTip(wxT("Currently chosen MCMC file name"));
  mcmcburnin->SetToolTip(wxT("Set the MCMC burnin iterations"));
  mcmcruntime->SetToolTip(wxT("Set the MCMC number of iterations for sampling"));
  mcmcskip->SetToolTip(wxT("Set the number of iterations between samples being taken"));
  mcmcconst->SetToolTip(wxT("The value of \"c\" that has been read from the data.  You can set a new value to perform MCMC, but the default should be correct."));
  mcmcReadPCM->SetToolTip(wxT("Read the currently selected MCMC file"));
  mcmcHelp->SetToolTip(wxT("More help on MCMC options"));

  treeFileButton->SetToolTip(wxT("Change the Tree file name (without reading or writing to it)"));
  treeGenerateButton->SetToolTip(wxT("Generate a new Tree with the currently chosen parameters (overwrites the file and loads the results)"));
  treefile->SetToolTip(wxT("Currently chosen tree file name"));
  treearg_maxtry->SetToolTip(wxT("Maximum number of states to consider for each merge of the tree.  Set this to > N(N-1)/2 to get all possiblities"));
  treearg_numits->SetToolTip(wxT("Number of iterations for hill-climbing."));
  treeReadButton->SetToolTip(wxT("Read a tree from the currently selected file."));
  treeWriteButton->SetToolTip(wxT("Write the current tree to the selected file, overwriting it.  Do this after changing tree order."));
  treeType->SetToolTip(wxT("How to generate the tree.  Full hill climb does a greedy search for a best population, merge forces merges only (so guarentees consistency with the sample) and observed uses the best state in the sample."));

}

void DataWindow::OnMainHelp(wxCommandEvent & event){
  //cout<<inputdata->getN()<<endl;
  wxHelpBoxEx(wxT("For more detailed help, see the manual."),wxT("Input format help"),wxOK);
 
 // wxMessageBox(wxT("This is the helpfile for the data input window.  It has not yet been written.  Sadly, you re on your own."),wxT("Help"));
}

void DataWindow::OnMetaLoad(wxCommandEvent & event)
{
    try{
  if(settings->openFileForReading()){
    parent->setShowDisplay(false);

    wxProgressDialog readProg(wxT("Reading files"), wxT("Progress"),100,(wxWindow*) this,
		wxPD_APP_MODAL | wxPD_CAN_ABORT | wxPD_ELAPSED_TIME | wxPD_AUTO_HIDE);
      readProg.Update(0);

      readProg.Pulse();
cout<<"READING VALUES"<<endl;
      settings->readValues(this,false,&readProg,0,40);
      settings->readValues(this,true,&readProg,4,50);
      vector <int> tpoporder=inputdata->getPopOrder();
      if(settings->shouldReadTree()) {	
cout<<"READING TREE"<<endl;
//	inputdata->setPopOrder(vector <int>());
	settings->readTree();
      }
      settings->reopenFileForReading();
cout<<"READING SETTINGS"<<endl;
      settings->readSettings(&readProg,50,100);
      readProg.Update(100);
    settings->closeFileForReading();
      if(settings->shouldReadTree()) {// apply population order
 	inputdata->reorderAll(tpoporder);
	inputdata->setPopOrderFromTree();
      }
      datawinstatus->SetLabel(wxT("Status: Metafile read success"));
    parent->setShowDisplay(true);
  }else datawinstatus->SetLabel(wxT("Status: Metafile read failure"));
    }catch(string x){
        datawinstatus->SetLabel(wxT("Status: Metafile read failure (caught)"));
    }
//  settings->readValues(this);
//  settings->readSettings();
  Refresh();
}

void DataWindow::OnMetaFile(wxCommandEvent & event)
{
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select metadata file"),settings->getFileDir(),settings->getFileNameOnlyString(),wxT("*.*"),wxFD_SAVE);  
  if (openFileDialog->ShowModal() == wxID_OK){
    settings->setFileName(openFileDialog->GetDirectory(),openFileDialog->GetFilename());
      metafile->SetValue( wxT("Filename: ")+settings->getFileNameOnlyString());
  }
}

void DataWindow::OnMetaWrite(wxCommandEvent & event)
{
  if(settings->openFileForWriting()){
    settings->writeHeader();
    settings->writeValues();
    settings->writeValues(true);
    settings->writeSettings();
    settings->writeFooter();
    settings->closeFileForWriting();
    datawinstatus->SetLabel(wxT("Status: Metafile write success"));
  }else datawinstatus->SetLabel(wxT("Status: Metafile write failure"));
}

void DataWindow::OnCopyShowExtras(wxCommandEvent & event){
  bool val=copyHideExtras->GetValue();
  copyextrapanel->Enable(val);
  copycbxX->Enable(val);
  copycbxY->Enable(val);
}

void DataWindow::OnCopyFile(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select copy count data file"),inputdata->getCopyDir(),inputdata->getCopyName(),wxT("*.*"),wxFD_OPEN|wxFD_FILE_MUST_EXIST);
  if (openFileDialog->ShowModal() == wxID_OK){
      inputdata->setCopyDir(openFileDialog->GetDirectory());
      inputdata->setCopyName(openFileDialog->GetFilename());
      copyfile->SetValue( wxT("Filename: ")+inputdata->getCopyName());
  }
}

void DataWindow::OnCopyLoad(wxCommandEvent & event){
  inputdata->setCopyX(copycbxX->GetValue());
  inputdata->setCopyY(copycbxY->GetValue());
  inputdata->setCopySkip(copyskip->GetValue());
  if(inputdata->readCopyFile()){
    datawinstatus->SetLabel(wxT("Status: Datafile read success"));
    if(inputdata->getDataC()>0) {
		mcmcconst->SetValue(wxString::Format(wxT("%f"), inputdata->getDataC()));
	}else{
		wxMessageBox(wxT("The datafile you have loaded does not contain an estimate of 'C'. If you have used ChromoPainter to to create this file, you should use 'ChromoCombine' to estimate 'C'.  This is necessary for fineSTRUCTURE to correctly compute the variance expected in the data. If you cannot use ChromoCombine, you can manually set 'C': the theoretical value if the data are strongly linked is 1, and if the data are completely unlinked it is 1/(N-1).  You should understand the implications of it being set incorrectly.\n See www.paintmychromosomes.com -> 'ChromoCombine' for details."),wxT("WARNING: 'C' not found")); 
	}
    if(isfull){
      fd->setHeatmapAsCopy();
      fd->refreshGrid();
      parent->checkXlabels(true);
      parent->checkYlabels(true);
      parent->enableViewRawData();
      parent->checkViewRawData();
    }
  }else datawinstatus->SetLabel(wxT("Status: Datafile read failure"));
  parent->Refresh();
}

void DataWindow::OnFixedFile(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select copy count data file"),inputdata->getFixedDir(),inputdata->getFixedName(),wxT("*.*"),wxFD_OPEN|wxFD_FILE_MUST_EXIST);  
  if (openFileDialog->ShowModal() == wxID_OK){
      inputdata->setFixedDir(openFileDialog->GetDirectory());
      inputdata->setFixedName(openFileDialog->GetFilename());
      fixedfile->SetValue( wxT("Filename: ")+inputdata->getFixedName());
      fixedcbx->SetValue(true);
      inputdata->setUseFixed(true);
  }
}

/*void DataWindow::OnFixedCreate(wxCommandEvent & event){
  wxMessageBox(wxT("The create fixed partitions function is not yet functional.  Create a text file and read it instead."),wxT("Fixed Continents creation"));
}*/

void DataWindow::OnMcmcFile(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select mcmc data file"),inputdata->getMcmcDir(),inputdata->getMcmcName(),wxT("*.*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
      inputdata->setMcmcDir(openFileDialog->GetDirectory());
      inputdata->setMcmcName(openFileDialog->GetFilename());
      mcmcfile->SetValue( wxT("Filename: ")+inputdata->getMcmcName());
  }
}

void DataWindow::OnMcmcGenerate(wxCommandEvent & event){
  inputdata->setMcmcBurnin(mcmcburnin->GetValue());
  inputdata->setMcmcRuntime(mcmcruntime->GetValue());
  inputdata->setMcmcSkip(mcmcskip->GetValue());
  inputdata->setMcmcConst(mcmcconst->GetValue());
  if(inputdata->runMCMC((wxPanel*)this)){
    if(inputdata->readPairwiseCoincidence()){
      if(isfull){
	fd->setHeatmapAsPCM();
	parent->enableViewPairwiseCoincidence();
	parent->checkViewPairwiseCoincidence();
	parent->Refresh();
      }
      datawinstatus->SetLabel(wxT("Status: MCMC generation and read success"));
    }else datawinstatus->SetLabel(wxT("Status: MCMC read failure"));
  }else datawinstatus->SetLabel(wxT("Status: MCMC generation failure"));
}

void DataWindow::OnMcmcRead(wxCommandEvent & event){
  if(inputdata->readPairwiseCoincidence()){
    mcmcconst->SetValue(inputdata->getMcmcConst());
    mcmcskip->SetValue(inputdata->getMcmcSkip());
    mcmcruntime->SetValue(inputdata->getMcmcRuntime());
    mcmcburnin->SetValue(inputdata->getMcmcBurnin());
    if(isfull){
      fd->setHeatmapAsPCM();
      parent->enableViewPairwiseCoincidence();
      parent->checkViewPairwiseCoincidence();
      parent->Refresh();
    }
    datawinstatus->SetLabel(wxT("Status: MCMC read success"));
  }else datawinstatus->SetLabel(wxT("Status: MCMC read failure"));
}

void DataWindow::OnMcmcHelp(wxCommandEvent & event){
  wxMessageBox(wxT("\
  General help:\n\n\
  1) If you have already generated an MCMC file, e.g. using the fineSTRUCTURE command line, then 'Change File' to this file and press 'Read Pairwise Coincidence'.  This is all you need to do.  For more help on how to use the fineSTRUCTURE command line, see the manual.\n\n\
  2) If you want to generate an MCMC sample, think about your data. How many individuals do you have?  If it is more than a few hundred, you will need to run fineSTRUCTURE for a long time (days).\n\
  \t a) You should not have to worry about \"c\" factors if you used ChromoCombine to generate your data.  You can however change this in the data section if you want to e.g. explore how it affects inference.\n\
  \t b) For small easy datasets (100 individuals or less), you should set burnin and runtime to around 100000; 10x longer if the populations are not well defined.  Larger datasets (e.g. 1000 individuals) have been successfully mixed in 10,000,000 iterations (each for burnin and runtime).  You probably want S=1000 MCMC samples for a publication and S=100 for exploration; set the skip so that S='runtime/skip'.\n\
  \t c) When you are done, press 'Generate Sample'.  If you aren't sure if the MCMC has mixed, you should generate a second dataset with identical parameters (Main Window->File->Second Dataset), and display it on the second diagonal (Main Window->Second View->Enable Alternative Diaglonal View, and then Main Window->Second View->Use Second Dataset).\n\
  "),wxT("MCMC format help"));
}

void DataWindow::OnTreeFile(wxCommandEvent & event){
  wxFileDialog * openFileDialog = new wxFileDialog(this,wxT("Select tree data file"),inputdata->getTreeDir(),inputdata->getTreeName(),wxT("*.*"),wxFD_SAVE);
  if (openFileDialog->ShowModal() == wxID_OK){
      inputdata->setTreeDir(openFileDialog->GetDirectory());
      inputdata->setTreeName(openFileDialog->GetFilename());
      treefile->SetValue( wxT("Filename: ")+inputdata->getTreeName());
  }
}

void DataWindow::OnTreeGenerate(wxCommandEvent & event){
  if(!checkDataFile()) {
    datawinstatus->SetLabel(wxT("Status: Tree generation cancelled"));
    return;
  }
  inputdata->setTreeType(getTreeType());
  inputdata->setTreeHillClimbSteps(treearg_numits->GetValue());
  inputdata->setTreeTestMax(treearg_maxtry->GetValue());
  if(inputdata->generateTree((wxPanel*)this)){
    if(isfull){
      fd->setHeatmapAsAggCopy();
      parent->checkXtree(true);
      parent->checkYtree(true);
      parent->enableViewAggregatedData();
      parent->checkViewAggregatedData();
      fd->refreshGrid();
      parent->Refresh();
    }
    datawinstatus->SetLabel(wxT("Status: Tree generation success"));
  }else datawinstatus->SetLabel(wxT("Status: Tree generation failure"));
}

bool DataWindow::checkDataFile(){
	int cpval=compareDataFiles(std::string(inputdata->getreaddatafilename().mb_str()), inputdata->getData()->getFileName());
//  cout<<"comparing: "<<std::string(readdatafilename.mb_str())<<" and "<<d->getFileName()<<endl;
	long cpcontinue=wxID_OK;
	if(cpval==-1){
	    wxMessageDialog tdialog(this,wxT("WARNING: The MCMC appears to have been run on a different data file.  If this is the case, you may experience strange clustering."),wxT("Possible Data File Inconsistency. Continue?"),wxOK|wxCANCEL);
	    cpcontinue=tdialog.ShowModal();
	}else if (cpval==1){
	  wxMessageDialog tdialog(this,wxT("WARNING: Cannot determine if the MCMC was run on this data file."),wxT("Possible Data File Inconsistency. Continue?"),wxOK|wxCANCEL);
	  cpcontinue=tdialog.ShowModal();
	}else if(cpval==2){
	  wxMessageDialog tdialog(this,wxT("WARNING: The data file has a different directory name than the one used for the mcmc creation.  This may be correct but may mean that the MCMC was run on a different file."),wxT("Possible Data File Inconsistency. Continue?"),wxOK|wxCANCEL);
	  cpcontinue=tdialog.ShowModal();
	}
    if(cpcontinue!=wxID_OK) return(false);
    return(true);
}

void DataWindow::OnTreeRead(wxCommandEvent & event){
  if(!checkDataFile()) {
    datawinstatus->SetLabel(wxT("Status: Tree read cancelled"));
    return;
  }

  if(inputdata->readTree()){
    if(isfull){
      fd->setHeatmapAsAggCopy();
      parent->checkXtree(true);
      parent->checkYtree(true);
      parent->enableViewAggregatedData();
      parent->checkViewAggregatedData();
      fd->refreshGrid();
      parent->Refresh();
    }
    datawinstatus->SetLabel(wxT("Status: Tree read success"));
  }else{
    datawinstatus->SetLabel(wxT("Status: Tree read failure"));
  }
}

void DataWindow::OnTreeWrite(wxCommandEvent & event) {
  if(inputdata->writeTree()){
    datawinstatus->SetLabel(wxT("Status: Tree write success"));
  }else {
    datawinstatus->SetLabel(wxT("Status: Tree write failure"));
  }
}

void DataWindow::OnQuit(wxCommandEvent& WXUNUSED(event))
{
 // inputdata->setMetaName(metafile->GetValue());
  //inputdata->setCopyName(copyfile->GetValue());
  //inputdata->readCopyFile();
  Close(true);
}

void DataWindow::OnCancel(wxCommandEvent& WXUNUSED(event))
{

  Close(true);
}

void DataWindow::OnHelp(wxCommandEvent& WXUNUSED(event))
{
  wxMessageBox(wxT("This is the helpfile for data input.  It has not yet been written.  Sadly, you re on your own."),wxT("Input format help"));
}

void DataWindow::OnMetaEdit(wxCommandEvent & event){
  settings->setFileName(FilenameStringValidator(metafile,settings->getFileNameOnlyString()));
}

void DataWindow::OnFixedEdit(wxCommandEvent & event){
  inputdata->setFixedName(FilenameStringValidator(fixedfile,inputdata->getFixedName()));
}

void DataWindow::OnTreeEdit(wxCommandEvent & event){
  inputdata->setTreeName(FilenameStringValidator(treefile,inputdata->getTreeName()));
}

void DataWindow::OnDataEdit(wxCommandEvent & event){
  inputdata->setCopyName(FilenameStringValidator(copyfile,inputdata->getCopyName()));
}

void DataWindow::OnMcmcEdit(wxCommandEvent & event){
  inputdata->setMcmcName(FilenameStringValidator(mcmcfile,inputdata->getMcmcName()));
}

wxString DataWindow::FilenameStringValidator(wxTextCtrl *textcontrol,wxString oldval)
{
  wxString val=textcontrol->GetValue();
  wxString ret;
  int tmp=textcontrol->GetInsertionPoint();
  
  if(val.Left(10).Cmp(wxT("Filename: "))==0) {ret =val.AfterFirst(wxChar(' '));
  }else if(val.Cmp(wxT(""))==0) {ret=wxT("");
  }else ret=oldval;

  textcontrol->ChangeValue(wxT("Filename: ")+ret);    
 
  if(tmp<11) textcontrol->SetInsertionPoint(11);
  else textcontrol->SetInsertionPoint(tmp);
  
  return(ret);
}

/*
  wxFileDialog * openFileDialog = new wxFileDialog(this);
  if (openFileDialog->ShowModal() == wxID_OK){
      wxString fileName = openFileDialog->GetPath();
//      *curfile=fileName;
      cout<<std::string(fileName.mb_str())<<endl;
      author->SetLabel(fileName);

  }
  */
//#endif
