
#ifndef DATAWINDOW_H
#define DATAWINDOW_H

#include <wx/wx.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/combobox.h>
#include <wx/arrstr.h>
#include <vector>

#include "inputdata.h"
#include "wholedisplay.h"

#define DATAWINDOW_ID_READMETA 2
#define DATAWINDOW_ID_HELPBUTTON 3
#define DATAWINDOW_ID_ACCEPTBUTTON 4

#define DATAWINDOW_ID_METACBX 11
#define DATAWINDOW_ID_COPYCBX 12
#define DATAWINDOW_ID_MCMCCBX 13
#define DATAWINDOW_ID_TREECBX 14
#define DATAWINDOW_ID_FIXEDCBX 15

#define DATAWINDOW_ID_COPYLOADBUTTON 31
#define DATAWINDOW_ID_COPYBUTTON 32
#define DATAWINDOW_ID_MCMCFILEBUTTON 33
#define DATAWINDOW_ID_MCMCGENERATEBUTTON 34
#define DATAWINDOW_ID_MCMCREADPCMBUTTON 35
#define DATAWINDOW_ID_MCMCHELPBUTTON 36
#define DATAWINDOW_ID_TREEFILEBUTTON 37
#define DATAWINDOW_ID_TREEGENERATEBUTTON 38
#define DATAWINDOW_ID_TREEREADPCMBUTTON 39
#define DATAWINDOW_ID_TREEWRITEPCMBUTTON 40

#define DATAWINDOW_ID_METALOADBUTTON 51
#define DATAWINDOW_ID_METAWRITEBUTTON 52
#define DATAWINDOW_ID_METABUTTON 53

#define DATAWINDOW_ID_FIXEDLOADBUTTON 56
#define DATAWINDOW_ID_FIXEDCREATEBUTTON 57
#define DATAWINDOW_ID_FIXEDCHOOSEBUTTON 59

#define DATAWINDOW_ID_SHOWCOPYEXTRAS 61

#define DATAWINDOW_ID_METAFILETEXTBOX 62
#define DATAWINDOW_ID_FIXEDFILETEXTBOX 63
#define DATAWINDOW_ID_DATAFILETEXTBOX 64
#define DATAWINDOW_ID_MCMCFILETEXTBOX 65
#define DATAWINDOW_ID_TREEFILETEXTBOX 66

using namespace std;

class FineMainWindow;
class SettingsIO;

class DataWindow : public wxFrame
{
  friend class SettingsIO;
public:
  DataWindow(SettingsIO *settings,InputData *inputdata,FineDisplay *fd,bool full,FineMainWindow *parent,wxPanel *parentaspanel, int id,const wxString& title);
  void OnQuit(wxCommandEvent & event);
  void OnMainHelp(wxCommandEvent & event);
  void OnCancel(wxCommandEvent & event);
// Meta functions
  void OnMetaLoad(wxCommandEvent & event);
  void OnMetaFile(wxCommandEvent & event);
  void OnMetaWrite(wxCommandEvent & event);
// Copy functions  
  void OnHelp(wxCommandEvent & event);
  void OnCopyFile(wxCommandEvent & event);
  void OnCopyLoad(wxCommandEvent & event);
  void OnCopyShowExtras(wxCommandEvent & event);
// Fixed continent functions  
  void OnFixedFile(wxCommandEvent & event);
  //void OnFixedLoad(wxCommandEvent & event);
  //void OnFixedCreate(wxCommandEvent & event);
// MCMC functions
  void OnMcmcFile(wxCommandEvent & event);
  void OnMcmcGenerate(wxCommandEvent & event);
  void OnMcmcRead(wxCommandEvent & event);
  void OnMcmcHelp(wxCommandEvent & event);
// Tree functions
  void OnTreeFile(wxCommandEvent & event);
  void OnTreeGenerate(wxCommandEvent & event);
  void OnTreeRead(wxCommandEvent & event);
  void OnTreeWrite(wxCommandEvent & event);  
// Text editing functions
  void OnMetaEdit(wxCommandEvent & event);  
  void OnFixedEdit(wxCommandEvent & event);  
  void OnTreeEdit(wxCommandEvent & event);  
  void OnDataEdit(wxCommandEvent & event);  
  void OnMcmcEdit(wxCommandEvent & event);
  wxString FilenameStringValidator(wxTextCtrl *textcontrol,wxString oldval);
// Functions to do with the overall layout
  inline void fit(){
    Layout();
    fgs->Layout();
    wxSize ts=fgs->GetMinSize();
    SetMinSize(ts);
    SetSize(ts);
  }
  inline void OnMetaCbx(wxCommandEvent & event){
    if(metacbx->IsChecked()) metapanel->Show();
    else metapanel->Hide();
    fit();
  }
  inline void OnCopyCbx(wxCommandEvent & event){
    if(copycbx->IsChecked()) copypanel->Show();
    else copypanel->Hide();
    fit();
  }
  inline void OnMcmcCbx(wxCommandEvent & event){
    if(mcmccbx->IsChecked()) mcmcpanel->Show();
    else mcmcpanel->Hide();
    fit();
  }
  inline void OnTreeCbx(wxCommandEvent & event){
    if(treecbx->IsChecked()) treepanel->Show();
    else treepanel->Hide();
    fit();
  }

  inline void OnFixedCbx(wxCommandEvent & event){
    inputdata->setUseFixed(fixedcbx->IsChecked());
    fixedFileButton->Enable(fixedcbx->IsChecked());
    fixedfile->Enable(fixedcbx->IsChecked());
  }  
  inline int getTreeType(){
    if(treeType->GetValue()==wxT("Observed")) return(1);
    else if(treeType->GetValue()==wxT("Merge Climb")) return(2);
    else return(3);
  }
  inline void setTreeType(int val){
    if(val==1) treeType->SetValue(wxT("Observed"));
    else if(val==2) treeType->SetValue(wxT("Merge Climb"));
    else if(val==3) treeType->SetValue(wxT("Full Hill Climb"));
  }
  bool checkDataFile();///< Checks if the data file name matches, and lets the user decide whether to continue

// LAYOUT
  bool isfull;
  FineMainWindow *parent;
  wxPanel *panel;
  wxStaticText *datawinstatus;
  
  wxFlexGridSizer *fgs;
  wxFlexGridSizer *metafgs;
  wxFlexGridSizer *copyfgs;
  wxFlexGridSizer *mcmcfgs;
  wxFlexGridSizer *treefgs;

  wxCheckBox *metacbx;
  wxCheckBox *copycbx;
  wxCheckBox *fixedcbx;
  wxCheckBox *mcmccbx;
  wxCheckBox *treecbx;
  wxPanel *metapanel;
  wxPanel *fixedpanel;
  wxPanel *copypanel;
  wxPanel *mcmcpanel;
  wxPanel *treepanel;
  wxPanel *copyextrapanel;

  // METAFILE STUFF
  wxTextCtrl *metafile;
  wxButton * metaButton;
  wxButton * metaLoadButton;
  wxButton * metaWriteButton;
  
  // COPYFILE STUFF
  wxButton *copyButton;
  wxButton *copyLoadButton;  
  wxTextCtrl *copyfile;
  wxTextCtrl *copyskip;
  wxCheckBox *copycbxX;
  wxCheckBox *copycbxY;
  wxCheckBox *copyHideExtras;
  
  // FIXEDFILE STUFF
  wxButton *fixedLoadButton;
  wxButton *fixedFileButton;
  wxButton *fixedCreateButton;  
  wxTextCtrl *fixedfile;
 
  // MCMCFILE STUFF
  wxButton *mcmcFileButton;
  wxButton *mcmcGenerateButton;  
  wxTextCtrl *mcmcfile;
  wxTextCtrl *mcmcburnin;
  wxTextCtrl *mcmcruntime;
  wxTextCtrl *mcmcskip;
  wxTextCtrl *mcmcconst;
  wxButton *mcmcReadPCM;
  wxButton *mcmcHelp;
 
  // TREEFILE STUFF
  wxButton *treeFileButton;
  wxButton *treeGenerateButton;
  wxTextCtrl *treefile;
  wxTextCtrl *treearg_maxtry;
  wxTextCtrl *treearg_numits;
  wxButton *treeReadButton;
  wxButton *treeWriteButton;
  wxComboBox *treeType;
// CONTENT  
  InputData *inputdata;

  wxButton *helpButton;
  wxButton *acceptButton;
  wxButton *cancelButton;

  SettingsIO *settings;
  FineDisplay *fd;
};

#endif
