
#include "heatmap.h"
#include <wx/dcbuffer.h>
#include <wx/tokenzr.h>

Heatmap::Heatmap(InputData *indat,InputData *indat2,VisGrid *visgrid,wxPanel *parent, int id)
      : wxVirtualPanel(parent, id, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE)
{
  smin=0;
  smax=0;
  this->visgrid=visgrid;
  plotPops=true;

  m_parent = parent;
  dat=indat;
  dat2=indat2;
  Connect(wxEVT_PAINT, wxPaintEventHandler(Heatmap::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(Heatmap::OnSize));
  Connect(wxEVT_ERASE_BACKGROUND, wxEraseEventHandler(Heatmap::OnErase));
  SetMinSize(wxSize(400,400));
  defaultColours();
}

vector<vector<double> > Heatmap::getDefaultColours(){
  return(wxStringAsColourVector(wxT("1,1,0;1,0,0;1,0,1;0,0,1")));
}

vector<double> Heatmap::getDefaultSpeed(){
  return(wxStringAsColourTimes(wxT("1;1;1;0")));
}

vector<vector<double> > Heatmap::wxStringAsColourVector(wxString myval)
{
    vector<vector<double> > scalecol;
    wxStringTokenizer tokenizer(myval, wxT(";"));
    while ( tokenizer.HasMoreTokens() )
    {
      scalecol.push_back(vector<double>(3,0));
      wxString token = tokenizer.GetNextToken();
      wxStringTokenizer tokenizer2(token, wxT(","));
      int count=0;
      while ( tokenizer2.HasMoreTokens() )
      {
	wxString token2 = tokenizer2.GetNextToken();
	if(count<3) token2.ToDouble(&(scalecol[scalecol.size()-1][count++]));	
      }
    }
    return(scalecol);
}

vector<double> Heatmap::wxStringAsColourTimes(wxString myval)
{
  vector<double> scaletimes;
    wxStringTokenizer tokenizer3(myval, wxT(";"));
    while ( tokenizer3.HasMoreTokens() ) {
	wxString token3 = tokenizer3.GetNextToken();
	double tval=0.0;
	token3.ToDouble(&(tval));	
	scaletimes.push_back(tval);
    }
  return(scaletimes);
}

void Heatmap::defaultColours(){

  if(!setColours(getDefaultColours(),getDefaultSpeed())){
    cerr<<"Error: Default colours are failing to initialise!"<<endl;
    throw(string(" Heatmap::defaultColours() failure"));
  };
}

bool Heatmap::setColours(vector<vector<double> > rgbptsin,vector< double > speed){
  if(speed.size()!=rgbptsin.size()) return(false);
  double oldtotrgbspeed=totrgbspeed;
  totrgbspeed=0;
  for(unsigned int c1=0;c1<speed.size();c1++) {
    totrgbspeed+=speed[c1];
    if(rgbptsin[c1].size()<3) {totrgbspeed=oldtotrgbspeed;return(false);}
  }
  rgbspeed=speed;
  rgbpts=rgbptsin;
  return(true);
}

wxColour Heatmap::getColNorm(double val){
    if(val<= -0.000001) return(wxColour(255,255,255));
  double summedspeed=0;
  for(unsigned int c1=1;c1<rgbpts.size();c1++){
    if(val<=(summedspeed+rgbspeed[c1-1])/totrgbspeed) {
      double tval=val - summedspeed/totrgbspeed;
      tval*= totrgbspeed/(rgbspeed[c1-1]);
      return(wxColour(255*(rgbpts[c1-1][0] + (rgbpts[c1][0]-rgbpts[c1-1][0])*tval),
		      255*(rgbpts[c1-1][1] + (rgbpts[c1][1]-rgbpts[c1-1][1])*tval),
		      255*(rgbpts[c1-1][2] + (rgbpts[c1][2]-rgbpts[c1-1][2])*tval)));
    }
    summedspeed+=rgbspeed[c1-1];    
  }
  return(wxColour(0,0,0));
}

wxColour Heatmap::getCol(double val){
  if(smax<=smin) return(wxColour(255, 255,255));
  if((val-smin)/(smax-smin)< -0.000001 ) return(wxColour(255, 255,255));
  if((val-smin)/(smax-smin)>1) return(wxColour(0,0,0));
  return(getColNorm((val-smin)/(smax-smin)));
}

void Heatmap::OnPaint(wxPaintEvent& event)
{
  //wxPaintDC dc(this);
  wxBufferedPaintDC  dc(this);
  show(dc);
}

void Heatmap::show(wxDC&  dc){
  dc.SetPen(wxPen(wxColour(255, 255,255)));
  dc.SetBrush(wxBrush(wxColour(255, 255,255)));
  dc.DrawRectangle(0,0, GetSize().x,GetSize().y);
//  visgrid->setGrid(dat->getN(visgrid->getDatavis()),GetSize().x,GetSize().y);
  setScale();
  int dv=visgrid->getDatavis();
  bool usedata2=visgrid->getData2();
  if(dat->getMsize(false,dv)!=dat2->getMsize(false,visgrid->getDatavis2())) usedata2=false;
  if(dat->getMsize(true,dv)!=dat2->getMsize(true,visgrid->getDatavis2())) usedata2=false;
  double val=0;
  for(int c1=0;c1<datX();c1++){
    for(int c2=0;c2<datY();c2++){
      if(c1>c2 &&visgrid->getDatavis2()!=FSGUI_SHOW_NONE) dv=visgrid->getDatavis2();
      else dv=visgrid->getDatavis();
      if(c1>c2 && usedata2) val=(dat2->getM(c1,c2,dv,dat->getorder())+dat2->getM(c2,c1,dv,dat->getorder()))/2.0;
      else if(c1<=c2 && usedata2) val=(dat->getM(c1,c2,dv)+dat->getM(c2,c1,dv))/2.0;
      else val=dat->getM(c1,c2,dv);
      dc.SetPen(wxPen(getCol(val)));//dat->getM(datavis)->at(c1)[c2])));
      dc.SetBrush(wxBrush(getCol(val)));
      vector<int> rect=visgrid->getRect(c1,c2);
      dc.DrawRectangle(rect[0],rect[1],rect[2],rect[3]);
    }
  }
  if(plotPops){
    
  }
  setScale();
}

void Heatmap::OnSize(wxSizeEvent& event)
{
  Refresh();
}


