
#ifndef FINEMAINWINDOW_H
#define FINEMAINWINDOW_H

#define FINEMAINWINDOW_ID_EXPORT 1
#define FINEMAINWINDOW_EDIT_NAMES 2
#define FINEMAINWINDOW_ID_NEW 3
#define FINEMAINWINDOW_EDIT_POPS 4
#define FINEMAINWINDOW_LABEL_INDS 35

#define FINEMAINWINDOW_ID_VIEWDATA 5
#define FINEMAINWINDOW_ID_VIEWAGDATA 6
#define FINEMAINWINDOW_ID_VIEWAGDATASIMPLE 601
#define FINEMAINWINDOW_ID_VIEWPC 7
#define FINEMAINWINDOW_ID_VIEW2ENABLE 8
#define FINEMAINWINDOW_ID_VIEW2DATA 9
#define FINEMAINWINDOW_ID_VIEW2AGDATA 10
#define FINEMAINWINDOW_ID_VIEW2PC 11
#define FINEMAINWINDOW_ID_OPEN2 12
#define FINEMAINWINDOW_ID_VIEW2ALTDATA 13
#define FINEMAINWINDOW_ID_PLOTMCMC 14
#define FINEMAINWINDOW_ID_PLOTPCA 15

#define FINEMAINWINDOW_REORDER_POPS 16
#define FINEMAINWINDOW_ID_EXPORTPS 17

#define FINEMAINWINDOW_ID_SHOWXLAB 21
#define FINEMAINWINDOW_ID_SHOWYLAB 22
#define FINEMAINWINDOW_ID_SHOWXTREE 23
#define FINEMAINWINDOW_ID_SHOWYTREE 24
#define FINEMAINWINDOW_ID_XSIZE 25
#define FINEMAINWINDOW_ID_YSIZE 26
#define FINEMAINWINDOW_ID_TREEXSIZE 27
#define FINEMAINWINDOW_ID_TREEYSIZE 28
#define FINEMAINWINDOW_ID_LABELXSIZE 29
#define FINEMAINWINDOW_ID_LABELYSIZE 30
#define FINEMAINWINDOW_ID_TREEPENWIDTH 31
#define FINEMAINWINDOW_ID_FONTSIZE 32
#define FINEMAINWINDOW_ID_USEPOPLABELS 33
#define FINEMAINWINDOW_ID_PERPPOPLABELS 34
#define FINEMAINWINDOW_ID_CLASSIFYLABELS 35
#define FINEMAINWINDOW_ID_CLASSIFYSIZE 36

#define FINEMAINWINDOW_ID_SHOWSCALE 41
#define FINEMAINWINDOW_ID_SCALEWIDTH 42
#define FINEMAINWINDOW_ID_SCALEBARSIZE 43
#define FINEMAINWINDOW_ID_SCALETEXTSIZE 44
#define FINEMAINWINDOW_ID_SCALEFORMAT 45
#define FINEMAINWINDOW_ID_SCALEMAX 46
#define FINEMAINWINDOW_ID_SCALEMIN 47

#define FINEMAINWINDOW_ID_SEPCONTSCALE 48
#define FINEMAINWINDOW_ID_CONTSIZE 49
#define FINEMAINWINDOW_ID_USECONTINENTROWS 50
#define FINEMAINWINDOW_ID_USECONTINENTCOLS 51

#define FINEMAINWINDOW_ID_SHOWDISPLAY 52
#define FINEMAINWINDOW_ID_REFRESHBUTTON 53

#define FINEMAINWINDOW_ID_POPSCALE 54
#define FINEMAINWINDOW_SCALECHOOSER 55

#include <wx/wx.h>
#include <wx/menu.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dc.h>
#include <wx/printdlg.h>
#include <wx/print.h>
#include <vector>

#include "wholedisplay.h"
#include "inputdata.h"
#include "datawin.h"
#include "nameswindow.h"
#include "popswindow.h"
#include "labelinds.h"
#include "multiplot.h"
#include "pca.h"
#include "reorderall.h"
#include "scalechooser.h"

using namespace std;
class SettingsIO;

class FineMainWindow : public wxFrame
{
  friend class SettingsIO;
public:
  FineMainWindow(const wxString& title);
  void OnQuit(wxCommandEvent & event);
  void OnOpen(wxCommandEvent & event);
  void OnOpen2(wxCommandEvent & event);
  void OnNew(wxCommandEvent & event);
  void OnExport(wxCommandEvent & event);
  void OnExportPS(wxCommandEvent & event);
  void OnEditNames(wxCommandEvent & event);
  void OnEditPops(wxCommandEvent & event);
  void OnLabelInds(wxCommandEvent & event);
  void OnScaleChooser(wxCommandEvent & event);
  void OnReorderPops(wxCommandEvent & event);
  void OnPlotMCMC(wxCommandEvent & event);
  void OnPlotPCA(wxCommandEvent & event);
  inline void OnRefreshChecked(wxCommandEvent & event){
    setShowDisplay(autoRefreshBox->IsChecked());
  }
  inline void setShowDisplay(bool val){
    showdisplay = val;
    autoRefreshBox->SetValue(val);
    if(showdisplay) {
      applySettings(showdisplay);
    }else{
      finedisplay->Hide();
    }
  }
  inline void OnRefreshButton(wxCommandEvent & event){
    setShowDisplay(true);   
  }
  inline void conditionalRefresh(bool complete){
    if(complete){
	finedisplay->fit(false);
    }
    if(showdisplay) {
      Refresh();
    }
  }
  inline void OnViewData(wxCommandEvent & event){
    checkViewRawData();
    finedisplay->setHeatmapAsCopy();
    conditionalRefresh(true);
  }
  inline void OnViewAgData(wxCommandEvent & event){
    checkViewAggregatedData();
    finedisplay->setHeatmapAsAggCopy();
    conditionalRefresh(true);
  }
  inline void OnViewAgDataSimple(wxCommandEvent & event){
    checkViewAggregatedDataSimple();
    finedisplay->setHeatmapAsAggCopySimple();
    conditionalRefresh(true);
  }
  inline void OnViewPC(wxCommandEvent & event){
    checkViewPairwiseCoincidence();
    finedisplay->setHeatmapAsPCM();
    conditionalRefresh(true);
  }
  inline void OnSepContScale(wxCommandEvent & event){
    checkSepContScale(sepContScale->IsChecked());    
  }
  inline void OnContSize(wxCommandEvent & event){
    int newsize=wxAtoi(contSize->GetValue());
    if(newsize<=0){
      int oldsize=inputdata->getContSize();
      wxString mysize; mysize<<oldsize;
      contSize->SetValue(mysize);
    }else{
      inputdata->setContSize(newsize);
      conditionalRefresh(true);
    }
  }
  inline void OnPopSizeScale(wxCommandEvent & event){
    double newscale=wxAtof(popSizeScale->GetValue());
    applyPopSizeScale(newscale);
  }
  inline void applyPopSizeScale(double newscale, bool refresh=true){
    if(newscale<0){
      double oldsize=finedisplay->getPopSizeScale();
      wxString mysize; mysize<<oldsize;
      popSizeScale->SetValue(mysize);
    }else{
      finedisplay->setPopSizeScale(newscale);
      wxString mysize; mysize<<newscale;
      popSizeScale->SetValue(mysize);
      conditionalRefresh(refresh);
    }    
  }
  inline double getPopSizeScale(){
    return(finedisplay->getPopSizeScale());
  }
  inline void OnView2Enable(wxCommandEvent & event){
    checkView2Enable(view2Enable->IsChecked());
    finedisplay->setHeatmap2AsHeatmap();
    conditionalRefresh(false);
  }
  inline void OnView2AltData(wxCommandEvent & event){
    checkView2AltData(view2AltData->IsChecked());
    //finedisplay->setHeatmap2AsHeatmap();
    conditionalRefresh(false);
  }  
  inline void OnView2Data(wxCommandEvent & event){
    checkView2RawData();
    finedisplay->setHeatmap2AsCopy();
    conditionalRefresh(true);
  }
  inline void OnView2AgData(wxCommandEvent & event){
    checkView2AggregatedData();
    finedisplay->setHeatmap2AsAggCopy();
    conditionalRefresh(true);
  }
  inline void OnView2PC(wxCommandEvent & event){
    checkView2PairwiseCoincidence();
    finedisplay->setHeatmap2AsPCM();
    conditionalRefresh(true);
  }
  inline void checkView2Enable(bool val=true){  
    view2Enable->Check(val);
    if(viewData->IsEnabled()) view2Data->Enable(val);
    if(viewaggregatedData->IsEnabled()) view2aggregatedData->Enable(val);
    if(viewCoincidence->IsEnabled()) view2Coincidence->Enable(val);
  }
  inline void checkView2AltData(bool val=true){  
    view2AltData->Check(val);
    finedisplay->setData2(val);
    if(inputdata2->hasData()) view2Data->Enable(val);
    if(inputdata2->hasPCM()) view2aggregatedData->Enable(val);
    if(inputdata2->hasTree()) view2Coincidence->Enable(val);
  }
  inline void checkViewRawData(bool val=true){
    viewData->Check(val);
    viewaggregatedData->Check(false);
    viewaggregatedDataSimple->Check(false);
    viewCoincidence->Check(false);        
    menubar->EnableTop(3,true);     
  }
  inline void checkViewAggregatedData(bool val=true){
    viewData->Check(false);
    viewaggregatedData->Check(val);
    viewaggregatedDataSimple->Check(false);
    viewCoincidence->Check(false);
    menubar->EnableTop(3,true);     
  }  
  inline void checkViewAggregatedDataSimple(bool val=true){
    viewData->Check(false);
    viewaggregatedData->Check(false);
    viewaggregatedDataSimple->Check(val);
    viewCoincidence->Check(false);
    if(val) {
      checkUsePopLabels(true);
      finedisplay->setHeatmap2AsHeatmap();
      menubar->EnableTop(3,false);
      checkView2Enable(false);
    }else{
      menubar->EnableTop(3,true);
    }
  }  
  inline void checkViewPairwiseCoincidence(bool val=true){
    viewData->Check(false);
    viewaggregatedData->Check(false);
    viewaggregatedDataSimple->Check(false);
    viewCoincidence->Check(val);        
    menubar->EnableTop(3,true);     
  }    
  inline void checkView2RawData(bool val=true){
    view2Data->Check(val);
    view2aggregatedData->Check(false);
    view2Coincidence->Check(false);        
  }
  inline void checkView2AggregatedData(bool val=true){
    view2Data->Check(false);
    view2aggregatedData->Check(val);
    view2Coincidence->Check(false);        
  }  
  inline void checkView2PairwiseCoincidence(bool val=true){
    view2Data->Check(false);
    view2aggregatedData->Check(false);
    view2Coincidence->Check(val);        
  }    
  inline void enableViewRawData(bool val=true){
    viewData->Enable(val);
    if(view2Enable->IsChecked())view2Data->Enable(val);
  }
  inline void enableViewAggregatedData(bool val=true){
    viewaggregatedData->Enable(val);
    viewaggregatedDataSimple->Enable(val);
    if(view2Enable->IsChecked())view2aggregatedData->Enable(val);
  }
  inline void enableViewPairwiseCoincidence(bool val=true){
    viewCoincidence->Enable(val);
    if(view2Enable->IsChecked())view2Coincidence->Enable(val);
  }
  inline void OnXlabCbx(wxCommandEvent & event){
    finedisplay->setLabXVis(showXlab->IsChecked());
    conditionalRefresh(true);//finedisplay->fit();    
  }
  inline void OnYlabCbx(wxCommandEvent & event){
    finedisplay->setLabYVis(showYlab->IsChecked());
    conditionalRefresh(true);//finedisplay->fit();
  }
  inline void OnXtreeCbx(wxCommandEvent & event){
    checkXtree(showXtree->IsChecked());
  }
  inline void OnYtreeCbx(wxCommandEvent & event){
    checkYtree(showYtree->IsChecked());
  }
  inline void OnShowScale(wxCommandEvent & event){
    applyShowScale();
  }
  inline void applyShowScale(bool refresh=true){
    finedisplay->setShowScale(showScale->IsChecked());
    conditionalRefresh(refresh);//finedisplay->fit();
    
  }
  inline void checkXtree(bool val,bool refresh=true){
    showXtree->SetValue(val);
    finedisplay->setTreeXVis(val);
    conditionalRefresh(refresh);//finedisplay->fit();
  }
  inline void checkYtree(bool val,bool refresh=true){
    showYtree->SetValue(val);
    finedisplay->setTreeYVis(val);
    conditionalRefresh(refresh);//finedisplay->fit();
  }
  inline void checkXlabels(bool val,bool refresh=true){
    showXlab->SetValue(val);
    finedisplay->setLabXVis(val);
    conditionalRefresh(refresh);//finedisplay->fit();
  }
  inline void checkYlabels(bool val,bool refresh=true){
    showYlab->SetValue(val);
    finedisplay->setLabYVis(val);
    conditionalRefresh(refresh);//finedisplay->fit();
  }
  inline void OnXsizeCtl(wxCommandEvent & event){
    int newx=wxAtoi(wholeXsize->GetValue());
    wxSize newsize=finedisplay->getSize();
    if(newx<=0){
      rejectSizing();
    }else{
      newsize.x=newx;
      acceptSizing(newsize);
    }
  }
  inline void OnYsizeCtl(wxCommandEvent & event){
    int newy=wxAtoi(wholeYsize->GetValue());
    wxSize newsize=finedisplay->getSize();
    if(newy<=0){
      rejectSizing();
    }else{
      newsize.y=newy;
      acceptSizing(newsize);
    }
  }
  inline void rejectSizing(){
     wxSize newsize=finedisplay->getSize();
     wxString myy,myx;
     myx << newsize.x;
     myy << newsize.y;
     wholeXsize->SetValue(myx);
     wholeYsize->SetValue(myy);
  }
  inline void acceptSizing(wxSize newsize){
    finedisplay->setSize(newsize);
    finescroller->SetScrollbars(scrollsize, scrollsize, newsize.x/scrollsize, newsize.y/scrollsize);
    conditionalRefresh(true);//finedisplay->fit();
  }
  inline void OnTreeXsizeCtl(wxCommandEvent & event){
    int newsize=wxAtoi(treeXsize->GetValue());
    if(newsize<=0){
      int oldsize=finedisplay->getXtreeSize();
      wxString mysize; mysize<<oldsize;
      treeXsize->SetValue(mysize);
    }else{
      finedisplay->setXtreeSize(newsize);
//      finedisplay->Refresh();finedisplay->Update();
    }
  }
  inline void OnTreeYsizeCtl(wxCommandEvent & event){
    int newsize=wxAtoi(treeYsize->GetValue());
    if(newsize<=0){
      int oldsize=finedisplay->getYtreeSize();
      wxString mysize; mysize<<oldsize;
      treeYsize->SetValue(mysize);
    }else{
      finedisplay->setYtreeSize(newsize);
    }
  }
  inline void OnLabelXsizeCtl(wxCommandEvent & event){
    int newsize=wxAtoi(labelXsize->GetValue());
    if(newsize<=0){
      int oldsize=finedisplay->getXlabelSize();
      wxString mysize; mysize<<oldsize;
      labelXsize->SetValue(mysize);
    }else{
      finedisplay->setXlabelSize(newsize);
    }
  }
  inline void OnLabelYsizeCtl(wxCommandEvent & event){
    int newsize=wxAtoi(labelYsize->GetValue());
    if(newsize<=0){
      int oldsize=finedisplay->getYlabelSize();
      wxString mysize; mysize<<oldsize;
      labelYsize->SetValue(mysize);
    }else{
      finedisplay->setYlabelSize(newsize);
    }
  }
  inline void OnTreePenWidth(wxCommandEvent & event){
    int newsize=wxAtoi(treePenWidth->GetValue());
    if(newsize<=0){
      int oldsize=finedisplay->getTreeWidth();
      wxString mysize; mysize<<oldsize;
      treePenWidth->SetValue(mysize);
    }else{
      finedisplay->setTreeWidth(newsize);
      conditionalRefresh(false);
    }
  }
  inline void OnFontSize(wxCommandEvent & event){
    double newsize=wxAtof(fontSize->GetValue());
      finedisplay->setFontSize(newsize);
      conditionalRefresh(false);
  }
  inline void OnUsePopLabels(wxCommandEvent & event){
    checkUsePopLabels(usePopLabels->IsChecked());
  }
  inline void checkUsePopLabels(bool val){
    usePopLabels->SetValue(val);
    finedisplay->setUsePopLabels(val);
    conditionalRefresh(false);
  }
  inline void OnPerpPopLabels(wxCommandEvent & event){
    checkPerpPopLabels(perpPopLabels->IsChecked());
  }
  inline void checkPerpPopLabels(bool val){
    perpPopLabels->SetValue(val);
    finedisplay->setPerpPopLabels(val);
    conditionalRefresh(false);
  }
  inline void OnUseClassifyLabels(wxCommandEvent & event){
    checkUseClassifyLabels(useClassifyLabels->IsChecked());
  }
  inline void checkUseClassifyLabels(bool val){
    useClassifyLabels->SetValue(val);
    finedisplay->setUseClassifyLabels(val);
    conditionalRefresh(false);
  }
  inline void OnClassificationLabelSize(wxCommandEvent & event){
    int newsize=wxAtoi(classificationSize->GetValue());
    if(newsize<0){
      classificationSize->SetValue(finedisplay->getClassificationSizeWx());
    }else{
      finedisplay->setClassificationSize(newsize);
      conditionalRefresh(false);
    }
  }
  inline void OnScaleWidth(wxCommandEvent & event){
    int newsize=wxAtoi(scaleWidth->GetValue());
    if(newsize<=0){
      scaleWidth->SetValue(finedisplay->getScaleSizeWx());
    }else{
      finedisplay->setScaleSize(newsize);
      conditionalRefresh(true);
    }
  }
  inline void OnScaleBarSize(wxCommandEvent & event){
    int newsize=wxAtoi(scaleBarSize->GetValue());
    if(newsize<=0){
      scaleBarSize->SetValue(finedisplay->getScaleBarSizeWx());
    }else{
      finedisplay->setScaleBarSize(newsize);
      conditionalRefresh(true);
    }
  }
  inline void OnScaleTextSize(wxCommandEvent & event){
    int newsize=wxAtoi(scaleTextSize->GetValue());
    if(newsize<=0){
      scaleTextSize->SetValue(finedisplay->getScaleTextSizeWx());
    }else{
      finedisplay->setScaleTextSize(newsize);
      conditionalRefresh(false);
    }
  }
  inline void OnScaleFormat(wxCommandEvent & event){
    finedisplay->setScaleFormat(scaleFormat->GetValue());
    conditionalRefresh(false);
  }
  inline void OnScaleMin(wxCommandEvent & event){
    double newsize=-1;
    scaleMin->GetValue().ToDouble(&newsize);
    finedisplay->setScaleMin(newsize);
    checkSepContScale(sepContScale->GetValue());
      conditionalRefresh(false);
  }
  inline void OnScaleMax(wxCommandEvent & event){
    double newsize=-1;
    scaleMax->GetValue().ToDouble(&newsize);
    finedisplay->setScaleMax(newsize);
    checkSepContScale(sepContScale->GetValue());
    
      conditionalRefresh(false);
  }

  inline void checkSepContScale(bool val){
    sepContScale->SetValue(val);
    inputdata->setSepContScale(val,finedisplay->getScaleMin(),finedisplay->getScaleMax());
    conditionalRefresh(true);
  }
  inline void OnUseContinentRows(wxCommandEvent & event){
    checkUseContinentRows(showContinentRows->IsChecked());    
  }  
  inline void OnUseContinentCols(wxCommandEvent & event){
    checkUseContinentCols(showContinentCols->IsChecked());    
  }
  inline void checkUseContinentRows(bool val){
    showContinentRows->SetValue(val);
    finedisplay->setUseContinentRows(val);
    conditionalRefresh(true);
  }
  inline void checkUseContinentCols(bool val){
    showContinentCols->SetValue(val);
    finedisplay->setUseContinentCols(val);
    conditionalRefresh(true);
  }
  inline void setSettings(SettingsIO *settings){this->settings=settings;}
  inline InputData * getInputData(){return(inputdata);}
  inline InputData * getInputData2(){return(inputdata2);}
  inline FineDisplay * getFineDisplay(){return(finedisplay);}
  void applySettings(bool showafter);
  void setCopyFile(wxString input);
  void setFixedFile(wxString input);
  void setMcmcFile(wxString input);
  void setTreeFile(wxString input);
  void setMcmcFile2(wxString input);
  void setTreeFile2(wxString input);
  //void Refresh();
  void unloadAllFiles();
  void loadDefaults();
  void SetupInputData2();
  protected:
// MENUS
  wxMenuBar *menubar;
  wxMenu *file;
  wxMenuItem *quit;
  wxMenuItem *open;
  wxMenu *organise;
  wxMenu *view;
  wxMenuItem *viewData;
  wxMenuItem *viewCoincidence;
  wxMenuItem *viewaggregatedData;
  wxMenuItem *viewaggregatedDataSimple;
  wxMenu *view2;
  wxMenuItem *view2Enable;
  wxMenuItem *view2AltData;
  wxMenuItem *view2Data;
  wxMenuItem *view2Coincidence;
  wxMenuItem *view2aggregatedData;
  wxMenu *plot;
  wxMenuItem *plotMCMC;
  wxMenuItem *plotPCA;

  wxString *curfile;
// LAYOUT
  int scrollsize;
  wxPanel *panel;
  wxPanel *panelTop;
  
  wxFlexGridSizer *fgs;
  wxFlexGridSizer *fgsTop;
  wxScrolledWindow *finescroller;
  wxScrolledWindow *sidescroller;

  wxCheckBox *autoRefreshBox;
  wxButton * refreshButton;
  
  wxTextCtrl *treeXsize;
  wxTextCtrl *treeYsize;
  wxTextCtrl *labelXsize;
  wxTextCtrl *labelYsize;
  wxTextCtrl *wholeXsize;
  wxTextCtrl *wholeYsize;
  wxCheckBox *showXlab;
  wxCheckBox *showYlab;
  wxCheckBox *showXtree;
  wxCheckBox *showYtree;
  wxCheckBox *showScale;
  wxTextCtrl *treePenWidth;
  wxTextCtrl *fontSize;
  wxCheckBox *usePopLabels;
  wxCheckBox *perpPopLabels;
  wxCheckBox *useClassifyLabels;

  wxTextCtrl *classificationSize;
  wxTextCtrl *scaleWidth;
  wxTextCtrl *scaleBarSize;
  wxTextCtrl *scaleTextSize;
  wxTextCtrl *scaleFormat;
  wxTextCtrl *scaleMin;
  wxTextCtrl *scaleMax;

  wxTextCtrl *contSize;
  wxCheckBox *sepContScale;
  wxCheckBox *showContinentRows;
  wxCheckBox *showContinentCols;
  wxTextCtrl *popSizeScale;
  
  // CONTENT
  FineDisplay *finedisplay;
  InputData *inputdata;
  InputData *inputdata2;
  DataWindow *datawin;
  DataWindow *datawin2;
  NamesWindow *nameswindow;
  LabelWindow *labelwindow;
  ScaleChooser *scalechooser;
  PopsWindow *popswindow;
  SettingsIO *settings;
  bool data2inuse;
  bool showdisplay;
};

#endif
