
#include <wx/stdpaths.h>
#include "finegui.xpm"

#include "popswindow.h"


PopsWindow::PopsWindow(InputData *inputdata,wxPanel *parent, int id,const wxString& title):
      wxFrame(parent, id, title, wxDefaultPosition, wxDefaultSize)
{
  SetSize(wxSize(200,300));
  this->inputdata=inputdata;
  this->parent=parent;

  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
//  namegrid = new wxGrid(this,-1, wxPoint(0,30), wxSize(600,120), wxWANTS_CHARS, wxPanelNameStr);
  namegrid = new wxGrid(this,-1,wxPoint(0,30), wxSize(120,120), wxWANTS_CHARS, wxPanelNameStr);
  toppanel = new wxPanel(this, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_NONE);
  toppanel->SetMinSize(wxSize(200,30));
  toppanel->SetSize(wxSize(200,30));
  vsizer=new wxFlexGridSizer(2,1,0,0);
  //hsizer=new wxFlexGridSizer(1,3,0,0);
  wxBoxSizer *hsizer=new wxBoxSizer(wxHORIZONTAL);


  okButton=new wxButton(toppanel, POPSWINDOW_ID_OKBUTTON, wxT("Accept"));
  cancelButton=new wxButton(toppanel, POPSWINDOW_ID_CANCELBUTTON, wxT("Cancel"));
  inferButton=new wxButton(toppanel, POPSWINDOW_ID_INFERBUTTON, wxT("Guess"));

  hsizer->Add(okButton,1,wxEXPAND);
  hsizer->Add(cancelButton,1,wxEXPAND);
  hsizer->Add(inferButton,1,wxEXPAND);
  toppanel-> SetSizerAndFit(hsizer);
  namegrid->CreateGrid( inputdata->getNumPops(), 3 );

    // And set grid cell contents as strings
  for(int c1=0;c1<inputdata->getNumPops();c1++){
    wxString indsinpop=inputdata->getIndsInPop(c1);
    namegrid->SetCellValue( c1, 0, inputdata->getPopName(c1,true));
    namegrid->SetCellValue( c1, 1, inputdata->getPopName(c1,true));
    namegrid->SetCellValue( c1, 2, inputdata->getIndsInPop(c1,true));
    namegrid->SetReadOnly( c1, 0 );
    namegrid->SetReadOnly( c1, 2 );
    namegrid->SetCellBackgroundColour( c1, 0, wxColour(230,230,230));
    namegrid->SetCellBackgroundColour( c1, 2, wxColour(230,230,230));
  }
  namegrid->SetColLabelValue(0,wxT("     Initial Value     "));
  namegrid->SetColLabelValue(1,wxT("       New Value       "));
  namegrid->SetColLabelValue(2,wxT("Constituent Individuals"));

  vsizer->Add(toppanel);

  vsizer->Add(namegrid);
  SetSizerAndFit(vsizer);
  vsizer->AddGrowableRow(1);
  vsizer->AddGrowableCol(0);
  vsizer->SetSizeHints( this);
  hsizer->SetSizeHints( toppanel );
  namegrid->Fit();
  Fit();
namegrid->ForceRefresh();

  SetSize(wxSize(400,420));
  wxSize newnamesize=GetSize();
  newnamesize.y-=40;
  namegrid->SetSize(newnamesize);
  SetSize(wxSize(400,420));

  Connect(POPSWINDOW_ID_OKBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PopsWindow::OnOkButton));
  Connect(POPSWINDOW_ID_CANCELBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PopsWindow::OnCancelButton));
  Connect(POPSWINDOW_ID_INFERBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(PopsWindow::OnInferButton));
  Connect( wxEVT_SIZE, wxSizeEventHandler( PopsWindow::OnSize ));

  namegrid->SetToolTip(wxT("Enter the new population labels.  The individuals are shown on the right for reference."));
  inferButton->SetToolTip(wxT("Infer populations based on keeping unique values after removing all numbers from individual names."));

}

void PopsWindow::OnOkButton(wxCommandEvent & event)
{
  for(int c1=0;c1<inputdata->getNumPops();c1++){
    inputdata->setPopName(c1,namegrid->GetCellValue( c1, 1),true);
  }
  parent->Refresh();
  Close(true);
}

void PopsWindow::OnSize(wxSizeEvent & event)
{
  wxSize newnamesize=GetSize();
  wxSize topsize=toppanel->GetSize();
  newnamesize.y-=50;
  newnamesize.x-=10;
  namegrid->SetSize(newnamesize);
}

wxString PopsWindow::guessPopString(wxString tmp){
  wxString result;
  vector<wxString> resaslist;
  size_t len = tmp.length();
  // strip the numbers from the string
  for ( size_t n = 0; n < len; n++ )
     {
        if ( strchr("_0123456789.-", tmp[n]) == NULL ) result += tmp[n];
    }
  // separate based on commas
  wxStringTokenizer tkz(result, wxT(","));
  while ( tkz.HasMoreTokens() )
  {
      wxString token = tkz.GetNextToken();
      bool found=0;
      for(unsigned long i =0;i<resaslist.size();i++) if(resaslist[i].Cmp(token)==0) found=1;
      if(found==0) resaslist.push_back(token);
      // process token here
  }
  // and concatonate using commas
  wxString rval;
  for(unsigned long i =0;i<resaslist.size();i++) {
    rval.Append(resaslist[i]);
    if(i<resaslist.size()-1) rval.Append(wxT(","));
  }
  return(rval);
}

void PopsWindow::OnInferButton(wxCommandEvent & event)
{
  for(int c1=0;c1<inputdata->getNumPops();c1++){
    wxString tmp;
    if(inputdata->nindiv(inputdata->getorder(c1))==1) {
  //  cout<<"getN="<<inputdata->getN()<<" c1="<<c1<<" getorder="<<inputdata->getorder(c1)<<" indiv="<<inputdata->nindiv(inputdata->getorder(c1))<<endl;
      tmp=guessPopString(namegrid->GetCellValue( c1, 2));
      namegrid->SetCellValue( c1, 1, tmp);
    }
  }
}

