
#include <wx/stdpaths.h>
#include <wx/msgdlg.h>
#include "finegui.xpm"

#include "reorderall.h"


ReorderAll::ReorderAll(InputData *inputdata,wxPanel *parent, int id,const wxString& title):
      wxFrame(NULL, id, title, wxDefaultPosition, wxDefaultSize)
{
/*  if(inputdata->getNumContinents()<2){
     wxMessageBox(wxT("Your dataset has fewer than 2 continents. Continents always appear first. Reorder other populations using the tree."),wxT("Not enough continents to reorder"));
     Close();
  }*/
  this->popnumber=0;
  SetSize(wxSize(400,420));
  this->inputdata=inputdata;
  this->parent=parent;
  #if defined(__WXMSW__)
  wxStandardPaths path;
  wxString iconloc=path.GetDataDir().Append(wxT("\\finegui.ico"));
  wxIcon icon(iconloc,wxBITMAP_TYPE_ICO);
  #else
  wxIcon icon(finegui_xpm);
  #endif
  SetIcon(icon);
  toppanel = new wxPanel(this, -1,wxDefaultPosition, wxDefaultSize, wxBORDER_NONE);
  toppanel->SetMinSize(wxSize(400,30));
  toppanel->SetSize(wxSize(400,30));
  wxBoxSizer *vsizer=new wxBoxSizer(wxVERTICAL);
  wxBoxSizer *hsizer=new wxBoxSizer(wxHORIZONTAL);

  okButton=new wxButton(toppanel, REORDERALL_ID_OKBUTTON, wxT("Accept"));
  cancelButton=new wxButton(toppanel, REORDERALL_ID_CANCELBUTTON, wxT("Cancel"));
  applyButton=new wxButton(toppanel, REORDERALL_ID_APPLYBUTTON, wxT("Apply"));
  upButton=new wxButton(toppanel, REORDERALL_ID_UPBUTTON, wxT("Up"));
  downButton=new wxButton(toppanel, REORDERALL_ID_DOWNBUTTON, wxT("Down"));
  hsizer->Add(okButton,1,wxEXPAND);
  hsizer->Add(cancelButton,1,wxEXPAND);
  hsizer->Add(applyButton,1,wxEXPAND);
  hsizer->Add(upButton,1,wxEXPAND);
  hsizer->Add(downButton,1,wxEXPAND);
  toppanel->SetSizerAndFit(hsizer);
  vsizer->Add(toppanel);
    hsizer->SetSizeHints( toppanel );
  //neworder= new wxListCtrl(this,REORDERALL_ID_NEWORDER, wxPoint(0,40), wxSize(400,20), wxLC_ICON,  wxDefaultValidator,wxListCtrlNameStr);
  neworder= new wxListBox(this,REORDERALL_ID_NEWORDER, wxPoint(0,40), wxSize(400,20));
  oldindex.clear();
//  for(int c1=0;c1<inputdata->getNumContinents();c1++) oldindex.push_back(inputdata->getPopOrder(c1));
  oldindex=inputdata->getPopOrder();
  newindex=oldindex;

  for(unsigned long c1=0;c1<oldindex.size();c1++){
    wxString cval;
    if((int)c1<inputdata->getNumContinents()) cval=wxT("CONTINENT: ");
    wxString tmp=cval + wxString(inputdata->getPopName(c1,true))+wxT("(")<<inputdata->getIndsInPop(c1,true)<<wxT(")");
    oldvals.Add(tmp);
    neworder->Insert(tmp,c1);
  }
  vsizer->Add(neworder);
  vsizer->Fit(this);
  vsizer->SetSizeHints( this );
  SetSizerAndFit(vsizer);

  SetSize(wxSize(600,420));
  wxSize newnamesize=GetSize();
  newnamesize.y-=40;
  neworder->SetSize(newnamesize);
  SetSize(wxSize(600,420));
  Connect(REORDERALL_ID_OKBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderAll::OnOkButton));
  Connect(REORDERALL_ID_CANCELBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderAll::OnCancelButton));
  Connect( wxEVT_SIZE, wxSizeEventHandler( ReorderAll::OnSize ));
  //Connect(REORDERALL_ID_NEWORDER, wxEVT_COMMAND_LIST_INSERT_ITEM, wxListEventHandler(ReorderPop::OnListDrag));
  Connect(REORDERALL_ID_APPLYBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderAll::OnApplyButton));
  Connect(REORDERALL_ID_UPBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderAll::OnUpButton));
  Connect(REORDERALL_ID_DOWNBUTTON, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(ReorderAll::OnDownButton));
  //Connect(-1, wxEVT_MOUSEWHEEL, wxMouseEventHandler(ReorderPop::OnMiddleWheel) );
  Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( ReorderAll::OnMiddleWheel ), NULL, this );
  neworder->Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( ReorderAll::OnMiddleWheel ), NULL, this );
  Connect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( ReorderAll::OnDClick), NULL, this );
  neworder->Connect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( ReorderAll::OnDClick ), NULL, this );
  //neworder->Connect(wxEVT_LISTBOX_DCLICK

  neworder->SetToolTip(wxT("Order of continental populations that have no tree order; Also order for PCA PLOTTING ONLY of other populations. Double click to reorder inside a population. Try holding Ctrl and using the mouse wheel."));
  upButton->SetToolTip(wxT("Move selected population up by 1.  Try  holding Ctrl and scrolling the mouse wheel up instead."));
  downButton->SetToolTip(wxT("Move selected population down by 1.  Try  holding Ctrl and scrolling the mouse wheel down instead."));
}

vector<int> ReorderAll::getFullIndex(){
 
  vector<int> tmpindex=newindex;
  
  //for(int c1=inputdata->getNumContinents();c1<inputdata->getNumPops();c1++) tmpindex.push_back(inputdata->getPopOrder(c1));
  return(tmpindex);
}

void ReorderAll::OnOkButton(wxCommandEvent & event)
{
  inputdata->reorderAll(getFullIndex());
  inputdata->setPopOrderFromTree();
  parent->Refresh();
  Close(true);
}

void ReorderAll::OnApplyButton(wxCommandEvent & event)
{
  inputdata->reorderAll(getFullIndex());
  inputdata->setPopOrderFromTree();
  parent->Refresh();
}

void ReorderAll::OnSize(wxSizeEvent & event)
{
  wxSize newnamesize=GetSize();
  newnamesize.y-=50;
  newnamesize.x-=10;
  neworder->SetSize(newnamesize);
}

/*void ReorderPop::OnListDrag(wxListEvent & event)
{
  //cout<<"I'm inserting "<<endl;
}*/

void ReorderAll::itemup()
{
//  wxMessageBox(wxT("Reordering is not always functioning correctly at present. Use at your peril."),wxT("Dangerous function"));
//  return;
  //wxArrayInt sel;
  //neworder->GetSelections(sel);
  //if(sel.size()==0) return;
  //int  i=sel[0];
  int i=neworder->GetSelection();
  if(i==wxNOT_FOUND) return;
  //cout<<"Moving item "<<i<<endl;
  if(i!=inputdata->getNumContinents() && i>=1){
    long val=newindex[i];
    newindex.erase(newindex.begin()+i);
    newindex.insert(newindex.begin()+i-1,val);
    wxString valstring=neworder->GetStringSelection();
    neworder->Delete(i);
    neworder->Insert(valstring,i-1);
    neworder->Select(i-1);
  }
}

void ReorderAll::itemdown()
{
//  wxMessageBox(wxT("Reordering is not functioning correctly at present."),wxT("Disabled function"));
//  return;

  int i=neworder->GetSelection();
  if(i==wxNOT_FOUND) return;

  if(i<(int)newindex.size()-1 && (i!=inputdata->getNumContinents()-1) ){
    long val=newindex[i];
    newindex.erase(newindex.begin()+i);
    newindex.insert(newindex.begin()+i+1,val);
    wxString valstring=neworder->GetStringSelection();
    neworder->Delete(i);
    neworder->Insert(valstring,i+1);
    neworder->Select(i+1);
  }
}

void ReorderAll::OnDClick(wxMouseEvent & event)
{
  wxString valstring=neworder->GetStringSelection();
  for(unsigned int c1=0;c1<oldvals.size();c1++) if(valstring==oldvals[c1]){

    int popnum=inputdata->getPopNode(c1,true);
    std::vector<Node*> nodes=inputdata->getNodes();
    long innode=inputdata->insidePopNode(nodes[popnum]);
      wxString title=wxT("Edit population: ");
      title<<inputdata->getPopName(c1,true);
      ReorderPop * reorderpop = new ReorderPop(innode,inputdata,parent,wxID_ANY,title);
      reorderpop->Show();
      
  }
}
