#include "showtree.h"
#include "wholedisplay.h"

//#define DEBUGPRINT(x) cout<<x<<endl
#define DEBUGPRINT(x) 

ShowTree::ShowTree(InputData *indat,VisGrid *visgrid,bool isylab,FineDisplay *parent, int id)
      : wxVirtualPanel(parent, id, wxDefaultPosition, wxDefaultSize, wxBORDER_NONE)
{

  m_parent = parent;
  this->isylab=isylab;
  this->visgrid=visgrid;
  this->dat=indat;

  Connect(wxEVT_PAINT, wxPaintEventHandler(ShowTree::OnPaint));
  Connect(wxEVT_SIZE, wxSizeEventHandler(ShowTree::OnSize));
  Connect( -1, wxEVT_LEFT_DOWN, wxMouseEventHandler(ShowTree::OnLeftDown) );

  setSize(50);
}

void ShowTree::OnPaint(wxPaintEvent& event)
{
  wxPaintDC dc(this);
  show(dc);
}


void ShowTree::show(wxDC&  dc){
  DEBUGPRINT("startShowTree");  
//    wxPaintDC dc(this);
  dc.SetPen(wxPen(wxColour(255, 255,255)));
  dc.SetBrush(wxBrush(wxColour(255, 255,255)));
  wxSize size = dc.GetSize();//GetClientSize();
  dc.DrawRectangle(0,0,size.x,size.y);
  if(isylab)size.x=visgrid->getMaxX();
  else size.y=visgrid->getMaxY();
  if(isylab) size.y-=10;
  else size.x-=10;


//  wxFont font(textsize, wxFONTFAMILY_SWISS, wxNORMAL, wxNORMAL);

//  dc.SetFont(font);
//  dc.SetTextForeground(wxColour(0,0,0));

  dc.SetBackgroundMode(wxTRANSPARENT);
  double es=ceil(visgrid->getTreeWidth()/2);
  double rootage=1.0;
  if(dat->getRoot()!=NULL)
  {
    nodes=dat->getNodes();
    rootage=dat->getRoot()->getAge();
    if(isylab)rootage*=(size.y+es)/(double)(size.y-10);
    else rootage*=(size.x+es)/(double)(size.x-10);
    dc.SetPen(wxPen(wxColour(155,155,155),visgrid->getTreeWidth()));
    dc.SetBrush(wxBrush(wxColour(155,155,155)));

    if(visgrid->getDatavis()!=FSGUI_SHOW_COPYAGMATRIXSIMPLE) {
      for(unsigned int c1=0;c1<(nodes.size());c1++){
	if(nodes[c1]->getLeft()==NULL && nodes[c1]->getRight()==NULL && nodes[c1]->getFather()!=NULL){
	  if(isylab) {
	    dc.DrawLine(getLefting(nodes[c1])*size.x,size.y - nodes[c1]->getAge()*size.y/rootage,
		      getLefting(nodes[c1])*size.x,size.y +10);
	  }else{
	    dc.DrawLine(size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1])*size.y,
		      size.x +10,getLefting(nodes[c1])*size.y);
	  }
	}
      }
    }
    for(unsigned int c1=0;c1<nodes.size();c1++){
      if(nodes[c1]->getLeft()!=NULL && nodes[c1]->getRight()!=NULL) {
// Should move the popnode drawing out so that we can extract pop ranges too.
	if(!nodes[c1]->isUnderPopNode() || visgrid->getDatavis()!=FSGUI_SHOW_COPYAGMATRIXSIMPLE){
   dc.SetPen(wxPen(wxColour(0,0,0),visgrid->getTreeWidth()));
    dc.SetBrush(wxBrush(wxColour(0,0,0)));
 	  // Normal plot for internal nodes
	  if(isylab) {
	  //  cout<<"("<<nodes[c1]->getLeft()->getLefting()*size.x<<":"<<nodes[c1]->getLeft()->getAge()*size.y<<")"<<endl;
	    dc.DrawLine(getLefting(nodes[c1]->getLeft())*size.x,size.y - nodes[c1]->getLeft()->getAge()*size.y/rootage,
		      getLefting(nodes[c1]->getLeft())*size.x,size.y - nodes[c1]->getAge()*size.y/rootage);
	    dc.DrawLine(getLefting(nodes[c1]->getRight())*size.x,size.y - nodes[c1]->getRight()->getAge()*size.y/rootage,
		      getLefting(nodes[c1]->getRight())*size.x,size.y - nodes[c1]->getAge()*size.y/rootage);
	    dc.DrawLine(getLefting(nodes[c1]->getLeft())*size.x,size.y - nodes[c1]->getAge()*size.y/rootage,
		      getLefting(nodes[c1]->getRight())*size.x,size.y - nodes[c1]->getAge()*size.y/rootage);
	  }else{
	    dc.DrawLine(size.x - nodes[c1]->getLeft()->getAge()*size.x/rootage,getLefting(nodes[c1]->getLeft())*size.y,
		      size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1]->getLeft())*size.y);
	    dc.DrawLine(size.x - nodes[c1]->getRight()->getAge()*size.x/rootage,getLefting(nodes[c1]->getRight())*size.y,
		      size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1]->getRight())*size.y);
	    dc.DrawLine(size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1]->getLeft())*size.y,
		      size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1]->getRight())*size.y);
	  }
	}else if(nodes[c1]->isPopNode() && visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE){
	  // plot population nodes going down to 0
    dc.SetPen(wxPen(wxColour(155,155,155),visgrid->getTreeWidth()));
    dc.SetBrush(wxBrush(wxColour(155,155,155)));
	  if(isylab) {
	    dc.DrawLine(getLefting(nodes[c1])*size.x,size.y - nodes[c1]->getAge()*size.y/rootage,
		      getLefting(nodes[c1])*size.x,size.y +10);
	  }else{
	    dc.DrawLine(size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1])*size.y,
		      size.x +10,getLefting(nodes[c1])*size.y);
	  }  
	}// endif nodes age> 10e-4
      }// end if nodes!=NULL. Now we know we have a tip
      else if(nodes[c1]->isPopNode() && visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE && nodes[c1]->getFather()!=NULL){ 
	// draw the tip if needed
	  // plot population nodes going down to 0
	dc.SetPen(wxPen(wxColour(155,155,155),visgrid->getTreeWidth()));
	dc.SetBrush(wxBrush(wxColour(155,155,155)));
	if(isylab) {
	  dc.DrawLine(getLefting(nodes[c1])*size.x,size.y - nodes[c1]->getAge()*size.y/rootage, getLefting(nodes[c1])*size.x,size.y +10);
	}else{
	  dc.DrawLine(size.x - nodes[c1]->getAge()*size.x/rootage,getLefting(nodes[c1])*size.y, size.x +10,getLefting(nodes[c1])*size.y);
	}
      }
    }// end for
    if(isylab) dc.DrawLine(getLefting(dat->getRoot())*size.x,size.y - dat->getRoot()->getAge()*size.y/rootage,
		    getLefting(dat->getRoot())*size.x,size.y - dat->getRoot()->getAge()*size.y/((size.y+es)/(double)size.y));
    else  dc.DrawLine(size.x - dat->getRoot()->getAge()*size.x/rootage,getLefting(dat->getRoot())*size.y,
		    size.x - dat->getRoot()->getAge()*size.x/((size.x+es)/(double)size.x),getLefting(dat->getRoot())*size.y);
  }
  DEBUGPRINT("endShowTree");  
}

void ShowTree::OnSize(wxSizeEvent& event)
{
  Refresh();
}

void ShowTree::OnLeftDown(wxMouseEvent & event)
{
  wxSize size = GetSize();//GetClientSize();
  if(isylab)size.x=visgrid->getMaxX();
  else size.y=visgrid->getMaxY();
  if(isylab) size.y-=10;
  else size.x-=10;
  double es=ceil(visgrid->getTreeWidth()/2);

  wxPoint pos=event.GetPosition();
  nodes=dat->getNodes();
  if(nodes.size()<1) return;
  double rootage=dat->getRoot()->getAge();
  if(isylab)rootage*=(size.y+es)/(double)(size.y-10);
  else rootage*=(size.x+es)/(double)(size.x-10);

  double mindistsq=1000000000;
  int minnode=-1;
  int x,y;
  
    
    // test for continent
  double hdist;
  double clickdist=pos.x;
  if(!isylab) clickdist=pos.y;
  for(int c1=0;c1<dat->getNumContinents();c1++){
    if(isylab){
      hdist= getLefting(nodes[dat->getorder(c1)])*size.x;
    }else{
      hdist= getLefting(nodes[dat->getorder(c1)])*size.y;
    }
    if(clickdist < hdist){
      ReorderAll * reorderall = new ReorderAll(dat,(wxPanel*)this,wxID_ANY,wxT("Reorder Continents / PCA order"));
      reorderall->Show();
      return;
    }
  }  
  // test for clicking on the nodes
  for(unsigned int c1=0;c1<nodes.size();c1++){
    if(isylab){
      x= getLefting(nodes[c1])*size.x;
      y= size.y - nodes[c1]->getAge()*size.y/rootage;
    }else{
      y= getLefting(nodes[c1])*size.y;
      x= size.x - nodes[c1]->getAge()*size.x/rootage;
    }
    double distsq=(x-pos.x)*(x-pos.x) + (y-pos.y)*(y-pos.y);
    if(distsq<mindistsq){ mindistsq=distsq;minnode=c1;}
  }
    if(isylab){
      x= getLefting(dat->getRoot())*size.x;
      y= size.y - dat->getRoot()->getAge()*size.y/rootage;
    }else{
      y= getLefting(dat->getRoot())*size.y;
      x= size.x - dat->getRoot()->getAge()*size.x/rootage;
    }
      
  if(minnode>=0 && mindistsq<100){
    long innode=dat->insidePopNode(nodes[minnode]);
    if(innode>=0){
      //inputdata->getIndsInPop(c1)
      wxString title=wxT("Edit population: ");
      title<<dat->getPopName(innode);
      ReorderPop * reorderpop = new ReorderPop(innode,dat,m_parent,wxID_ANY,title);
      reorderpop->Show();
    }else{
      Node *left=nodes[minnode]->getLeft();
      Node *right=nodes[minnode]->getRight();
      nodes[minnode]->setLeft(right);
      nodes[minnode]->setRight(left);
    }
  }
  dat->applytree();
  dat->setPopOrderFromTree();

    if(visgrid->getDatavis()==FSGUI_SHOW_COPYAGMATRIXSIMPLE){
      m_parent->refreshGrid();
    }
  
  m_parent->Refresh();
}

double ShowTree::getLefting(Node* node)
{
 //if(visgrid->contsEnabled(isylab))return(node->getLefting());
  return(visgrid->convertLefting(node->getLefting(),isylab));
}
