#ifdef __cplusplus
extern "C" {
#endif

#ifndef CHROMOPAINTERDONORS_H
#define CHROMOPAINTERDONORS_H

#include <stdlib.h>
#include <stdio.h>

#include "ChromoPainterData.h"
#include "ChromoPainterPar.h"
#include "ChromoPainterInfiles.h"
  
  struct donor_t {
    int allvsall; // whether we are in all vs all mode, i.e. Par->all_versus_all_ind (-a) is used and -c is NOT used
    int selfpop; // whether Par->condition_recipient_inds_find (-c) is used

    int ndonorpops; 
    int nrecipinds;
    char ** donorlabels;
    char ** reciplabels;
    int * ndonorhaps;
    // only populated when NOT in allvsall mode, and..
    double * ndonorprobs; /// Par->prior_donor_probs_inds==1
    double * ndonormutrates;/// Par->mutation_rate_ind==1
  };

  struct donor_t *createDonors(struct infiles_t *Infiles,struct ids_t *Ids,struct data_t *Data,struct param_t *Par);
  int getNpops(struct infiles_t *Infiles,struct param_t *Par);
  void readDonorPops(struct donor_t *Donors,struct ids_t *Ids,struct infiles_t *Infiles,struct data_t *Data,struct param_t *Par);
  int validateDonorCount(int nhaps,int ndonorpops,struct param_t *Par);
  void populateDonors(struct donor_t *Donors,struct ids_t *Ids,struct data_t *Data,struct param_t *Par);
  //char *** p_reciplabels,char *** donorlabels, int **ndonorhaps,

  //  void initializeCopyVecs(int ** p_pop_vec,double ** p_MutProb_vec,double ** p_copy_prob,double ** p_copy_probSTART, int ndonorpops, int *ndonorhaps,double *ndonorprobs, double *ndonormutrates,struct data_t *Data, struct param_t * Par);

  void clearDonors(struct donor_t *Donors, struct param_t * Par);

#endif

#ifdef __cplusplus
}
#endif
