#!/usr/bin/perl
## CONVERT A PLINK PED FILE TO IPPCA FORMAT
use strict;
use Switch;
use POSIX;

sub help {
print("CONVERT A PLINK PED FILE TO IPPCA FORMAT\n");

print("usage:   perl ped2ippca.pl <pedfile> <outputfile>\n");


print("where:\n");
print("<pedfile>:		PLINK PED file\n");
print("<outputfile>: File root to be generated in CSV format.\n");

die "\n";
}

###############################
## ARGUMENT PROCESSING

my $verbose=0; # Ignored!
my $pedfile="";

my $outfile="";

my $argon=0;
for (my $i = 0; $i < scalar(@ARGV); ++$i){
    if($ARGV[$i] eq "-v"){
	$verbose=1;
    }else{
	switch($argon){
	    case 0 {$pedfile="$ARGV[$i]";}
	    case 1 {$outfile="$ARGV[$i]";}
	    else {
		help();
	    }
	}
	$argon++;
    }
}

if($outfile eq "" || $argon != 2) {help();}

####################################
## Define global variables
my @indnames; # names of the individuals
my @snpvals; # value of the SNPs (each value here is an array)

my $numsnps=0; # number of SNPS defined in the file
my $numinds=0; # number of individuals defined in the file
my $numhaps=0; # number of haplotypes observed
my $ploidy=-1; # number of haps per ind

####################################
## File IO

## Check we can read the input files
open PEDFILE, $pedfile or die $!;

## Create output files
open OUTFILE, ">", $outfile or die $!;

####################################
## Functions we need
sub trim($){  # remove whitespace from beginning and end of the argument
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}


####################################
## Read the pedfile 

my $hapon=0;
while (my $tmp=<PEDFILE>) {
	my @tarr=split(' ',trim($tmp));
	my $tname=@tarr[1];
	print "Processing Individual $tname\n";
	shift (@tarr); # name
	shift (@tarr); # family
	shift (@tarr); # paternal
	shift (@tarr); # maternal
	shift (@tarr); # sex
	shift (@tarr); # phenotype
	my $snp=0;
	print OUTFILE "$tname";
	foreach (@tarr) {
	    $_ = $_ - 1;
	    if("$_" eq " "){
		print "ODD!\n";
	    }
	    if($hapon==0) {
		$snp=$_;
		$hapon=1;
	    }else{
		$snp=$snp + $_;
		$hapon=0;
		print OUTFILE ", $snp";
		$snp=0;
	    }
	}
	print OUTFILE "\n";
}

close PEDFILE;

close OUTFILE;
