/*
Copyright 2018 Andrew R. Booker, Min Lee and Andreas Strömbergsson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

characters(d) =
{
	local(m,c,answer,j,k,a);

	m=length(d);
	if(m==0,
		answer=[[]];
	,
		c = characters(vector(m-1,j,d[j]));
		answer = vector(length(c)*d[m]);
		for(a=0,d[m]-1,
			for(j=1,length(c),
				answer[a*length(c)+j]= vector(m,k,if(k<m,c[j][k],a));
			);
		);
	);
	answer
}

dot(x,y,w) =
{
	local(s,j);
	s=sum(j=1,length(x),x[j]*y[j]/w[j]);
	s-truncate(s)
}

append(L,v)=
{
	local(i);
	if(!v[1][3],return(L)); /* prune non-cuspidal forms */
	for(i=1,length(L),if(L[i]==v,return(L)));
	vector(length(L)+1,i,if(i>length(L),v,L[i]))
}

/* return L-function data; chi is assumed to be primitive */
Lfunction(R,chi,nprimes)=
{
	local(i,p,L,c,a,selberg);
	L=vector(nprimes);
	c=bnrconductorofchar(R,chi);
	selberg=[
		idealnorm(R.bnf,c[1])*abs(R.bnf.disc),   /* level */
		if(R.bnf.r1==0,[0,1],vecsort(c[2])), /* gamma factor shifts */
    0  /* whether or not cuspidal (determined below) */
	];
	for(i=1,nprimes,
		p=prime(i);
		P=idealprimedec(R.bnf,p);
		L[i]=[];
		for(j=1,length(P),
			if(idealval(R.bnf,c[1],P[j])==0,
				a=dot(chi,bnrisprincipal(R,P[j],0),R.clgp[2]);
				L[i]=concat(L[i],if(P[j].f==2,[a/2,(a+1)/2],a));
			);
		);
		/* the associated modular form is cuspidal if and
		   only if chi differs from its Galois conjugate */
		if(length(P)==2 && 
		(length(L[i])==1 || (length(L[i])==2 && L[i][1]!=L[i][2])),selberg[3]=1);
		L[i]=vecsort(L[i]);
	);
	[selberg,L]
}

rayclasses(B,nprimes)=
{
	local(absd,sgnd,d,F,ids,q,m,R,c,i,j,k,L,v);
	L=vector(B,q,[]);
	for(absd=1,B,
	forstep(sgnd=-1,1,2,
		d=sgnd*absd;
		if(isfundamental(d) && d != 1,
			F = bnfinit(X^2-d);
			ids = ideallist(F,floor(B/absd),0);
			/* ideallistarch appears to be broken */
			/*ids=ideallistarch(F,ids,vector(F.r1,j,1));*/
			for(q=1,length(ids),
			for(j=1,length(ids[q]),
				m=ids[q][j].mod;
				if(d>0,m[2]=[1,1]);
				R=bnrinit(F,m,1);
				c=characters(R.clgp[2]);
				for(k=1,length(c),
					if(idealnorm(F,bnrconductorofchar(R,c[k]))==q,
						L[absd*q]=append(L[absd*q],Lfunction(R,c[k],nprimes));
					);
				);
			);
			);
		);
	);
	);
	k=sum(i=1,length(L),length(L[i]));
	v=vector(k);
	i=0;
	for(q=1,length(L),
	for(j=1,length(L[q]),
		i++;
		v[i]=[L[q][j][1][1],concat([L[q][j][1][2]/2],L[q][j][2])];
	);
	);
	v
}

nebentypus(L)=
{
	local(N,phi,v,z,f,t,res);
	N=L[1];
	phi=eulerphi(N);
	v=L[2][2..#L[2]];
	z=apply(x->lift(x),znstar(N)[3]);
	res=[];
	for(i=1,#z,
		f=factor(z[i]);
		t=sum(j=1,#f[,1],vecsum(v[primepi(f[j,1])])*f[j,2]);
		t-=truncate(t);
		t*=phi;
		res=concat(res,[[z[i],t]]);
	);
	res
}

conductoratp(chi,N,p)=
{
	local(e,phi,z,parity,t);
	e=valuation(N,p);
	if(p==2,
		if(e<2,return(0));
		z=znlog(chinese(Mod(-1,2^e),Mod(1,N/2^e)),idealstar(,N));
		parity=sum(i=1,#z,z[i]*chi[i][2])/eulerphi(N)*2%2;
		z=znlog(chinese(Mod(5,2^e),Mod(1,N/2^e)),idealstar(,N));
		t=sum(i=1,#z,z[i]*chi[i][2])/eulerphi(N)*2^(e-2)%2^(e-2);
		if(t==0,return(2*parity));
		return(e-valuation(t,2));
	,
		phi=eulerphi(p^e);
		z=znlog(chinese(znprimroot(p^e),Mod(1,N/p^e)),idealstar(,N));
		t=sum(i=1,#z,z[i]*chi[i][2])/eulerphi(N)*phi%phi;
		if(t==0,return(0));
		return(e-valuation(t,p));
	);
}

avalue(chi,N,p,g)=
{
	local(e,phi,z);
	e=valuation(N,p);
	phi=eulerphi(p^e);
	g=Mod(g,p^e);
	z=znlog(chinese(g,Mod(1,N/p^e)),idealstar(,N));
	sum(i=1,#z,z[i]*chi[i][2])/eulerphi(N)*phi%phi
}

twist(L,g,a)=
{
	local(res,p,z);
	res=vector(#L);
	for(i=1,#res,
		p=if(i==1,-1,prime(i-1));
		z=znlog(p,g);
		if(type(z)=="t_VEC",
			res[i]=[];
		,
			z*=a;
			res[i]=vecsort(apply(x->x+z-truncate(x+z),L[i]));
		);
	);
	res
}

minimalatp(v,j,p)=
{
	local(N,e,chi,s,g,phi,flag,a,tchi,L);
	N=v[j][1];
	e=valuation(N,p);
	chi=nebentypus(v[j]);
	s=conductoratp(chi,N,p);
	if(e==s,return(1));
	if(e<2*s,return(0));
	if(e%2,return(1));
	if(p==2,return(e==2||e==2*s));

	g=znprimroot(p^e);
	phi=eulerphi(p^(e/2));
	for(i=1,j-1,
		flag=0;
		if(e==2&&v[i][1]==N/p^2,
			a=avalue(chi,N,p,g)/p^(e/2);
			flag=1;
		);
		if(v[i][1]==N/p^(e/2),
			tchi=nebentypus(v[i]);
			if(conductoratp(tchi,v[i][1],p)==e/2,
				a=avalue(chi,N,p,g)/p^(e/2)-avalue(tchi,v[i][1],p,g);
				flag=1;
			);
		);
		if(flag,
			a%=phi;
			if(a%2==0&&a%p,
				print("N="N", p="p", e="e", a="a);
				a/=2;
				L=twist(v[i][2],Mod(g,p^(e/2)),a/phi);
				if(L==v[j][2],print("line 1 reached");return(0));
				L=twist(v[i][2],Mod(g,p^(e/2)),a/phi+1/2);
				if(L==v[j][2],print("line 2 reached");return(0));
			);
		);
	);
	1
}

minimal(v,j)=
{
	local(f);
	f=factor(v[j][1])[,1];
	for(i=1,#f,
		if(!minimalatp(v,j,f[i]),return(0));
	);
	1
}

go(B,nprimes,filename)=
{
	local(v,N,parity,chi);
	v=rayclasses(B,nprimes);
	v=select(x->vecsum(x[2][1])*2%2==0,v); \\ weight 0 forms only
	write(filename, "struct{int cond,parity,val[nPmax+2][2];}dihedral_list[]={");
	for(i=1,#v,
		N=v[i][1];
		parity=vecsum(v[i][2][1]);
		if(minimal(v,i),
			chi=nebentypus(v[i]);
			write1(filename,"{"N","parity",{{"chi[1][1]","chi[1][2]"}");
			for(j=2,#chi,
				write1(filename,",{"chi[j][1],","chi[j][2]"}");
			);
			write(filename,"}},");
		);
	);
	write(filename,"{0}};");
}

go(3000,500,"dihedral.c");
