/* dho.c solution of applied dynamical systems problem 1.7
Carl Dettmann, 10/2/15 using gsl example code
GPL license: http://www.gnu.org/licenses/
*/

#include <stdio.h>
#include <gsl/gsl_errno.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_odeiv2.h>

/* original function (damped harmonic oscillator) */

int
func (double t, const double y[], double f[],
      void *params)
{
  double alf = *(double *)params;
  f[0] = y[1];
  f[1] = -y[0] - alf*y[1];
  return GSL_SUCCESS;
}

/* Function for Poincare section: see section 2.2 of notes */

int
poin (double x, const double y[], double f[],
      void *params)
{
  double alf = *(double *)params;
  f[0] = 1.0/y[1];
  f[1] = (-x - alf*y[1])/y[1];
  return GSL_SUCCESS;
}


int
main (void)
{
  double alf = 0.01;
  gsl_odeiv2_system sys1 = {func, NULL, 2, &alf};
  gsl_odeiv2_system sys2 = {poin, NULL, 2, &alf};

/* NULL replaces un-needed Jacobian here (depends on algorithm used) */

  gsl_odeiv2_driver * d1 = 
    gsl_odeiv2_driver_alloc_y_new (&sys1, gsl_odeiv2_step_rk8pd,
				  1e-10, 1e-10, 0.0);

  gsl_odeiv2_driver * d2 =
    gsl_odeiv2_driver_alloc_y_new (&sys2, gsl_odeiv2_step_rk8pd,
                                  1e-10, 1e-10, 0.0);

  int i;
  double t = 0.0, t1 = 200.0, t_prev=0.0;
  double y[2] = { 2.0, 0.0 };
  double y_prev[2] = {2.0, 0.0 };
  double tmp;

  for (i = 1; i <= 10000; i++)
    {
      double ti = i * t1 / 10000.0;
      int status = gsl_odeiv2_driver_apply (d1, &t, ti, y);

      if (status != GSL_SUCCESS)
	{
	  printf ("error in func, return value=%d\n", status);
	  break;
	}
      if ((y[0]-1.0)*(y_prev[0]-1.0)<0)   /* Detect crossing of Poincare section */
         {
          if(y_prev[0]-1.0<0)
          {                    
             /* If x>1 go back a step; integrator refuses to run backwards */
             y[0]=y_prev[0];
             y[1]=y_prev[1];
             t=t_prev;
          }
          tmp=t;
	  t=y[0];
          y[0]=tmp;
          int status = gsl_odeiv2_driver_apply (d2, &t, 1, y);

          if (status != GSL_SUCCESS)
        {
          printf ("error in poin, return value=%d\n", status);
          break;
        }
       
          tmp=t;
          t=y[0];
          y[0]=tmp;

          printf ("t=%.5g x=%.5g y=%.5g\n", t, y[0], y[1]);
        }

	y_prev[0]=y[0];
        y_prev[1]=y[1];
        t_prev=t;
    }

  gsl_odeiv2_driver_free (d1);
  gsl_odeiv2_driver_free (d2);
  return 0;
}
