#!/usr/bin/perl
## CONVERTS PHASED IMPUTE2 OUTPUT TO CHROMOPAINTER-STYLE INPUT FILES
use Switch;
use strict;

sub help {
print("CONVERTS MSMS OUTPUT TO CHROMOPAINTER-STYLE INPUT FILES\n");
print("*** USE THE -f OPTION for fineSTRUCTURE via ChromoPainter ***\n");
print("usage:   perl msms2cp.pl <options> msmsoutput.txt output_filename_prefix\n");

die "\n";
}

my $verbose=0;
my $MSMSinfile="";
my $outfilePRE="";
my $argon=0;
my $cpversion1=0;
my $snpfactor=1000000;

for (my $i = 0; $i < scalar(@ARGV); ++$i){
	if(@ARGV[$i] eq "-c1"){
	    $cpversion1=1;
	}elsif(@ARGV[$i] eq "-n"){
	    $snpfactor=@ARGV[++$i];
	}elsif(@ARGV[$i] eq "-v"){
	    $verbose=1;
	}else{
	    switch($argon){
		case 0 {$MSMSinfile="$ARGV[$i]";}
		case 1 {$outfilePRE="$ARGV[$i]";}
		else {
		    help();
		}
	    }
	    $argon++;
	}
}


if($outfilePRE eq "" || $argon != 2) {help();}


my $nsnps=0;
my $nhaps=0;
my $totalINDS=0;
my @snplocs;
## PROGRAM:
## (II) GET NUMBER OF SITES AND INDS: 
open(IN,"$MSMSinfile");
open(OUT,">${outfilePRE}.phase");
my $starteddata=0;

while(<IN>)
{
    chomp;
    my $line=$_;
    my @linearray;
    my $start=substr($line,0,2);
    if($start eq "ms"){
	@linearray=split(/\s+/,$line);
	$nhaps=$linearray[3];
	$totalINDS=$nhaps/2;
	if($verbose){print "Detected $nhaps haplotypes ($totalINDS inds)\n";}
    }elsif($start eq "se"){
	@linearray=split(/\s+/,$line);
	$nsnps=$linearray[1];
	if($verbose) {print "Detected $nsnps SNPs\n";}
    }elsif($start eq "po"){
	@snplocs=split(/\s+/,$line);
	shift(@snplocs);
	for(my $i=0;$i<scalar(@snplocs);++$i){
	    $snplocs[$i]*=$snpfactor;
	    if($snplocs[$i] <= $snplocs[$i-1]){
		$snplocs[$i]=$snplocs[$i-1]+1;
	    }
#	    print "SNP $i location $snplocs[$i]\n";
	}
	if($cpversion1){
	    print OUT "0\n";
	    print OUT "$totalINDS\n";
	}else{
	    print OUT "$nhaps\n";
	}
	print OUT "$nsnps\n";
	print OUT "P @snplocs\n";
	if($cpversion1){
	    for (my $j=0; $j < $nsnps; $j+=1)
	    {
		print OUT "S";
	    }
	    print OUT "\n";
	}	
	$starteddata=1;
    }elsif(($start eq "//")|| ($start eq "")){
	# Do nothing
	if($verbose) {print "Ignoring line:$line\n";}
    }elsif($starteddata){
	print OUT "$line\n";
	
    }
}
close(IN);
close(OUT);




