#include "ChromoPainterDonors.h"

struct donor_t *createDonors(struct infiles_t *Infiles,struct ids_t *Ids,struct data_t *Data,struct param_t *Par) {
  struct donor_t *Donors=malloc(sizeof(struct donor_t)); 
  if(Par->donorlist_find && Par->idfile_find){
    fprintf(Par->out,"Error: The donor list (-f) and ID list (-t) options are not currently working in this version of chromopainter.  Use one only.\n");
    stop_on_error(1,Par->errormode,Par->err);	
  }
 
  if(Par->donorlist_find){// donor mode
    readDonorPops(Donors,Ids,Infiles,Data,Par);
    if(Par->vverbose) fprintf(Par->out,"Found %i donor populations in donor file\n",Donors->ndonorpops);
  }else{// all-vs-all mode
    if(Par->vverbose) fprintf(Par->out,"Creating Donors in all-vs-all mode\n");
    populateDonors(Donors,Ids,Data,Par);
  }
  Donors->allvsall =Data->allvsall;
  Donors->selfpop = Par->condition_recipient_inds_find;
  
  if (Par->end_val==0) Par->end_val=Data->recipinds;
  if(Par->end_val-1 > Data->nhapstotal/Data->hapsperind) {
    fprintf(Par->out,"Donors::createDonors error: Requested a final individual (%d, via -a?) greater than the number of individuals (%d) provided!\n",Par->end_val-1, Data->nhapstotal/Data->hapsperind);
    stop_on_error(1,Par->errormode,Par->err);
  }
  return(Donors);
}

int getNpops(struct infiles_t *Infiles,struct param_t * Par) {
  ////////////////////////////////////////////////
  // open third file (to get information on donor population hap numbers)
  // returns -1 if the file is not specified
  char line[2047];
  int ndonorpops=-1;
  if (Par->donorlist_find) {
    if(Par->verbose) fprintf(Par->out,"Donors::getNpops Opening Donor list %s\n",Infiles->donorlist);
    if(!openDonorlist(Infiles,Par->out)){ fprintf(Par->out,"Donors::getNpops error opening %s\n",Infiles->donorlist); stop_on_error(1,Par->errormode,Par->err);}
    while(!feof(Infiles->fdonorlist))
      {
	if(fgets(line,2047,Infiles->fdonorlist)==NULL &&!feof(Infiles->fdonorlist)){printf("Donors::getNpops Error reading %s",Infiles->donorlist);stop_on_error(1,Par->errormode,Par->err);};
	ndonorpops=ndonorpops+1;
      }
    closeDonorlist(Infiles);
    if(Par->vverbose) fprintf(Par->out,"Donors::getNpops Succesfully counted %i donors\n",ndonorpops);
  }
  return(ndonorpops);
}
  /////////////////////////////////////////////
  // 

//&Donors->reciplabels,&Donors->donorlabels,&Donors->ndonorhaps,&Donors->ndonorprobs,&Donors->ndonormutrates
//char *** p_reciplabels,char *** p_donorlabels, int ** p_ndonorhaps,double ** p_ndonorprobs, double ** p_ndonormutrates
void readDonorPops(struct donor_t *Donors,struct ids_t *Ids,struct infiles_t *Infiles,struct data_t *Data,struct param_t *Par) {
  double totaldonorprobs=0;
  int i=0,j=0;
  int recipon=0;
  char line[2047];
  char *step;
  Donors->allvsall=Par->all_versus_all_ind;

  if (!Par->donorlist_find) {
    fprintf(Par->out,"Donors::readDonorPops Logic error: we should not read donor pops when not using the donor pops file!\n"); stop_on_error(1,Par->errormode,Par->err);
  }

  /// Get the number of donor populations, and create all variables needed
  if(Par->donorlist_find==1 && Par->all_versus_all_ind ==1) {
    // The number of donor pops is determined by all-vs-all mode
    populateDonors(Donors,Ids,Data,Par);
  }else {
    Donors->nrecipinds=(int) ceil(Data->nind);
    Donors->ndonorpops=getNpops(Infiles,Par);
    if(Par->condition_recipient_inds_find==1) Donors->ndonorpops++; // self
  // alocate memory
    Donors->ndonorhaps = malloc(Donors->ndonorpops * sizeof(int));
    Donors->donorlabels =malloc(Donors->ndonorpops * sizeof(char *));
    Donors->reciplabels =malloc(Donors->nrecipinds * sizeof(char *));
    for(i=0;i<Donors->ndonorpops;i++)
      Donors->donorlabels[i]=malloc(2047*sizeof(char));
    for(i=0;i<Donors->nrecipinds;i++)
      Donors->reciplabels[i]=malloc(2047*sizeof(char));
    if (Par->prior_donor_probs_ind==1) {
      Donors->ndonorprobs = malloc(Donors->ndonorpops * sizeof(double));
    }
    if (Par->mutation_rate_ind==1) {
      Donors->ndonormutrates = malloc(Donors->ndonorpops * sizeof(double));
    }
  }

  if(Par->vverbose) {
    fprintf(Par->out,"Donors::readDonorPops created %i individuals, %i donor populations\n",Donors->nrecipinds,Donors->ndonorpops);
  }

  // Now process them
  if(!openDonorlist(Infiles,Par->out)) { fprintf(Par->out,"Donors::readDonorPops error opening %s\n",Infiles->donorlist); stop_on_error(1,Par->errormode,Par->err);}
  int ndonors = 0; // number of assigned donor haplotypes
  
  //  int nlines=Donors->ndonorpops;
  //  if(Donors->allvsall) nlines=4;
  //for (i=0; i < nlines; i++)
  i=-1;
  while(!feof(Infiles->fdonorlist))
    {
      printf ("Reading line %d\n",i);
      if(fgets(line,2047,Infiles->fdonorlist)==NULL){continue;}
      if(line[0]=='\n') continue;
      i++;
      if(i>Donors->ndonorpops){
	printf("Donors::readDonorPops error: More populations in file than expected!\n");
	stop_on_error(1,Par->errormode,Par->err);
      }

      step=line;
      if(Par->vverbose) {
	printf("Donors::readDonorPops line %i:%s\n",i,line);
      }
      
      reading(&step,"%s",Donors->donorlabels[i]);
      reading(&step,"%d",&Donors->ndonorhaps[i]);
      ndonors+=Donors->ndonorhaps[i];
      if(Par->vverbose) {
	printf("Donors::readDonorPops donor label(%d)=%s, nhaps=%d\n",i,Donors->donorlabels[i],Donors->ndonorhaps[i]);
      }
      for(j=0;j<Donors->ndonorhaps[i]/Data->hapsperind;j++){
	sprintf(Donors->reciplabels[recipon],"%s%d",Donors->donorlabels[i],j+1);
	if(Par->vverbose) {
	  fprintf(Par->out,"Donors::readDonorPops Recipient %i label %s\n",recipon, Donors->reciplabels[recipon]);
	}
	recipon++;
      }
      if(Par->vverbose) {
	printf("Donors::readDonorPops Donor %i label %s nhaps %d\n",i, Donors->donorlabels[i],Donors->ndonorhaps[i]);
      }

      if (Par->prior_donor_probs_ind==1) // there should be another column of donors
	{
	  reading(&step,"%lf",&Donors->ndonorprobs[i]);
	  if (Donors->ndonorprobs[i]<=0.0000000000000001)
	    {
	      fprintf(Par->out,"Donors::readDonorPops Donor copying probabilities must be > 0. Exiting...\n");
	      stop_on_error(1,Par->errormode,Par->err);
	    }
	  totaldonorprobs=totaldonorprobs+Donors->ndonorprobs[i];
	}
      if (Par->mutation_rate_ind==1) // there should be another column of mutations
	{
	  reading(&step,"%lf",&Donors->ndonormutrates[i]);
	  if (Donors->ndonormutrates[i]>1)
	    {
	      fprintf(Par->out,"Donors::readDonorPops Donor mutation (emission) probabilities must be <= 1 (use a negative number to specify default). Exiting...\n");
	      stop_on_error(1,Par->errormode,Par->err);
	    }
	}
    }

  while(recipon<Donors->nrecipinds) {
    sprintf(Donors->reciplabels[recipon],"IND%d",recipon-ndonors/Data->hapsperind+1);
    if(Par->vverbose) {
      fprintf(Par->out,"Donors::readDonorPops: Assigning recipient individual %d the label %s\n",recipon,Donors->reciplabels[recipon]);
    }
    recipon++;
  }

  closeDonorlist(Infiles);
  /// Finished reading file

  // Correct the population assignments if we are in all vs all mode with donor names
  if(Par->all_versus_all_ind){
    // In all-vs-all population  donor pop  mode we need to convert from populations to individuals
    // The donor population names are in reciplabels
    // reverse order so we don't mess up the population details

    // Not tested for prior_donor_probs and mutation_rate_ind!
    int kk=i,k=Donors->ndonorhaps[kk]/Data->hapsperind; // k=haplotype on, kk= popon
    for(j=Donors->nrecipinds-1;j>=0;j--){
      k--;
      fprintf(Par->out,"Individual %d from population %d with number %d\n",j,kk,k);
      Donors->donorlabels[j] = Donors->reciplabels[j];
      Donors->ndonorhaps[j] = Data->hapsperind;
      if(Par->prior_donor_probs_ind==1) {Donors->ndonorprobs[j]= Donors->ndonorprobs[kk];}
      if(Par->mutation_rate_ind==1) {Donors->ndonormutrates[j]=Donors->ndonormutrates[kk];}
      if(k<=0) {
	kk--; 
	if(j>0 && kk<0) {printf("ERROR: Negative population access requested. Report this bug\n"); exit(1);}
	if(kk>=0) k=Donors->ndonorhaps[kk]/Data->hapsperind;
      }
    }

  }else{
    Par->start_val=ndonors/Data->hapsperind;
    Par->end_val=Donors->nrecipinds;
    fprintf(Par->out,"TEST: Assigning range to %d - %d\n",Par->start_val,Par->end_val);
  }

  // Now we sanity check and tidy up the populations
  if (Par->prior_donor_probs_ind==1) {// we have donor probs; do they check out?
    if (((totaldonorprobs > 1.00001) || (totaldonorprobs < 0.99999)) && (Par->condition_recipient_inds_find==0))
    {
      fprintf(Par->out,"Donors::readDonorPops Probabilities across all donors in %s does not sum to 1.0 (instead sums to %lf)! Exiting....\n",Infiles->donorlist,totaldonorprobs);
      stop_on_error(1,Par->errormode,Par->err);
    }
    if (((totaldonorprobs >= 1) || (totaldonorprobs <=0)) && (Par->condition_recipient_inds_find==1))
      {
	printf("Donors::readDonorPops You've specified that there should be some prob of copying from your own pop, but probabilities across all donors in %s do not sum to something >0 and <1.0 (%lf)! Exiting....\n",Infiles->donorlist,totaldonorprobs);
	stop_on_error(1,Par->errormode,Par->err);
      }
    if(Par->condition_recipient_inds_find==1) {// add the last (self) population
      Donors->ndonorprobs[Donors->ndonorpops-1]= 1.0-totaldonorprobs; // probability of receiving from own population
    }
  }// end if we hve donor probs

  if(Par->condition_recipient_inds_find==1 && Par->mutation_rate_ind==1){// if we have mutation probs
    Donors->ndonormutrates[Donors->ndonorpops-1] =Par->mut_rate_self;
  }
  if(Par->condition_recipient_inds_find==1) {
    strcpy(Donors->donorlabels[Donors->ndonorpops-1],"Self");
    Donors->ndonorhaps[Donors->ndonorpops-1]=Data->nhapstotal - ndonors - Data->hapsperind;
  }
  /*  if(Par->donorlist_find==1 && Par->all_versus_all_ind ==1) { // Self in -c mode
    Donors->ndonorhaps[ndonorpops-1]-=(2-Par->haploid_ind);
    }*/
  if(Par->vverbose) {
    fprintf(Par->out,"Donors::readDonorPops Created %i donor populations:\n",Donors->ndonorpops);
  }
  for(i=0;i<Donors->ndonorpops;i++){
    fprintf(Par->out,"  %i: %s, %i\n",i+1,Donors->donorlabels[i],Donors->ndonorhaps[i]);
  }
  Donors->nrecipinds = recipon;
}

void populateDonors(struct donor_t *Donors,struct ids_t *Ids,struct data_t *Data,struct param_t *Par) {
  // Create donor populations in all-vs-all mode
  if (!Par->all_versus_all_ind){
    fprintf(Par->out,"Logic error: we should not create donor labels when not in all-vs-all mode!\n"); stop_on_error(1,Par->errormode,Par->err);
  }
  int i;
  //  int ndonorpops=Data->condhaps/(2-Par->haploid_ind);
  Donors->allvsall=Par->all_versus_all_ind;
  Donors->ndonorpops=(Data->condhaps)/(2-Par->haploid_ind);
  Donors->nrecipinds=Donors->ndonorpops+1;
  if(Donors->nrecipinds != Ids->nind_inc){
    fprintf(Par->out,"Mismatch between the number of individuals in the data (%d) and the ID file (%d); terminating!\n",Donors->nrecipinds,Ids->nind_inc);
    stop_on_error(1,Par->errormode,Par->err);
  }
  Donors->reciplabels=malloc(Donors->nrecipinds* sizeof(char *));
  Donors->donorlabels=malloc(Donors->nrecipinds * sizeof(char *));
  Donors->ndonorhaps = malloc(Donors->nrecipinds * sizeof(int));
  Donors->ndonorprobs = malloc(Donors->nrecipinds * sizeof(double));
  
  // alocate memory
  // NOTE: the self population is a donor here
  for(i=0;i<Donors->ndonorpops+1;i++) {
    Donors->donorlabels[i]=malloc(2047*sizeof(char));
    Donors->reciplabels[i]=malloc(2047*sizeof(char));
  }

  int ii=-1;
  for(i=0;i<Donors->ndonorpops+1;i++){
    Donors->ndonorhaps[i]=Data->hapsperind;
    do{
      ++ii;
    }while(Ids->include_ind_vec[ii]==0);
    strcpy(Donors->donorlabels[i],Ids->id[ii]);
    strcpy(Donors->reciplabels[i],Ids->id[ii]);
    //    sprintf(Donors->donorlabels[i],"IND%i",i+1);
    //    sprintf(Donors->reciplabels[i],"IND%i",i+1);
    if(Par->vverbose) fprintf(Par->out,"populateDonors: Assigned pop %i the name %s with %i haplotype(s)\n",i+1,Donors->donorlabels[i],Donors->ndonorhaps[i]);
  }
}    




void clearDonors(struct donor_t *Donors,struct param_t *Par) 
{
  if(Donors==NULL) return;
  //* for some reason this is buggy?
  /*int i;
  for(i=0;i<Donors->ndonorpops;i++)
    free(Donors->donorlabels[i]);
  for(i=0;i<Donors->nrecipinds;i++)
  free(Donors->reciplabels[i]);*/

  free(Donors->donorlabels);
  free(Donors->reciplabels);

  free(Donors->ndonorhaps);
  if (Par->prior_donor_probs_ind==1)  free(Donors->ndonorprobs);
  if (Par->mutation_rate_ind==1)   free(Donors->ndonormutrates);
}
