#ifdef __cplusplus
extern "C" {
#endif

  // Start the header
#ifndef CHROMOPAINTERINFILES_H
#define CHROMOPAINTERINFILES_H

#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <string.h>

#include "zlib.h"
#include "ChromoPainterError.h"

  struct infiles_t {
    char *recmap; // was filename
    char *phase; // was filenameGEN
    char *donorlist; // was filenameDONORLIST
    char *id; // id file
    int usingFile[4];// 0 if we are not using each inputfile (phase,rec,donor)
    int fopen[4];// 0 if inputfile is open
    FILE *frecmap; // rec file 
    FILE *fphase; // Phase file , was fd
    FILE *fdonorlist; // Donor file , was fd3
    FILE *fid; // Id file, was fd4
  };

  struct infiles_t *defaultInfiles();

  void setRecmap(char *filename, struct infiles_t *Files);
  void setPhase(char *filenameGEN, struct infiles_t *Files);
  void setDonorlist(char *filenameDONORLIST, struct infiles_t *Files);
  void setIdfile(char *filenameID, struct infiles_t *Files);

  int openPhase(struct infiles_t *Files, FILE *mainout); // open the phase file (if it is supposed to be used)
  int openRecmap(struct infiles_t *Files, FILE *mainout); // open the recmap file (if it is supposed to be used)
  int openDonorlist(struct infiles_t *Files, FILE *mainout); // open the donorlist file (if it is supposed to be used)
  int openId(struct infiles_t *Files, FILE *mainout); // open the ID file (if it is supposed to be used)

  void closePhase(struct infiles_t *Files); // close the phase file
  void closeRecmap(struct infiles_t *Files); // close the phase file
  void closeDonorlist(struct infiles_t *Files); // close the phase file
  void closeId(struct infiles_t *Files); // close the id file

  void closeInfiles(struct infiles_t *Files); // close all input files
  int validateIniles(struct infiles_t *Files, FILE *mainout); // check files are open

  void freeInfiles(struct infiles_t *Files); // free (and close if necessary) infiles

#endif
  // End the header

#ifdef __cplusplus
}
#endif
