#ifndef INFEXTRACT4_H
#define INFEXTRACT4_H
#include <vector>
#include "state.h"
#include "data.h"
#include "rng.h"
#include "node.h"
#include "fsxml.h"

namespace fines
{

/**
    @brief Inference algorithm: extraction of posterior distribution
*/
class InfExtract4
{
public:
    InfExtract4(gsl_rng * rng,Data *d,FsXml *fs,std::vector<double> bvec,double a,int betamodel=BETAMOD_CONST,double corfactor=1.0,int v=0);///<Constructor 
    ~InfExtract4();
    inline std::vector<double> getPosteriors(){return(posteriors);};///< gets the posterior probabilities
protected:
    Data *data;
    State *state;
    int verbose;
    std::vector<double> posteriors;
    long counts;
    gsl_rng * rng;
};

} // end namespace fines
#endif
