function effectiveSampleSize = computeess( logParticleWeights, nParticles )
    % Compute the effective sample size (ESS) for a sample of particles
    % from their (log) weights.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % logParticleWeights - column vector of weights carried by each
    % particle, in log domain.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 16.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if size(logParticleWeights, 2) ~= 1,
        error('logParticleWeights should be a column vector!')
    end
    if any(logParticleWeights > 0),
        error('logParticleWeights should be a vector of log probabilities!')
    end
    if nargin < 2,
        nParticles = length(logParticleWeights);
    else
        if length(logParticleWeights) ~= nParticles,
            error('logParticleWeights must have nParticles elements!')
        end
    end
    
    % Compue coefficient of variation for sample.
    coeffOfVariation = sum((nParticles * exp(logParticleWeights) - 1) .^ 2) / nParticles;
    effectiveSampleSize = nParticles / (1 + coeffOfVariation);
end