function D = computeeuclideandistance( A, B )
    % Compute Euclidean distance between each pair in two sets of points in
    % an N dimensional space.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % A, B - matrices with N rows and M columns, where M is the dimension.
    %
    % D - column vector of corresponding Euclidean distances.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 30.09.2014 - created, coded.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if nargin < 2,
        error('Insufficient arguments!')
    end
    if ~isequal(size(A), size(B))
        error('Inputs must be the same size!')
    end

    D = sqrt(sum((A - B) .^ 2, 2));
end