function [ logLikelihood ] = computelikelihood(ModelSpec, SpikeTrainData, PositionData, ModelParams, isForPartialMl, jumpTimes, trajectoryMatBinInds, startTime, endTime, nStates, maxNTransitions, nSamples, interjumpIntervalsArray)
    % Call model likelihood functions for supplied data and model
    % specification.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % ModelParams - a scalar struct, i.e. paramater values (point estimates
    % or a sample) on one state space dimension.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 28.01.2015 - created, copied (refactored) from various other
    % functions that used this code inline.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if ModelSpec.spikeTrainModelIndicator > 0,
        % Compute spike trains likelihood.
        if nargin == 13,
            if ModelSpec.modelIndicator == 1,
                if ModelSpec.spikeTrainModelIndicator == 1,
                    logLikelihood = computediscretetimespiketrainslikelihood( SpikeTrainData.discreteSpikeTrainsMat, [], ModelParams.logSpikeRate, ModelParams.logNonspikeRate, ModelSpec.spikeTrainModelIndicator, interjumpIntervalsArray{1}(end), trajectoryMatBinInds, maxNTransitions, nSamples );
                elseif ModelSpec.spikeTrainModelIndicator == 2,
                    logLikelihood = computediscretetimespiketrainslikelihood( SpikeTrainData.discreteSpikeTrainsMat, SpikeTrainData.logPoissonLikelihoodFactor, ModelParams.logSpikeRate, [], ModelSpec.spikeTrainModelIndicator, interjumpIntervalsArray{1}(end), trajectoryMatBinInds, maxNTransitions, nSamples );
                end
            elseif ModelSpec.modelIndicator == 2,
                logLikelihood = computespiketrainslikelihood( SpikeTrainData.spikeTimesArray, ModelParams.logSpikeRate, jumpTimes, trajectoryMatBinInds, endTime, interjumpIntervalsArray, maxNTransitions, nSamples, SpikeTrainData.nSpikeTrains );
            end
%             logLikelihood = computespiketrainscountlikelihood( SpikeTrainData.spikeTimesArray, ModelParams.logSpikeRate, jumpTimes, trajectoryMatBinInds, endTime, interjumpIntervalsArray, maxNTransitions, nSamples, SpikeTrainData.nSpikeTrains );
        else
            if ModelSpec.modelIndicator == 1,
                if ModelSpec.spikeTrainModelIndicator == 1,
                    logLikelihood = computediscretetimespiketrainslikelihood( SpikeTrainData.discreteSpikeTrainsMat, [], ModelParams.logSpikeRate, ModelParams.logNonspikeRate, ModelSpec.spikeTrainModelIndicator, interjumpIntervalsArray{1}(end), trajectoryMatBinInds );
                elseif ModelSpec.spikeTrainModelIndicator == 2,
                    logLikelihood = computediscretetimespiketrainslikelihood( SpikeTrainData.discreteSpikeTrainsMat, SpikeTrainData.logPoissonLikelihoodFactor, ModelParams.logSpikeRate, [], ModelSpec.spikeTrainModelIndicator, interjumpIntervalsArray{1}(end), trajectoryMatBinInds );
                end
            elseif ModelSpec.modelIndicator == 2,
                logLikelihood = computespiketrainslikelihood( SpikeTrainData.spikeTimesArray, ModelParams.logSpikeRate, jumpTimes, trajectoryMatBinInds, endTime );
            end
%             logLikelihood = computespiketrainscountlikelihood( SpikeTrainData.spikeTimesArray, ModelParams.logSpikeRate, jumpTimes, trajectoryMatBinInds, endTime );
        end

        % Multiply by position likelihood.
        if ModelSpec.positionModelIndicator > 0,
            if nargin >= 12,
                if ModelSpec.modelIndicator == 2,
                    logLikelihood = logLikelihood + computepositionlikelihood( PositionData, ModelSpec.positionJitterModelIndicator == 3, isForPartialMl, ModelParams.asympMeanPosInd, ModelParams.driftRate, ModelParams.posCov, jumpTimes, trajectoryMatBinInds, endTime, ModelSpec.randomWalkState, maxNTransitions, nStates, nSamples, [], startTime );
                else
                    try
                        logLikelihood = logLikelihood + computepositionlikelihooddiscretetime( PositionData, ModelSpec.positionJitterModelIndicator == 3, isForPartialMl, ModelParams.asympMeanPosInd, ModelParams.driftRate, ModelParams.posCov, [], jumpTimes, trajectoryMatBinInds, endTime, maxNTransitions, nStates, nSamples, startTime );
                    catch err
%                         size(posLogLikelihood1)
%                         size(posLogLikelihood)
                        size(logLikelihood)
                        size(ModelParams.posCov)
%                         ModelParams.nParticlesThisBlock
                        startTime
                        endTime
                        rethrow(err);
                    end
                end
            end
        end

    elseif ModelSpec.positionModelIndicator > 0,
        % Compute position likelihood.
        if nargin >= 12,
            if ModelSpec.modelIndicator == 2,
                logLikelihood = computepositionlikelihood( PositionData, ModelSpec.positionJitterModelIndicator == 3, isForPartialMl, ModelParams.asympMeanPosInd, ModelParams.driftRate, ModelParams.posCov, jumpTimes, trajectoryMatBinInds, endTime, ModelSpec.randomWalkState, maxNTransitions, nStates, nSamples, [], startTime );
            else
                logLikelihood = computepositionlikelihooddiscretetime( PositionData, ModelSpec.positionJitterModelIndicator == 3, isForPartialMl, ModelParams.asympMeanPosInd, ModelParams.driftRate, ModelParams.posCov, [], jumpTimes, trajectoryMatBinInds, endTime, maxNTransitions, nStates, nSamples, startTime );
            end
        end
    else
        error('No observations models specified!')
    end

end