function [ logForwardProbVec ] = forwardfilteringsinglestepregular( logForwardProbVecPrev, logLikelihoodVec, logTransitionMat )
    % Perform a single step of the forward accumulation recursions, when
    % the transition matrix is of the regular form (potentially has nonzero
    % values everywhere). We potentially have multiple processes/particles
    % to compute the forward probabilities for simultaneously.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % logForwardProbVec will be a 3D matrix, but the first dimension is of
    % size 1 (time).
    %
    % logForwardProbVecPrev is the same, and contains the probabilities
    % from the previous timestep.
    %
    % logLikelihoodVec has the same structure.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 15.10.2014 - copied from old version. Removed requirement of
    % transitionMat to be supplied in permuted form - this is now done in
    % the function.
    % 17.10.2014 - removed requirement for logLikelihood to be negative -
    % not necessary with contious observations.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if nargin ~= 3,
        error('Incorrect number of arguments!')
    end
    if ~isequal(size(logLikelihoodVec), size(logForwardProbVecPrev)),
        error('Size of logLikelihoodVec and logForwardProbVecPrev must match!')
    end
    if size(logTransitionMat, 3) ~= size(logLikelihoodVec, 3),
        error('n pages of logTransitionMat must match that of other data structures!')
    end
    if size(logTransitionMat, 1) ~= size(logLikelihoodVec, 2),
        error('n states of logTransitionMat must match that of other data structures, and source states must be in dimension 2, destination states in dimension 4!')
    end
    if size(logTransitionMat, 2) ~= size(logLikelihoodVec, 2),
        error('n states of logTransitionMat must match that of other data structures, and source states must be in dimension 2, destination states in dimension 4!')
    end
    if any(any(any(logTransitionMat > 0))),
        error('logTransitionMat contains log probabilities greater than 0!')
    end
%     if any(any(logLikelihoodVec > 0)),
%         error('logLikelihoodVec contains log probabilities greater than 0!')
%     end
    
    % Multiply source states' probabilities.
    forwardInter =  bsxfun(@plus, permute(logTransitionMat, [4, 1, 3, 2]), logForwardProbVecPrev);
    % Take account of observations via the likelihood.
    logForwardProbVec = logLikelihoodVec + permute(sumlogprobmat(forwardInter, 2), [1, 4, 3, 2]);
end