function normalisedLogDistribution = normaliselogdistributionsmatrix( logDistributionsMatrix, dim )
    % Given an N-dimensional matrix of any size, containing probabilities,
    % normalise a particular dimension.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Note the distributions matrix must be of 'regular' form, i.e. no
    % special handling of sparse structure will be considered.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 14.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if nargin < 2,
        error('Incorrect number of arguments!')
    end
    if (dim > length(size(logDistributionsMatrix))) || (dim < 1),
        error('Invalid dimension!')
    end

    logNormalisingConstants = sumlogprobmat(logDistributionsMatrix, dim);
    if any(isinf(logNormalisingConstants)),
        error('There are all-zero probability distributions in logDistributionsMatrix!')
    end
    normalisedLogDistribution = bsxfun(@minus, logDistributionsMatrix, logNormalisingConstants);
%     if any(isinf(logNormalisingConstants)),
%         sizeOfMat = size(logDistributionsMatrix);
%         repSize = ones([1, length(sizeOfMat)]);
%         repSize(dim) = sizeOfMat(dim);
%         binInds = repmat(isinf(logNormalisingConstants), repSize);
%         normalisedLogDistribution(binInds) = -log(sizeOfMat(dim));
% %         error('There are all-zero probability distributions in logDistributionsMatrix!')
% % sumlogprobmat(normalisedLogDistribution, dim)
%     end
end