function stateSpaceTransformation = formstatespacedimensiontransformation( maxNStates )
    % Form a column vector indexed by 'true' states that contains (and
    % hence maps to) the corresponding number of 'augmented' states.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % maxNStates - the upper limit on the state space dimensions
    % considered: we will form the transformation between all true states
    % and augmented states up to and including this.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 01.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if (rem(maxNStates, 1) ~= 0) || maxNStates < 1,
        error('maxNStates must be a positive integer!')
    end

    statesVec = (1:maxNStates)';
    
    stateSpaceTransformation = statesVec .* (statesVec + 1) / 2;
end