function mazeEdgeCoordsMat = getmazeedgecoords( validPositionsLogMat, yDim, xDim )
    % This function will return the coordinates of line segments that
    % deliminate the valid region of a discretised maze - useful for
    % plotting the maze outline.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % mazeEdgeCoordsMat - matrix with two columns, first storing Y-dim
    % coordinates, second X-dim coordinates. These are the points of the
    % corners of grid squares that lie on the boundary between valid and
    % invalid. Two successive rows wil be adjacent corners; these are
    % followed by a NaN row signifying the start of a new line segment (new
    % edge between valid and invalid.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 30.09.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if nargin < 3,
        yDim = size(validPositionsLogMat, 1);
        xDim = size(validPositionsLogMat, 2);
    end
    
    mazeEdgeCoordsMat = nan([0, 2]);
    
    % Loop over every grid square.
    for x = 1:xDim,
        for y = 1:yDim,
            if validPositionsLogMat(y, x),
                % Look at boundaries.
                if (y == 1) || ~validPositionsLogMat(y - 1, x),
                    mazeEdgeCoordsMat(end + 1, :) = [y - 0.5, x - 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [y - 0.5, x + 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [NaN, NaN];
                end
                if (y == yDim) || ~validPositionsLogMat(y + 1, x),
                    mazeEdgeCoordsMat(end + 1, :) = [y + 0.5, x - 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [y + 0.5, x + 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [NaN, NaN];
                end
                if (x == 1) || ~validPositionsLogMat(y, x - 1),
                    mazeEdgeCoordsMat(end + 1, :) = [y - 0.5, x - 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [y + 0.5, x - 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [NaN, NaN];
                end
                if (x == xDim) || ~validPositionsLogMat(y, x + 1),
                    mazeEdgeCoordsMat(end + 1, :) = [y - 0.5, x + 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [y + 0.5, x + 0.5];
                    mazeEdgeCoordsMat(end + 1, :) = [NaN, NaN];
                end
            end
        end
    end
end