function availableMemory = getmemoryavailable( memorySafetyFactor, unixMemory )
    % Function to compute the amount of free memory (in bytes) available in
    % MATLAB for structures, taking a 'safety factor' into account.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % memorySafetyFactor - positive scalar.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 16.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if ispc,
        [windowsMemory, ~] = memory;
        availableMemory = windowsMemory.MaxPossibleArrayBytes * memorySafetyFactor;
    elseif isunix,
        availableMemory = unixMemory * memorySafetyFactor;
    else
        error('Platform memory check not implemented!')
    end
end