function validPositionsLogMat = linearinterpolationofvalidpositions( validPositionsLogMat, coordsTrajectory )
    % Use linear interpolation on discretised positions to indicate as
    % 'valid' (included in set of positions that are 'visitable') all
    % positions that lie directly between two consecutively visited
    % positions.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Note: sometimes there is more than one path between successively
    % visited positions with equal length and so equal right to be chosen
    % as our interpolation. We go with the path with positions of lowest
    % index (e.g. (1, 2) is chosen over (2, 2) when tracing a route from
    % (1, 1) to (2, 3)).
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 30.09.2014 - copied form old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if nargin < 2,
        error('Insufficient arguments!')
    end
    if size(coordsTrajectory, 2) ~= 2,
        error('coordsTrajectory must have two columnds (discrete Y and X positions)!')
    end
    if ~all(all(islogical(validPositionsLogMat))),
        error('validPositionsLogMat must be a logical matrix!')
    end
    
    nTimeBins = size(coordsTrajectory, 1);
    
    euclideanDistances = sqrt(sum((coordsTrajectory(2:end, :) - coordsTrajectory(1:(end - 1), :)) .^ 2, 2));
    euclideanDistances = [0; euclideanDistances];
    
    if all(euclideanDistances < 2),
        return;
    end

    for t = 2:nTimeBins,
%         euclideanDistance = norm(coordsTrajectory(t, :) - coordsTrajectory(t - 1, :));
        % Have any grid cells been skipped to get to the position at this
        % time?
        if euclideanDistances(t) >= 2,
            % If so, interpolate.
            nMissingCells = floor(euclideanDistances(t));
            yIncrement = (coordsTrajectory(t, 1) - coordsTrajectory(t - 1, 1)) / nMissingCells;
            xIncrement = (coordsTrajectory(t, 2) - coordsTrajectory(t - 1, 2)) / nMissingCells;
            for iMissingCell = 1:nMissingCells,
                newY = coordsTrajectory(t - 1, 1) + sign(yIncrement) * floor(iMissingCell * abs(yIncrement));
                newX = coordsTrajectory(t - 1, 2) + sign(xIncrement) * floor(iMissingCell * abs(xIncrement));
                validPositionsLogMat(newY, newX) = true;
            end
        end
    end
end