function output = sigfigs(x, sf)
    % Round a number to a prescribed number of significant figures.
    %
    % x : number (or vector) to round.
    % sf : number of significant figures desired.
    
    n = size(x, 1);
    m = size(x, 2);
    roundedX = zeros(n, m);
    y = x(x ~= 0);

    factor = 10 .^ floor(log10(abs(y)) - sf + 1);
    roundedX(x ~= 0) = round(y ./ factor) .* factor;
    
    output = roundedX;
end